/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.VectorXZ;

public class SimplePolygonXZ
extends PolygonXZ {
    private Double signedArea;
    private Double area;
    private Boolean clockwise;

    public SimplePolygonXZ(List<VectorXZ> list) {
        super(list);
        SimplePolygonXZ.assertLoopLength(list);
        SimplePolygonXZ.assertNotSelfIntersecting(list);
    }

    private void calculateArea() {
        this.signedArea = SimplePolygonXZ.calculateSignedArea(this.vertexLoop);
        this.area = Math.abs(this.signedArea);
        this.clockwise = this.signedArea < 0.0;
        this.assertNonzeroArea();
    }

    @Override
    public List<LineSegmentXZ> getSegments() {
        ArrayList<LineSegmentXZ> arrayList = new ArrayList<LineSegmentXZ>(this.vertexLoop.size());
        int n = 0;
        while (n + 1 < this.vertexLoop.size()) {
            arrayList.add(new LineSegmentXZ((VectorXZ)this.vertexLoop.get(n), (VectorXZ)this.vertexLoop.get(n + 1)));
            ++n;
        }
        return arrayList;
    }

    public double getArea() {
        if (this.area == null) {
            this.calculateArea();
        }
        return this.area;
    }

    public VectorXZ getCentroid() {
        if (this.signedArea == null) {
            this.calculateArea();
        }
        double d = 0.0;
        double d2 = 0.0;
        int n = this.vertexLoop.size() - 1;
        for (int i = 0; i < n; ++i) {
            double d3 = ((VectorXZ)this.vertexLoop.get((int)i)).x * ((VectorXZ)this.vertexLoop.get((int)(i + 1))).z - ((VectorXZ)this.vertexLoop.get((int)(i + 1))).x * ((VectorXZ)this.vertexLoop.get((int)i)).z;
            d += (((VectorXZ)this.vertexLoop.get((int)i)).x + ((VectorXZ)this.vertexLoop.get((int)(i + 1))).x) * d3;
            d2 += (((VectorXZ)this.vertexLoop.get((int)i)).z + ((VectorXZ)this.vertexLoop.get((int)(i + 1))).z) * d3;
        }
        double d4 = 1.0 / (6.0 * this.signedArea);
        return new VectorXZ(d4 * d, d4 * d2);
    }

    public boolean isClockwise() {
        if (this.area == null) {
            this.calculateArea();
        }
        return this.clockwise;
    }

    @Override
    public boolean isSelfIntersecting() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public SimplePolygonXZ asSimplePolygon() {
        return this;
    }

    public PolygonWithHolesXZ asPolygonWithHolesXZ() {
        return new PolygonWithHolesXZ(this, Collections.<SimplePolygonXZ>emptyList());
    }

    public SimplePolygonXZ makeClockwise() {
        return this.makeRotationSense(true);
    }

    public SimplePolygonXZ makeCounterclockwise() {
        return this.makeRotationSense(false);
    }

    private SimplePolygonXZ makeRotationSense(boolean bl) {
        if (this.isClockwise() ^ bl) {
            return this.reverse();
        }
        return this;
    }

    @Override
    public SimplePolygonXZ reverse() {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(this.vertexLoop);
        Collections.reverse(arrayList);
        return new SimplePolygonXZ(arrayList);
    }

    public static boolean contains(List<VectorXZ> list, VectorXZ vectorXZ) {
        SimplePolygonXZ.assertLoopProperty(list);
        boolean bl = false;
        int n = 0;
        int n2 = list.size() - 1;
        while (n < list.size()) {
            if (list.get((int)n).z > vectorXZ.z != list.get((int)n2).z > vectorXZ.z && vectorXZ.x < (list.get((int)n2).x - list.get((int)n).x) * (vectorXZ.z - list.get((int)n).z) / (list.get((int)n2).z - list.get((int)n).z) + list.get((int)n).x) {
                bl = !bl;
            }
            n2 = n++;
        }
        return bl;
    }

    public boolean contains(VectorXZ vectorXZ) {
        return SimplePolygonXZ.contains(this.vertexLoop, vectorXZ);
    }

    public boolean contains(PolygonXZ polygonXZ) {
        for (VectorXZ vectorXZ : polygonXZ.getVertices()) {
            if (this.contains(vectorXZ)) continue;
            return false;
        }
        return true;
    }

    public double distanceToSegments(VectorXZ vectorXZ) {
        double d = Double.MAX_VALUE;
        for (LineSegmentXZ lineSegmentXZ : this.getSegments()) {
            d = Math.min(d, GeometryUtil.distanceFromLineSegment(vectorXZ, lineSegmentXZ));
        }
        return d;
    }

    public SimplePolygonXZ getSimplifiedPolygon() {
        boolean[] blArray = new boolean[this.size()];
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            VectorXZ vectorXZ = this.getVertex(i).subtract(this.getVertexBefore(i));
            VectorXZ vectorXZ2 = this.getVertexAfter(i).subtract(this.getVertex(i));
            double d = vectorXZ.normalize().dot(vectorXZ2.normalize());
            if (!(Math.abs(d - 1.0) < 0.05)) continue;
            blArray[i] = true;
            ++n;
        }
        if (n == 0 || n > this.size() - 3) {
            return this;
        }
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(this.getVertices());
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!blArray[i]) continue;
            arrayList.remove(i);
        }
        arrayList.add((VectorXZ)arrayList.get(0));
        return new SimplePolygonXZ(arrayList);
    }

    private static double calculateSignedArea(List<VectorXZ> list) {
        double d = 0.0;
        int n = 0;
        while (n + 1 < list.size()) {
            d += list.get((int)n).x * list.get((int)(n + 1)).z;
            d -= list.get((int)(n + 1)).x * list.get((int)n).z;
            ++n;
        }
        return d / 2.0;
    }

    private static void assertLoopLength(List<VectorXZ> list) {
        if (list.size() <= 3) {
            throw new InvalidGeometryException("polygon needs more than 2 vertices\nPolygon vertex loop: " + list);
        }
    }

    private static void assertNotSelfIntersecting(List<VectorXZ> list) {
        if (SimplePolygonXZ.isSelfIntersecting(list)) {
            throw new InvalidGeometryException("polygon must not be self-intersecting\nPolygon vertices: " + list);
        }
    }

    private void assertNonzeroArea() {
        if (this.area == 0.0) {
            throw new InvalidGeometryException("a polygon's area must be positive, but it's " + this.area + " for this polygon.\nThis problem can be caused " + "by broken polygon data or imprecise calculations" + "\nPolygon vertices: " + this.vertexLoop);
        }
    }
}

