/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.osm2world.core.math.VectorXYZ;

public class TriangleXYZ {
    public final VectorXYZ v1;
    public final VectorXYZ v2;
    public final VectorXYZ v3;

    public TriangleXYZ(VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, VectorXYZ vectorXYZ3) {
        this.v1 = vectorXYZ;
        this.v2 = vectorXYZ2;
        this.v3 = vectorXYZ3;
    }

    public List<VectorXYZ> getVertices() {
        return ImmutableList.of(this.v1, this.v2, this.v3);
    }

    public VectorXYZ getNormal() {
        VectorXYZ vectorXYZ = this.v2.subtract(this.v1).cross(this.v2.subtract(this.v3));
        return vectorXYZ.normalize();
    }

    public VectorXYZ getCenter() {
        return new VectorXYZ((this.v1.x + this.v2.x + this.v3.x) / 3.0, (this.v1.y + this.v2.y + this.v3.y) / 3.0, (this.v1.z + this.v2.z + this.v3.z) / 3.0);
    }

    public String toString() {
        return "[" + this.v1.toString() + ", " + this.v2.toString() + ", " + this.v3.toString() + "]";
    }
}

