/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.VectorXZ;

public class TriangleXZ {
    public final VectorXZ v1;
    public final VectorXZ v2;
    public final VectorXZ v3;

    public TriangleXZ(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3) {
        this.v1 = vectorXZ;
        this.v2 = vectorXZ2;
        this.v3 = vectorXZ3;
    }

    public List<VectorXZ> getVertices() {
        return ImmutableList.of(this.v1, this.v2, this.v3);
    }

    public VectorXZ getCenter() {
        return new VectorXZ((this.v1.x + this.v2.x + this.v3.x) / 3.0, (this.v1.z + this.v2.z + this.v3.z) / 3.0);
    }

    public boolean contains(VectorXZ vectorXZ) {
        return SimplePolygonXZ.contains(Arrays.asList(this.v1, this.v2, this.v3, this.v1), vectorXZ);
    }

    public TriangleXYZ xyz(double d) {
        return new TriangleXYZ(this.v1.xyz(d), this.v2.xyz(d), this.v3.xyz(d));
    }

    public String toString() {
        return "[" + this.v1.toString() + ", " + this.v2.toString() + ", " + this.v3.toString() + "]";
    }

    public boolean isClockwise() {
        return GeometryUtil.isRightOf(this.v3, this.v1, this.v2);
    }

    public TriangleXZ makeClockwise() {
        return this.makeRotationSense(true);
    }

    public TriangleXZ makeCounterclockwise() {
        return this.makeRotationSense(false);
    }

    private TriangleXZ makeRotationSense(boolean bl) {
        if (this.isClockwise() ^ bl) {
            return this.reverse();
        }
        return this;
    }

    public TriangleXZ reverse() {
        return new TriangleXZ(this.v3, this.v2, this.v1);
    }
}

