/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXZ;

public class VectorXYZ
implements Vector3D {
    public final double x;
    public final double y;
    public final double z;
    public static final VectorXYZ NULL_VECTOR = new VectorXYZ(0.0, 0.0, 0.0);
    public static final VectorXYZ X_UNIT = new VectorXYZ(1.0, 0.0, 0.0);
    public static final VectorXYZ Y_UNIT = new VectorXYZ(0.0, 1.0, 0.0);
    public static final VectorXYZ Z_UNIT = new VectorXYZ(0.0, 0.0, 1.0);

    public VectorXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public VectorXYZ normalize() {
        double d = this.length();
        return new VectorXYZ(this.x / d, this.y / d, this.z / d);
    }

    public VectorXYZ add(VectorXYZ vectorXYZ) {
        return new VectorXYZ(this.x + vectorXYZ.x, this.y + vectorXYZ.y, this.z + vectorXYZ.z);
    }

    public VectorXYZ add(VectorXZ vectorXZ) {
        return new VectorXYZ(this.x + vectorXZ.x, this.y, this.z + vectorXZ.z);
    }

    public VectorXYZ add(double d, double d2, double d3) {
        return new VectorXYZ(this.x + d, this.y + d2, this.z + d3);
    }

    public VectorXYZ subtract(VectorXYZ vectorXYZ) {
        return new VectorXYZ(this.x - vectorXYZ.x, this.y - vectorXYZ.y, this.z - vectorXYZ.z);
    }

    public VectorXYZ subtract(VectorXZ vectorXZ) {
        return new VectorXYZ(this.x - vectorXZ.x, this.y, this.z - vectorXZ.z);
    }

    public VectorXYZ cross(VectorXYZ vectorXYZ) {
        return new VectorXYZ(this.y * vectorXYZ.z - this.z * vectorXYZ.y, this.z * vectorXYZ.x - this.x * vectorXYZ.z, this.x * vectorXYZ.y - this.y * vectorXYZ.x);
    }

    public double dot(VectorXYZ vectorXYZ) {
        return this.x * vectorXYZ.x + this.y * vectorXYZ.y + this.z * vectorXYZ.z;
    }

    public VectorXYZ mult(double d) {
        return new VectorXYZ(this.x * d, this.y * d, this.z * d);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public VectorXYZ rotateX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        return new VectorXYZ(this.x, this.y * d3 - this.z * d2, this.y * d2 + this.z * d3);
    }

    public VectorXYZ rotateY(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        return new VectorXYZ(d2 * this.z + d3 * this.x, this.y, d3 * this.z - d2 * this.x);
    }

    public VectorXYZ rotateZ(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        return new VectorXYZ(this.x * d3 - this.y * d2, this.x * d2 + this.y * d3, this.z);
    }

    public double angleTo(VectorXYZ vectorXYZ) {
        return Math.acos(this.dot(vectorXYZ));
    }

    public VectorXZ xz() {
        return new VectorXZ(this.x, this.z);
    }

    public static VectorXYZ xyz(VectorXYZ vectorXYZ) {
        if (vectorXYZ instanceof VectorXYZ) {
            return vectorXYZ;
        }
        return new VectorXYZ(vectorXYZ.getX(), vectorXYZ.getY(), vectorXYZ.getZ());
    }

    public VectorXYZ x(double d) {
        return new VectorXYZ(d, this.y, this.z);
    }

    public VectorXYZ y(double d) {
        return new VectorXYZ(this.x, d, this.z);
    }

    public VectorXYZ z(double d) {
        return new VectorXYZ(this.x, this.y, d);
    }

    public VectorXYZ invert() {
        return new VectorXYZ(-this.x, -this.y, -this.z);
    }

    public boolean equals(Object object) {
        if (!(object instanceof VectorXYZ)) {
            return false;
        }
        VectorXYZ vectorXYZ = (VectorXYZ)object;
        return this.x == vectorXYZ.x && this.y == vectorXYZ.y && this.z == vectorXYZ.z;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

