/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXYZ;

public class VectorXZ
implements Vector3D {
    public final double x;
    public final double z;
    public static final VectorXZ NULL_VECTOR = new VectorXZ(0.0, 0.0);
    public static final VectorXZ X_UNIT = new VectorXZ(1.0, 0.0);
    public static final VectorXZ Z_UNIT = new VectorXZ(0.0, 1.0);

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public VectorXZ(double d, double d2) {
        this.x = d;
        this.z = d2;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.z * this.z);
    }

    public double lengthSquared() {
        return this.x * this.x + this.z * this.z;
    }

    public VectorXZ normalize() {
        double d = this.length();
        return new VectorXZ(this.x / d, this.z / d);
    }

    public VectorXZ add(VectorXZ vectorXZ) {
        return new VectorXZ(this.x + vectorXZ.x, this.z + vectorXZ.z);
    }

    public VectorXZ subtract(VectorXZ vectorXZ) {
        return new VectorXZ(this.x - vectorXZ.x, this.z - vectorXZ.z);
    }

    public VectorXZ mult(double d) {
        return new VectorXZ(this.x * d, this.z * d);
    }

    public VectorXZ invert() {
        return new VectorXZ(-this.x, -this.z);
    }

    public double dot(VectorXZ vectorXZ) {
        return this.x * vectorXZ.x + this.z * vectorXZ.z;
    }

    public VectorXZ rightNormal() {
        double d = this.length();
        return new VectorXZ(this.z / d, -(this.x / d));
    }

    public double distanceTo(VectorXZ vectorXZ) {
        return VectorXZ.distance(this, vectorXZ);
    }

    public String toString() {
        return "(" + this.x + "," + this.z + ")";
    }

    public VectorXYZ xyz(double d) {
        return new VectorXYZ(this.x, d, this.z);
    }

    public boolean equals(Object object) {
        if (!(object instanceof VectorXZ)) {
            return false;
        }
        VectorXZ vectorXZ = (VectorXZ)object;
        return this.x == vectorXZ.x && this.z == vectorXZ.z;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public static VectorXZ fromAngle(double d) {
        return new VectorXZ(Math.sin(d), Math.cos(d));
    }

    public static final double distance(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        return vectorXZ2.subtract(vectorXZ).length();
    }

    public static final double distanceSquared(VectorXZ vectorXZ, VectorXZ vectorXZ2) {
        return vectorXZ2.subtract(vectorXZ).lengthSquared();
    }

    public static final List<VectorXYZ> listXYZ(List<VectorXZ> list, double d) {
        return Lists.transform(list, VectorXZ.xyzFunction(d));
    }

    public static final Function<VectorXZ, Double> distanceFunction(final VectorXZ vectorXZ) {
        return new Function<VectorXZ, Double>(){

            @Override
            public Double apply(VectorXZ vectorXZ2) {
                return VectorXZ.distance(vectorXZ, vectorXZ2);
            }
        };
    }

    public static final Function<VectorXZ, VectorXYZ> xyzFunction(final double d) {
        return new Function<VectorXZ, VectorXYZ>(){

            @Override
            public VectorXYZ apply(VectorXZ vectorXZ) {
                return vectorXZ.xyz(d);
            }
        };
    }
}

