/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXZ;

public final class EarClippingTriangulationUtil {
    private EarClippingTriangulationUtil() {
    }

    public static final List<TriangleXZ> triangulate(SimplePolygonXZ simplePolygonXZ, Collection<SimplePolygonXZ> collection) {
        LinkedList<VectorXZ> linkedList = new LinkedList<VectorXZ>(simplePolygonXZ.getVertexLoop());
        EarClippingTriangulationUtil.insertHolesInPolygonOutline(linkedList, collection);
        if (linkedList.size() >= 3) {
            return EarClippingTriangulationUtil.triangulateSimplePolygon(linkedList);
        }
        return Collections.emptyList();
    }

    public static void insertHolesInPolygonOutline(List<VectorXZ> list, Collection<SimplePolygonXZ> collection) {
        LinkedList<SimplePolygonXZ> linkedList = new LinkedList<SimplePolygonXZ>(collection);
        while (!linkedList.isEmpty()) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                SimplePolygonXZ simplePolygonXZ = (SimplePolygonXZ)iterator.next();
                boolean bl = EarClippingTriangulationUtil.insertHoleInPolygonOutline(list, simplePolygonXZ, linkedList);
                if (!bl) continue;
                iterator.remove();
            }
        }
    }

    static final boolean insertHoleInPolygonOutline(List<VectorXZ> list, SimplePolygonXZ simplePolygonXZ, List<SimplePolygonXZ> list2) {
        int n;
        Integer n2 = null;
        List<VectorXZ> list3 = simplePolygonXZ.getVertices();
        for (n = 0; n < list3.size() && (n2 = EarClippingTriangulationUtil.findVisibleOutlineVertex(list, list3.get(n), list2)) == null; ++n) {
        }
        if (n2 == null) {
            return false;
        }
        SimplePolygonXZ simplePolygonXZ2 = new SimplePolygonXZ(new ArrayList<VectorXZ>(list));
        list.add(n2 + 1, list.get(n2));
        if (simplePolygonXZ.isClockwise() ^ simplePolygonXZ2.isClockwise()) {
            list.addAll(n2 + 1, EarClippingTriangulationUtil.rearrangeOutline(simplePolygonXZ.getVertexLoop(), n, false));
        } else {
            list.addAll(n2 + 1, EarClippingTriangulationUtil.rearrangeOutline(simplePolygonXZ.getVertexLoop(), n, true));
        }
        return true;
    }

    static final List<VectorXZ> rearrangeOutline(List<VectorXZ> list, int n, boolean bl) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(list.size());
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = n;
        while (!bl2) {
            if (n2 == 0 || n2 == list.size() - 1) {
                if (!bl3) {
                    arrayList.add(list.get(0));
                    bl3 = true;
                }
            } else {
                arrayList.add(list.get(n2));
            }
            if (!bl) {
                if (++n2 >= list.size()) {
                    n2 = 0;
                }
            } else if (--n2 < 0) {
                n2 = list.size() - 1;
            }
            if (n2 != n) continue;
            bl2 = true;
        }
        arrayList.add(list.get(n));
        return arrayList;
    }

    static final void insertVertexInPolygonOutline(List<VectorXZ> list, VectorXZ vectorXZ) {
        int n = EarClippingTriangulationUtil.findVisibleOutlineVertex(list, vectorXZ, Collections.<SimplePolygonXZ>emptyList());
        list.add(n + 1, vectorXZ);
        list.add(n + 2, list.get(n));
    }

    static final Integer findVisibleOutlineVertex(List<VectorXZ> list, VectorXZ vectorXZ, Iterable<SimplePolygonXZ> iterable) {
        int n = -1;
        block0: for (VectorXZ vectorXZ2 : list) {
            ++n;
            int n2 = 0;
            while (n2 + 1 < list.size()) {
                if (null != GeometryUtil.getTrueLineSegmentIntersection(vectorXZ, vectorXZ2, list.get(n2), list.get(n2 + 1))) continue block0;
                ++n2;
            }
            for (SimplePolygonXZ simplePolygonXZ : iterable) {
                if (!simplePolygonXZ.intersects(vectorXZ, vectorXZ2)) continue;
                continue block0;
            }
            return n;
        }
        return null;
    }

    private static void simplifyOutline(List<VectorXZ> list) {
        int n;
        list.remove(list.size() - 1);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n = 0; n < list.size(); ++n) {
            LineSegmentXZ lineSegmentXZ = new LineSegmentXZ(EarClippingTriangulationUtil.vertexBefore(list, n), EarClippingTriangulationUtil.vertexAfter(list, n));
            if (!(GeometryUtil.distanceFromLineSegment(list.get(n), lineSegmentXZ) < 0.001)) continue;
            hashSet.add(n);
        }
        for (n = list.size(); n >= 0; --n) {
            if (!hashSet.contains(n)) continue;
            System.out.println("simplify removes vertex #" + n + " in outline: " + list);
            list.remove(n);
        }
        list.add(list.get(0));
    }

    static final List<TriangleXZ> triangulateSimplePolygon(List<VectorXZ> list) {
        if (list.size() == 3) {
            return Collections.singletonList(new TriangleXZ(list.get(1), list.get(2), list.get(3)));
        }
        list.remove(0);
        ArrayList<TriangleXZ> arrayList = new ArrayList<TriangleXZ>(list.size() - 2);
        boolean bl = true;
        block0: while (list.size() >= 3 && bl) {
            bl = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!EarClippingTriangulationUtil.isEarTip(i, list)) continue;
                arrayList.add(EarClippingTriangulationUtil.triangleAtTip(i, list));
                list.remove(i);
                bl = true;
                continue block0;
            }
        }
        if (list.size() >= 3) {
            throw new InvalidGeometryException("failed to triangulate outline.\nRemaining: " + list + "\nTriangles: " + arrayList);
        }
        return arrayList;
    }

    static boolean isEarTip(int n, List<VectorXZ> list) {
        if (EarClippingTriangulationUtil.isConvex(n, list)) {
            TriangleXZ triangleXZ = EarClippingTriangulationUtil.triangleAtTip(n, list);
            for (VectorXZ vectorXZ : list) {
                if (vectorXZ == triangleXZ.v1 || vectorXZ == triangleXZ.v2 || vectorXZ == triangleXZ.v3 || !triangleXZ.contains(vectorXZ)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean isConvex(int n, List<VectorXZ> list) {
        ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(list);
        arrayList.add(list.get(0));
        SimplePolygonXZ simplePolygonXZ = new SimplePolygonXZ(arrayList);
        VectorXZ vectorXZ = list.get(n).subtract(EarClippingTriangulationUtil.vertexBefore(list, n));
        VectorXZ vectorXZ2 = EarClippingTriangulationUtil.vertexAfter(list, n).subtract(list.get(n));
        return simplePolygonXZ.isClockwise() ^ vectorXZ.z * vectorXZ2.x - vectorXZ.x * vectorXZ2.z < 0.0;
    }

    static final TriangleXZ triangleAtTip(int n, List<VectorXZ> list) {
        return new TriangleXZ(EarClippingTriangulationUtil.vertexBefore(list, n), list.get(n), EarClippingTriangulationUtil.vertexAfter(list, n));
    }

    private static final VectorXZ vertexBefore(List<VectorXZ> list, int n) {
        int n2 = EarClippingTriangulationUtil.indexBefore(list, n);
        return list.get(n2);
    }

    private static int indexBefore(List<VectorXZ> list, int n) {
        return (list.size() + n - 1) % list.size();
    }

    private static final VectorXZ vertexAfter(List<VectorXZ> list, int n) {
        int n2 = EarClippingTriangulationUtil.indexAfter(list, n);
        return list.get(n2);
    }

    private static int indexAfter(List<VectorXZ> list, int n) {
        return (n + 1) % list.size();
    }

    static final Collection<SimplePolygonXZ> splitAlong(SimplePolygonXZ simplePolygonXZ, Collection<VectorXZ[]> collection) {
        ArrayList<SimplePolygonXZ> arrayList = new ArrayList<SimplePolygonXZ>(1);
        arrayList.add(simplePolygonXZ);
        for (VectorXZ[] vectorXZArray : collection) {
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            for (SimplePolygonXZ simplePolygonXZ2 : arrayList) {
                int n = 0;
                while (n + 1 < vectorXZArray.length) {
                    ++n;
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }
}

