/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math.algorithms;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.JTSConversionUtil;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXZ;

public final class JTSTriangulationUtil {
    private static final Geometry[] EMPTY_GEOM_ARRAY = new Geometry[0];

    private JTSTriangulationUtil() {
    }

    public static final List<TriangleXZ> triangulate(SimplePolygonXZ simplePolygonXZ, Collection<SimplePolygonXZ> collection) {
        List<VectorXZ> list = Collections.emptyList();
        List<LineSegmentXZ> list2 = Collections.emptyList();
        return JTSTriangulationUtil.triangulate(simplePolygonXZ, collection, list2, list);
    }

    public static final List<TriangleXZ> triangulate(SimplePolygonXZ simplePolygonXZ, Collection<SimplePolygonXZ> collection, Collection<LineSegmentXZ> collection2, Collection<VectorXZ> collection3) {
        Cloneable cloneable;
        ConformingDelaunayTriangulationBuilder conformingDelaunayTriangulationBuilder = new ConformingDelaunayTriangulationBuilder();
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>(1 + collection.size() + collection2.size());
        arrayList.add(JTSConversionUtil.polygonXZToJTSPolygon(simplePolygonXZ));
        for (SimplePolygonXZ object22 : collection) {
            arrayList.add(JTSConversionUtil.polygonXZToJTSPolygon(object22));
        }
        for (LineSegmentXZ lineSegmentXZ : collection2) {
            arrayList.add(JTSConversionUtil.lineSegmentXZToJTSLineString(lineSegmentXZ));
        }
        ArrayList arrayList2 = new ArrayList();
        for (VectorXZ vectorXZ : collection3) {
            cloneable = new CoordinateArraySequence(new Coordinate[]{JTSConversionUtil.vectorXZToJTSCoordinate(vectorXZ)});
            arrayList2.add(new Point((CoordinateSequence)cloneable, JTSConversionUtil.GF));
        }
        conformingDelaunayTriangulationBuilder.setSites(new GeometryCollection(arrayList2.toArray(EMPTY_GEOM_ARRAY), JTSConversionUtil.GF));
        conformingDelaunayTriangulationBuilder.setConstraints(new GeometryCollection(arrayList.toArray(EMPTY_GEOM_ARRAY), JTSConversionUtil.GF));
        conformingDelaunayTriangulationBuilder.setTolerance(0.01);
        Geometry geometry = conformingDelaunayTriangulationBuilder.getTriangles(JTSConversionUtil.GF);
        Collection<PolygonWithHolesXZ> collection4 = JTSConversionUtil.polygonsXZFromJTSGeometry(geometry);
        cloneable = new ArrayList();
        for (PolygonWithHolesXZ polygonWithHolesXZ : collection4) {
            boolean bl = false;
            for (SimplePolygonXZ simplePolygonXZ2 : collection) {
                if (!simplePolygonXZ2.contains(polygonWithHolesXZ.getOuter().getCenter())) continue;
                bl = true;
                break;
            }
            if (bl || !simplePolygonXZ.contains(polygonWithHolesXZ.getOuter().getCenter())) continue;
            cloneable.add(polygonWithHolesXZ.asTriangleXZ());
        }
        return cloneable;
    }
}

