/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXYZWithNormals;
import org.osm2world.core.math.VectorXYZ;

public final class NormalCalculationUtil {
    private static final double MAX_ANGLE_RADIANS = Math.toRadians(75.0);

    private NormalCalculationUtil() {
    }

    public static final VectorXYZ[] calculateTriangleNormals(List<? extends VectorXYZ> list, boolean bl) {
        assert (list.size() % 3 == 0);
        VectorXYZ[] vectorXYZArray = new VectorXYZ[list.size()];
        for (int i = 0; i < list.size() / 3; ++i) {
            int n = i * 3 + 1;
            VectorXYZ vectorXYZ = list.get(n - 1);
            VectorXYZ vectorXYZ2 = list.get(n);
            VectorXYZ vectorXYZ3 = list.get(n + 1);
            vectorXYZArray[n] = vectorXYZ.subtract(vectorXYZ2).cross(vectorXYZ3.subtract(vectorXYZ2)).normalize();
            vectorXYZArray[n - 1] = vectorXYZArray[n];
            vectorXYZArray[n + 1] = vectorXYZArray[n];
        }
        return vectorXYZArray;
    }

    public static final VectorXYZ[] calculateTriangleStripNormals(List<? extends VectorXYZ> list, boolean bl) {
        assert (list.size() > 3);
        VectorXYZ[] vectorXYZArray = NormalCalculationUtil.calculateTriangleFanNormals(list, false);
        for (int i = 0; i < list.size() - 2; ++i) {
            if (i % 2 != 1) continue;
            vectorXYZArray[2 + i] = vectorXYZArray[2 + i].invert();
        }
        return vectorXYZArray;
    }

    public static final VectorXYZ[] calculateTriangleFanNormals(List<? extends VectorXYZ> list, boolean bl) {
        assert (list.size() > 3);
        VectorXYZ[] vectorXYZArray = new VectorXYZ[list.size()];
        for (int i = 0; i < list.size() - 2; ++i) {
            int n = i + 1;
            VectorXYZ vectorXYZ = list.get(n - 1);
            VectorXYZ vectorXYZ2 = list.get(n);
            VectorXYZ vectorXYZ3 = list.get(n + 1);
            vectorXYZArray[n + 1] = vectorXYZ.subtract(vectorXYZ2).cross(vectorXYZ3.subtract(vectorXYZ2)).normalize();
        }
        vectorXYZArray[0] = VectorXYZ.NULL_VECTOR;
        vectorXYZArray[1] = VectorXYZ.NULL_VECTOR;
        return vectorXYZArray;
    }

    public static final Collection<TriangleXYZWithNormals> calculateTrianglesWithNormals(Collection<TriangleXYZ> collection) {
        Map<VectorXYZ, List<TriangleXYZ>> map = NormalCalculationUtil.calculateAdjacentTriangles(collection);
        ArrayList<TriangleXYZWithNormals> arrayList = new ArrayList<TriangleXYZWithNormals>(collection.size());
        for (TriangleXYZ triangleXYZ : collection) {
            arrayList.add(new TriangleXYZWithNormals(triangleXYZ, NormalCalculationUtil.calculateNormal(triangleXYZ.v1, triangleXYZ, map), NormalCalculationUtil.calculateNormal(triangleXYZ.v2, triangleXYZ, map), NormalCalculationUtil.calculateNormal(triangleXYZ.v3, triangleXYZ, map)));
        }
        return arrayList;
    }

    private static VectorXYZ calculateNormal(VectorXYZ vectorXYZ, TriangleXYZ triangleXYZ, Map<VectorXYZ, List<TriangleXYZ>> map) {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        for (TriangleXYZ object : map.get(vectorXYZ)) {
            if (triangleXYZ != object && !(triangleXYZ.getNormal().angleTo(object.getNormal()) <= MAX_ANGLE_RADIANS)) continue;
            boolean bl = true;
            for (VectorXYZ vectorXYZ2 : arrayList) {
                if (!(vectorXYZ2.angleTo(object.getNormal()) < 0.01)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(object.getNormal());
        }
        Object object = new VectorXYZ(0.0, 0.0, 0.0);
        for (VectorXYZ vectorXYZ3 : arrayList) {
            object = ((VectorXYZ)object).add(vectorXYZ3);
        }
        return ((VectorXYZ)object).normalize();
    }

    private static Map<VectorXYZ, List<TriangleXYZ>> calculateAdjacentTriangles(Collection<TriangleXYZ> collection) {
        HashMap<VectorXYZ, List<TriangleXYZ>> hashMap = new HashMap<VectorXYZ, List<TriangleXYZ>>();
        for (TriangleXYZ triangleXYZ : collection) {
            for (VectorXYZ vectorXYZ : triangleXYZ.getVertices()) {
                ArrayList<TriangleXYZ> arrayList = (ArrayList<TriangleXYZ>)hashMap.get(vectorXYZ);
                if (arrayList == null) {
                    arrayList = new ArrayList<TriangleXYZ>();
                    hashMap.put(vectorXYZ, arrayList);
                }
                arrayList.add(triangleXYZ);
            }
        }
        return hashMap;
    }
}

