/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math.algorithms;

import com.vividsolutions.jts.triangulate.ConstraintEnforcementException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.EarClippingTriangulationUtil;
import org.osm2world.core.math.algorithms.JTSTriangulationUtil;

public class TriangulationUtil {
    public static final List<TriangleXZ> triangulate(SimplePolygonXZ simplePolygonXZ, Collection<SimplePolygonXZ> collection, Collection<VectorXZ> collection2) {
        if (collection2.isEmpty()) {
            try {
                return EarClippingTriangulationUtil.triangulate(simplePolygonXZ, collection);
            }
            catch (InvalidGeometryException invalidGeometryException) {
                // empty catch block
            }
        }
        try {
            return JTSTriangulationUtil.triangulate(simplePolygonXZ, collection, Collections.<LineSegmentXZ>emptyList(), collection2);
        }
        catch (ConstraintEnforcementException constraintEnforcementException) {
            constraintEnforcementException.printStackTrace();
            System.err.println("outer: " + simplePolygonXZ);
            System.err.println("holes: " + collection);
            System.err.println("JTS triangulation failed, returning empty list");
            return Collections.emptyList();
        }
    }

    public static final List<TriangleXZ> triangulate(SimplePolygonXZ simplePolygonXZ, Collection<SimplePolygonXZ> collection) {
        return TriangulationUtil.triangulate(simplePolygonXZ, collection, Collections.<VectorXZ>emptyList());
    }

    public static final List<TriangleXZ> triangulate(PolygonWithHolesXZ polygonWithHolesXZ, Collection<VectorXZ> collection) {
        return TriangulationUtil.triangulate(polygonWithHolesXZ.getOuter(), polygonWithHolesXZ.getHoles(), collection);
    }

    public static final List<TriangleXZ> triangulate(PolygonWithHolesXZ polygonWithHolesXZ) {
        return TriangulationUtil.triangulate(polygonWithHolesXZ.getOuter(), polygonWithHolesXZ.getHoles());
    }
}

