/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.math.datastructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.datastructures.IntersectionTestObject;

public class IntersectionGrid {
    private final AxisAlignedBoundingBoxXZ gridBounds;
    private Collection<IntersectionTestObject>[][] cells;
    private final int cellCountX;
    private final int cellCountZ;
    private final double cellSizeX;
    private final double cellSizeZ;

    public IntersectionGrid(AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ, int n, int n2) {
        this.gridBounds = axisAlignedBoundingBoxXZ;
        Collection[][] collectionArray = new Collection[n][n2];
        this.cells = collectionArray;
        this.cellCountX = n;
        this.cellCountZ = n2;
        this.cellSizeX = axisAlignedBoundingBoxXZ.sizeX() / (double)n;
        this.cellSizeZ = axisAlignedBoundingBoxXZ.sizeZ() / (double)n2;
    }

    public IntersectionGrid(AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ, double d, double d2) {
        this(axisAlignedBoundingBoxXZ, (int)(axisAlignedBoundingBoxXZ.sizeX() / d) + 1, (int)(axisAlignedBoundingBoxXZ.sizeZ() / d2) + 1);
    }

    public Collection<IntersectionTestObject>[][] getCellArray() {
        return this.cells;
    }

    public Iterable<Collection<IntersectionTestObject>> getCells() {
        return new Iterable<Collection<IntersectionTestObject>>(){

            @Override
            public Iterator<Collection<IntersectionTestObject>> iterator() {
                return new CellIterator();
            }
        };
    }

    public Collection<Collection<IntersectionTestObject>> cellsFor(IntersectionTestObject intersectionTestObject) {
        assert (this.gridBounds.contains(intersectionTestObject));
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = intersectionTestObject.getAxisAlignedBoundingBoxXZ();
        int n = this.cellXForCoord(axisAlignedBoundingBoxXZ.minX, axisAlignedBoundingBoxXZ.minZ);
        int n2 = this.cellZForCoord(axisAlignedBoundingBoxXZ.minX, axisAlignedBoundingBoxXZ.minZ);
        int n3 = this.cellXForCoord(axisAlignedBoundingBoxXZ.maxX, axisAlignedBoundingBoxXZ.maxZ);
        int n4 = this.cellZForCoord(axisAlignedBoundingBoxXZ.maxX, axisAlignedBoundingBoxXZ.maxZ);
        ArrayList<Collection<IntersectionTestObject>> arrayList = new ArrayList<Collection<IntersectionTestObject>>((n3 - n) * (n4 - n2));
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                if (this.cells[i][j] == null) continue;
                arrayList.add(this.cells[i][j]);
            }
        }
        return arrayList;
    }

    public void insert(IntersectionTestObject intersectionTestObject) {
        assert (this.gridBounds.contains(intersectionTestObject));
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = intersectionTestObject.getAxisAlignedBoundingBoxXZ();
        int n = this.cellXForCoord(axisAlignedBoundingBoxXZ.minX, axisAlignedBoundingBoxXZ.minZ);
        int n2 = this.cellZForCoord(axisAlignedBoundingBoxXZ.minX, axisAlignedBoundingBoxXZ.minZ);
        int n3 = this.cellXForCoord(axisAlignedBoundingBoxXZ.maxX, axisAlignedBoundingBoxXZ.maxZ);
        int n4 = this.cellZForCoord(axisAlignedBoundingBoxXZ.maxX, axisAlignedBoundingBoxXZ.maxZ);
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                this.addToCell(i, j, intersectionTestObject);
            }
        }
    }

    private void addToCell(int n, int n2, IntersectionTestObject intersectionTestObject) {
        if (this.cells[n][n2] == null) {
            this.cells[n][n2] = new ArrayList<IntersectionTestObject>();
        }
        this.cells[n][n2].add(intersectionTestObject);
    }

    private final int cellXForCoord(double d, double d2) {
        return (int)((d - this.gridBounds.minX) / this.cellSizeX);
    }

    private final int cellZForCoord(double d, double d2) {
        return (int)((d2 - this.gridBounds.minZ) / this.cellSizeZ);
    }

    private class CellIterator
    implements Iterator<Collection<IntersectionTestObject>> {
        int x = 0;
        int z = -1;

        public CellIterator() {
            this.toNext();
        }

        @Override
        public boolean hasNext() {
            return this.x < IntersectionGrid.this.cellCountX;
        }

        @Override
        public Collection<IntersectionTestObject> next() {
            Collection collection = IntersectionGrid.this.cells[this.x][this.z];
            this.toNext();
            return collection;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void toNext() {
            do {
                ++this.z;
                if (this.z < IntersectionGrid.this.cellCountZ) continue;
                this.z = 0;
                ++this.x;
            } while (this.x < IntersectionGrid.this.cellCountX && IntersectionGrid.this.cells[this.x][this.z] == null);
        }
    }
}

