/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.osm.creation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.EmptyTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.MapBasedTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlReader;
import org.osm2world.core.osm.creation.OSMDataReader;
import org.osm2world.core.osm.data.OSMData;
import org.osm2world.core.osm.data.OSMElement;
import org.osm2world.core.osm.data.OSMMember;
import org.osm2world.core.osm.data.OSMNode;
import org.osm2world.core.osm.data.OSMRelation;
import org.osm2world.core.osm.data.OSMWay;

public class OsmosisReader
implements OSMDataReader {
    private boolean complete = false;
    private Map<Long, Node> nodesById = new HashMap<Long, Node>();
    private Map<Long, Way> waysById = new HashMap<Long, Way>();
    private Map<Long, Relation> relationsById = new HashMap<Long, Relation>();
    private Collection<OSMNode> ownNodes;
    private Collection<OSMWay> ownWays;
    private Collection<OSMRelation> ownRelations;
    private final Sink sinkImplementation = new Sink(){

        @Override
        public void release() {
        }

        @Override
        public void complete() {
            OsmosisReader.this.setCompleteTrue();
        }

        @Override
        public void process(EntityContainer entityContainer) {
            Entity entity = entityContainer.getEntity();
            if (entity instanceof Node) {
                OsmosisReader.this.nodesById.put(entity.getId(), (Node)entity);
            } else if (entity instanceof Way) {
                OsmosisReader.this.waysById.put(entity.getId(), (Way)entity);
            } else if (entity instanceof Relation) {
                OsmosisReader.this.relationsById.put(entity.getId(), (Relation)entity);
            }
        }
    };

    private synchronized boolean isComplete() {
        return this.complete;
    }

    private synchronized void setCompleteTrue() {
        this.complete = true;
    }

    public OsmosisReader(File file) throws IOException {
        boolean bl = false;
        CompressionMethod compressionMethod = CompressionMethod.None;
        if (file.getName().endsWith(".pbf")) {
            bl = true;
        } else if (file.getName().endsWith(".gz")) {
            compressionMethod = CompressionMethod.GZip;
        } else if (file.getName().endsWith(".bz2")) {
            compressionMethod = CompressionMethod.BZip2;
        }
        RunnableSource runnableSource = bl ? new crosby.binary.osmosis.OsmosisReader(new FileInputStream(file)) : new XmlReader(file, false, compressionMethod);
        runnableSource.setSink(this.sinkImplementation);
        Thread thread = new Thread(runnableSource);
        thread.start();
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isComplete()) {
            throw new IOException("couldn't read from file");
        }
        this.convertToOwnRepresentation();
    }

    private void convertToOwnRepresentation() {
        Object object;
        Object object2;
        Object object3;
        this.ownNodes = new ArrayList<OSMNode>(this.nodesById.size());
        this.ownWays = new ArrayList<OSMWay>(this.waysById.size());
        this.ownRelations = new ArrayList<OSMRelation>(this.relationsById.size());
        HashMap<Node, Object> hashMap = new HashMap<Node, Object>();
        HashMap<Way, OSMWay> hashMap2 = new HashMap<Way, OSMWay>();
        HashMap<Relation, Object> hashMap3 = new HashMap<Relation, Object>();
        for (Node entity : this.nodesById.values()) {
            object3 = new OSMNode(entity.getLatitude(), entity.getLongitude(), this.tagGroupForEntity(entity), entity.getId());
            this.ownNodes.add((OSMNode)object3);
            hashMap.put(entity, object3);
        }
        for (Way way : this.waysById.values()) {
            object3 = way.getWayNodes();
            ArrayList<OSMNode> arrayList = new ArrayList<OSMNode>(object3.size());
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (WayNode)iterator.next();
                object = this.nodesById.get(((WayNode)object2).getNodeId());
                if (object == null) continue;
                arrayList.add((OSMNode)hashMap.get(object));
            }
            OSMWay oSMWay = new OSMWay(this.tagGroupForEntity(way), way.getId(), arrayList);
            this.ownWays.add(oSMWay);
            hashMap2.put(way, oSMWay);
        }
        for (Relation relation : this.relationsById.values()) {
            object3 = new OSMRelation(this.tagGroupForEntity(relation), relation.getId(), relation.getMembers().size());
            this.ownRelations.add((OSMRelation)object3);
            hashMap3.put(relation, object3);
        }
        for (Relation relation : hashMap3.keySet()) {
            object3 = (OSMRelation)hashMap3.get(relation);
            for (RelationMember relationMember : relation.getMembers()) {
                object2 = null;
                if (relationMember.getMemberType() == EntityType.Node) {
                    object2 = (OSMElement)hashMap.get(this.nodesById.get(relationMember.getMemberId()));
                } else if (relationMember.getMemberType() == EntityType.Way) {
                    object2 = (OSMElement)hashMap2.get(this.waysById.get(relationMember.getMemberId()));
                } else {
                    if (relationMember.getMemberType() != EntityType.Relation) continue;
                    object2 = (OSMElement)hashMap3.get(this.relationsById.get(relationMember.getMemberId()));
                }
                if (object2 == null) continue;
                object = new OSMMember(relationMember.getMemberRole(), (OSMElement)object2);
                ((OSMRelation)object3).relationMembers.add((OSMMember)object);
            }
        }
        this.nodesById = null;
        this.waysById = null;
        this.relationsById = null;
    }

    private TagGroup tagGroupForEntity(Entity entity) {
        if (entity.getTags().isEmpty()) {
            return EmptyTagGroup.EMPTY_TAG_GROUP;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(entity.getTags().size());
        for (Tag tag : entity.getTags()) {
            hashMap.put(tag.getKey(), tag.getValue());
        }
        return new MapBasedTagGroup(hashMap);
    }

    @Override
    public OSMData getData() {
        return new OSMData(this.ownNodes, this.ownWays, this.ownRelations);
    }
}

