/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target;

import java.util.Iterator;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.target.Renderable;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.RenderableToPrimitiveTarget;
import org.osm2world.core.target.statistics.StatisticsTarget;
import org.osm2world.core.util.FaultTolerantIterationUtil;
import org.osm2world.core.world.data.WorldObject;

public final class TargetUtil {
    private TargetUtil() {
    }

    public static <R extends Renderable> void renderWorldObjects(final Target<R> target, MapData mapData) {
        FaultTolerantIterationUtil.iterate(mapData.getMapElements(), new FaultTolerantIterationUtil.Operation<MapElement>(){

            @Override
            public void perform(MapElement mapElement) {
                for (WorldObject worldObject : mapElement.getRepresentations()) {
                    TargetUtil.renderObject(target, worldObject);
                }
            }
        });
    }

    public static <R extends RenderableToPrimitiveTarget> void renderWorldObjects(final Iterator<? extends Target<R>> iterator, MapData mapData, final int n) {
        final StatisticsTarget statisticsTarget = new StatisticsTarget();
        FaultTolerantIterationUtil.iterate(mapData.getMapElements(), new FaultTolerantIterationUtil.Operation<MapElement>(){
            Target<R> currentTarget;
            {
                this.currentTarget = (Target)iterator.next();
            }

            @Override
            public void perform(MapElement mapElement) {
                for (WorldObject worldObject : mapElement.getRepresentations()) {
                    TargetUtil.renderObject(statisticsTarget, worldObject);
                    TargetUtil.renderObject(this.currentTarget, worldObject);
                    if (statisticsTarget.getGlobalCount(StatisticsTarget.Stat.PRIMITIVE_COUNT) < (long)n) continue;
                    this.currentTarget = (Target)iterator.next();
                    statisticsTarget.clear();
                }
            }
        });
    }

    public static final <R extends Renderable> void renderObject(Target<R> target, Object object) {
        Class<R> clazz = target.getRenderableType();
        if (clazz.isInstance(object)) {
            if (object instanceof WorldObject) {
                target.beginObject((WorldObject)object);
            } else {
                target.beginObject(null);
            }
            target.render((Renderable)clazz.cast(object));
        } else if (object instanceof RenderableToAllTargets) {
            if (object instanceof WorldObject) {
                target.beginObject((WorldObject)object);
            } else {
                target.beginObject(null);
            }
            ((RenderableToAllTargets)object).renderTo(target);
        }
    }
}

