/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.Renderable;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.world.data.WorldObject;

public abstract class AbstractTarget<R extends Renderable>
implements Target<R> {
    protected Configuration config;
    private static final int EDGES_FOR_CYLINDER = 16;

    @Override
    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    @Override
    public void beginObject(WorldObject worldObject) {
    }

    @Override
    public void drawBox(Material material, VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, VectorXYZ vectorXYZ3, VectorXYZ vectorXYZ4) {
        VectorXYZ vectorXYZ5 = vectorXYZ.add(vectorXYZ2);
        VectorXYZ vectorXYZ6 = vectorXYZ.add(vectorXYZ3);
        VectorXYZ vectorXYZ7 = vectorXYZ5.add(vectorXYZ3);
        VectorXYZ vectorXYZ8 = vectorXYZ.add(vectorXYZ4);
        VectorXYZ vectorXYZ9 = vectorXYZ5.add(vectorXYZ4);
        VectorXYZ vectorXYZ10 = vectorXYZ6.add(vectorXYZ4);
        VectorXYZ vectorXYZ11 = vectorXYZ7.add(vectorXYZ4);
        this.drawTriangleStrip(material, vectorXYZ, vectorXYZ5, vectorXYZ6, vectorXYZ7, vectorXYZ10, vectorXYZ11, vectorXYZ8, vectorXYZ9);
        this.drawTriangleStrip(material, vectorXYZ11, vectorXYZ7, vectorXYZ9, vectorXYZ5, vectorXYZ8, vectorXYZ, vectorXYZ10, vectorXYZ6);
    }

    @Override
    public void drawBox(Material material, VectorXYZ vectorXYZ, VectorXZ vectorXZ, double d, double d2, double d3) {
        VectorXYZ vectorXYZ2 = vectorXZ.mult(d3).xyz(0.0);
        VectorXYZ vectorXYZ3 = vectorXZ.rightNormal().mult(d2).xyz(0.0);
        VectorXYZ vectorXYZ4 = VectorXYZ.Y_UNIT.mult(d);
        this.drawBox(material, vectorXYZ.add(vectorXYZ3.mult(-0.5)).add(vectorXYZ2.mult(-0.5)), vectorXYZ3, vectorXYZ4, vectorXYZ2);
    }

    @Override
    public void drawColumn(Material material, Integer n, VectorXYZ vectorXYZ, double d, double d2, double d3, boolean bl, boolean bl2) {
        if (n == null) {
            n = 16;
            material = material.makeSmooth();
        }
        float f = (float)(Math.PI * 2 / (double)n.intValue());
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(n + 2);
        ArrayList<VectorXYZ> arrayList2 = new ArrayList<VectorXYZ>(n + 2);
        ArrayList<VectorXYZ> arrayList3 = new ArrayList<VectorXYZ>(n + 2);
        arrayList.add(vectorXYZ);
        arrayList2.add(vectorXYZ.add(0.0, d, 0.0));
        for (int i = 0; i <= n; ++i) {
            double d4 = (float)(-i) * f;
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            VectorXYZ vectorXYZ2 = vectorXYZ.add(d3 * d5, d, d3 * d6);
            VectorXYZ vectorXYZ3 = vectorXYZ.add(d2 * d5, 0.0, d2 * d6);
            arrayList.add(vectorXYZ3);
            arrayList2.add(vectorXYZ2);
            arrayList3.add(vectorXYZ2);
            arrayList3.add(vectorXYZ3);
        }
        Collections.reverse(arrayList);
        if (bl) {
            this.drawTriangleFan(material, arrayList);
        }
        if (bl2) {
            this.drawTriangleFan(material, arrayList2);
        }
        this.drawTriangleStrip(material, arrayList3);
    }

    @Override
    public void drawTriangleStrip(Material material, VectorXYZ ... vectorXYZArray) {
        this.drawTriangleStrip(material, Arrays.asList(vectorXYZArray));
    }

    @Override
    public void drawTriangleStrip(Material material, List<? extends VectorXYZ> list) {
        this.drawTriangles(material, GeometryUtil.trianglesFromTriangleStrip(list));
    }

    @Override
    public void drawTriangleFan(Material material, List<? extends VectorXYZ> list) {
        this.drawTriangles(material, GeometryUtil.trianglesFromTriangleFan(list));
    }

    @Override
    public void drawPolygon(Material material, VectorXYZ ... vectorXYZArray) {
        this.drawTriangleFan(material, Arrays.asList(vectorXYZArray));
    }
}

