/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXYZWithNormals;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.algorithms.NormalCalculationUtil;
import org.osm2world.core.target.Renderable;
import org.osm2world.core.target.common.AbstractTarget;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.material.Material;

public abstract class PrimitiveTarget<R extends Renderable>
extends AbstractTarget<R> {
    protected abstract void drawPrimitive(Primitive.Type var1, Material var2, List<? extends VectorXYZ> var3, VectorXYZ[] var4);

    @Override
    public void drawTriangleStrip(Material material, VectorXYZ ... vectorXYZArray) {
        this.drawTriangleStrip(material, Arrays.asList(vectorXYZArray));
    }

    @Override
    public void drawTriangleStrip(Material material, List<? extends VectorXYZ> list) {
        boolean bl = material.getLighting() == Material.Lighting.SMOOTH;
        this.drawPrimitive(Primitive.Type.TRIANGLE_STRIP, material, list, NormalCalculationUtil.calculateTriangleStripNormals(list, bl));
    }

    @Override
    public void drawTriangleFan(Material material, List<? extends VectorXYZ> list) {
        boolean bl = material.getLighting() == Material.Lighting.SMOOTH;
        this.drawPrimitive(Primitive.Type.TRIANGLE_FAN, material, list, NormalCalculationUtil.calculateTriangleFanNormals(list, bl));
    }

    @Override
    public void drawPolygon(Material material, VectorXYZ ... vectorXYZArray) {
        this.drawPolygon(material, Arrays.asList(vectorXYZArray));
    }

    public void drawPolygon(Material material, List<? extends VectorXYZ> list) {
        boolean bl = material.getLighting() == Material.Lighting.SMOOTH;
        this.drawPrimitive(Primitive.Type.CONVEX_POLYGON, material, list, NormalCalculationUtil.calculateTriangleFanNormals(list, bl));
    }

    @Override
    public void drawTriangles(Material material, Collection<? extends TriangleXYZ> collection) {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(collection.size() * 3);
        for (TriangleXYZ triangleXYZ : collection) {
            arrayList.add(triangleXYZ.v1);
            arrayList.add(triangleXYZ.v2);
            arrayList.add(triangleXYZ.v3);
        }
        this.drawPrimitive(Primitive.Type.TRIANGLES, material, arrayList, NormalCalculationUtil.calculateTriangleNormals(arrayList, material.getLighting() == Material.Lighting.SMOOTH));
    }

    @Override
    public void drawTrianglesWithNormals(Material material, Collection<? extends TriangleXYZWithNormals> collection) {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(collection.size() * 3);
        ArrayList<VectorXYZ> arrayList2 = new ArrayList<VectorXYZ>(collection.size() * 3);
        for (TriangleXYZWithNormals triangleXYZWithNormals : collection) {
            arrayList.add(triangleXYZWithNormals.v1);
            arrayList.add(triangleXYZWithNormals.v2);
            arrayList.add(triangleXYZWithNormals.v3);
            arrayList2.add(triangleXYZWithNormals.n1);
            arrayList2.add(triangleXYZWithNormals.n2);
            arrayList2.add(triangleXYZWithNormals.n3);
        }
        this.drawPrimitive(Primitive.Type.TRIANGLES, material, arrayList, arrayList2.toArray(new VectorXYZ[arrayList2.size()]));
    }
}

