/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common.material;

import java.awt.Color;
import org.osm2world.core.target.common.material.ImmutableMaterial;

public abstract class Material {
    protected Lighting lighting;
    protected Color color;
    protected float ambientFactor;
    protected float diffuseFactor;

    public Material(Lighting lighting, Color color, float f, float f2) {
        this.lighting = lighting;
        this.color = color;
        this.ambientFactor = f;
        this.diffuseFactor = f2;
    }

    public Material(Lighting lighting, Color color) {
        this(lighting, color, 0.5f, 0.5f);
    }

    public Lighting getLighting() {
        return this.lighting;
    }

    public Color getColor() {
        return this.color;
    }

    public float getAmbientFactor() {
        return this.ambientFactor;
    }

    public float getDiffuseFactor() {
        return this.diffuseFactor;
    }

    public Color ambientColor() {
        return Material.multiplyColor(this.getColor(), this.getAmbientFactor());
    }

    public Color diffuseColor() {
        return Material.multiplyColor(this.getColor(), this.getDiffuseFactor());
    }

    private static final Color multiplyColor(Color color, float f) {
        float[] fArray = new float[3];
        color.getColorComponents(fArray);
        return new Color(fArray[0] * f, fArray[1] * f, fArray[2] * f);
    }

    public Material makeSmooth() {
        return new ImmutableMaterial(Lighting.SMOOTH, this.getColor(), this.getAmbientFactor(), this.getDiffuseFactor());
    }

    public String toString() {
        return String.format("{%s, #%06x, a%3f, d%3f}", new Object[]{this.lighting, this.color.getRGB() & 0xFFFFFF, Float.valueOf(this.ambientFactor), Float.valueOf(this.diffuseFactor)});
    }

    public static enum Lighting {
        FLAT,
        SMOOTH;

    }
}

