/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common.material;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.target.common.material.ConfMaterial;
import org.osm2world.core.target.common.material.Material;

public final class Materials {
    public static final ConfMaterial TERRAIN_DEFAULT = new ConfMaterial(Material.Lighting.SMOOTH, Color.GREEN);
    public static final ConfMaterial WATER = new ConfMaterial(Material.Lighting.FLAT, Color.BLUE);
    public static final ConfMaterial ASPHALT = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.3f, 0.3f));
    public static final ConfMaterial CONCRETE = new ConfMaterial(Material.Lighting.FLAT, new Color(0.4f, 0.4f, 0.4f));
    public static final ConfMaterial EARTH = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.0f, 0.0f));
    public static final ConfMaterial GRASS = new ConfMaterial(Material.Lighting.FLAT, new Color(0.0f, 0.8f, 0.0f));
    public static final ConfMaterial GRAVEL = new ConfMaterial(Material.Lighting.FLAT, new Color(0.4f, 0.4f, 0.4f));
    public static final ConfMaterial SAND = new ConfMaterial(Material.Lighting.FLAT, new Color(241, 233, 80));
    public static final ConfMaterial STEEL = new ConfMaterial(Material.Lighting.FLAT, new Color(200, 200, 200));
    public static final ConfMaterial WOOD = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.2f, 0.2f));
    public static final ConfMaterial TARTAN = new ConfMaterial(Material.Lighting.FLAT, new Color(206, 109, 90));
    public static final ConfMaterial ROAD_MARKING = new ConfMaterial(Material.Lighting.FLAT, new Color(1.0f, 1.0f, 1.0f));
    public static final ConfMaterial STEPS_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.DARK_GRAY);
    public static final ConfMaterial HANDRAIL_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.LIGHT_GRAY);
    public static final ConfMaterial RAIL_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.LIGHT_GRAY);
    public static final ConfMaterial RAIL_SLEEPER_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.2f, 0.2f));
    public static final ConfMaterial RAIL_BALLAST_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.DARK_GRAY);
    public static final ConfMaterial BUILDING_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, new Color(1.0f, 0.9f, 0.55f));
    public static final ConfMaterial ROOF_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, new Color(0.8f, 0.0f, 0.0f));
    public static final ConfMaterial ENTRANCE_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, new Color(0.2f, 0.0f, 0.0f));
    public static final ConfMaterial WALL_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.GRAY);
    public static final ConfMaterial HEDGE = new ConfMaterial(Material.Lighting.FLAT, new Color(0.0f, 0.5f, 0.0f));
    public static final ConfMaterial FENCE_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.2f, 0.2f));
    public static final ConfMaterial SPLIT_RAIL_FENCE = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.2f, 0.2f));
    public static final ConfMaterial BOLLARD_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.LIGHT_GRAY);
    public static final ConfMaterial BRIDGE_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.GRAY);
    public static final ConfMaterial BRIDGE_PILLAR_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.GRAY);
    public static final ConfMaterial TUNNEL_DEFAULT = new ConfMaterial(Material.Lighting.FLAT, Color.GRAY, 0.2f, 0.5f);
    public static final ConfMaterial TREE_TRUNK = new ConfMaterial(Material.Lighting.FLAT, new Color(0.3f, 0.2f, 0.2f));
    public static final ConfMaterial TREE_CROWN = new ConfMaterial(Material.Lighting.SMOOTH, new Color(0.0f, 0.5f, 0.0f));
    public static final ConfMaterial ADVERTISING_POSTER = new ConfMaterial(Material.Lighting.FLAT, new Color(1.0f, 1.0f, 0.8f));
    private static final Map<String, ConfMaterial> surfaceMaterialMap = new HashMap<String, ConfMaterial>();
    private static final Map<ConfMaterial, String> fieldNameMap = new HashMap<ConfMaterial, String>();
    private static final String CONF_KEY_REGEX = "material_(.+)_(color)";

    private Materials() {
    }

    public static final Collection<ConfMaterial> getMaterials() {
        return fieldNameMap.keySet();
    }

    public static final ConfMaterial getMaterial(String string) {
        for (Map.Entry<ConfMaterial, String> entry : fieldNameMap.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static final Material getSurfaceMaterial(String string) {
        return Materials.getSurfaceMaterial(string, null);
    }

    public static final Material getSurfaceMaterial(String string, Material material) {
        Material material2 = surfaceMaterialMap.get(string);
        if (material2 != null) {
            return material2;
        }
        return material;
    }

    public static final String getUniqueName(Material material) {
        return fieldNameMap.get(material);
    }

    public static final void configureMaterials(Configuration configuration) {
        Iterator iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Matcher matcher = Pattern.compile(CONF_KEY_REGEX).matcher(string);
            if (!matcher.matches()) continue;
            ConfMaterial confMaterial = Materials.getMaterial(matcher.group(1));
            if (confMaterial != null) {
                String string2 = matcher.group(2);
                if ("color".equals(string2)) {
                    try {
                        confMaterial.setColor(Color.decode(configuration.getString(string)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("incorrect color value: " + configuration.getString(string));
                    }
                    continue;
                }
                System.err.println("unknown material attribute: " + string2);
                continue;
            }
            System.err.println("unknown material: " + matcher.group(1));
        }
    }

    static {
        surfaceMaterialMap.put("asphalt", ASPHALT);
        surfaceMaterialMap.put("cobblestone", ASPHALT);
        surfaceMaterialMap.put("compacted", GRAVEL);
        surfaceMaterialMap.put("concrete", CONCRETE);
        surfaceMaterialMap.put("grass", GRASS);
        surfaceMaterialMap.put("gravel", GRAVEL);
        surfaceMaterialMap.put("grass_paver", ASPHALT);
        surfaceMaterialMap.put("ground", EARTH);
        surfaceMaterialMap.put("paved", ASPHALT);
        surfaceMaterialMap.put("paving_stones", ASPHALT);
        surfaceMaterialMap.put("pebblestone", ASPHALT);
        surfaceMaterialMap.put("sand", SAND);
        surfaceMaterialMap.put("tartan", TARTAN);
        surfaceMaterialMap.put("unpaved", EARTH);
        surfaceMaterialMap.put("wood", WOOD);
        try {
            for (Field field : Materials.class.getFields()) {
                if (!field.getType().equals(ConfMaterial.class)) continue;
                fieldNameMap.put((ConfMaterial)field.get(null), field.getName());
            }
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

