/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common.rendering;

import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class Camera {
    private static final VectorXYZ UP = new VectorXYZ(0.0, 1.0, 0.0);
    VectorXYZ pos;
    VectorXYZ lookAt;

    public VectorXYZ getViewDirection() {
        return this.lookAt.subtract(this.pos).normalize();
    }

    public VectorXYZ getRight() {
        return this.getViewDirection().cross(UP).normalize();
    }

    public VectorXYZ getPos() {
        return this.pos;
    }

    public VectorXYZ getLookAt() {
        return this.lookAt;
    }

    public void setPos(VectorXYZ vectorXYZ) {
        this.pos = vectorXYZ;
    }

    public void setPos(double d, double d2, double d3) {
        this.setPos(new VectorXYZ(d, d2, d3));
    }

    public void setLookAt(VectorXYZ vectorXYZ) {
        this.lookAt = vectorXYZ;
    }

    public void setLookAt(double d, double d2, double d3) {
        this.setLookAt(new VectorXYZ(d, d2, d3));
    }

    public void moveForward(double d) {
        VectorXYZ vectorXYZ = this.getViewDirection();
        VectorXZ vectorXZ = new VectorXZ(vectorXYZ.x, vectorXYZ.z).normalize();
        this.move(vectorXZ.x * d, 0.0, vectorXZ.z * d);
    }

    public void moveRight(double d) {
        VectorXYZ vectorXYZ = this.getRight();
        this.move(vectorXYZ.x * d, 0.0, vectorXYZ.z * d);
    }

    public void move(VectorXYZ vectorXYZ) {
        this.pos = this.pos.add(vectorXYZ);
        this.lookAt = this.lookAt.add(vectorXYZ);
    }

    public void move(double d, double d2, double d3) {
        this.move(new VectorXYZ(d, d2, d3));
    }

    public void rotateY(double d) {
        VectorXYZ vectorXYZ = this.lookAt.subtract(this.pos);
        VectorXYZ vectorXYZ2 = vectorXYZ.rotateY(d);
        this.lookAt = this.pos.add(vectorXYZ2);
    }

    public void rotateAroundRight(double d) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String toString() {
        return "{pos=" + this.pos + ", lookAt=" + this.lookAt + "}";
    }
}

