/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common.rendering;

import java.util.Arrays;
import java.util.List;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.Projection;
import org.osm2world.core.target.common.rendering.TileNumber;

public final class OrthoTilesUtil {
    private OrthoTilesUtil() {
    }

    public static final Camera cameraForTile(MapProjection mapProjection, TileNumber tileNumber, double d, CardinalDirection cardinalDirection) {
        return OrthoTilesUtil.cameraForBounds(OrthoTilesUtil.boundsForTile(mapProjection, tileNumber), d, cardinalDirection);
    }

    public static final Camera cameraForTiles(MapProjection mapProjection, List<TileNumber> list, double d, CardinalDirection cardinalDirection) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty tiles list");
        }
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = OrthoTilesUtil.boundsForTiles(mapProjection, list);
        return OrthoTilesUtil.cameraForBounds(axisAlignedBoundingBoxXZ, d, cardinalDirection);
    }

    public static final Camera cameraForBounds(AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ, double d, CardinalDirection cardinalDirection) {
        Camera camera = new Camera();
        VectorXYZ vectorXYZ = new VectorXYZ(axisAlignedBoundingBoxXZ.minX + axisAlignedBoundingBoxXZ.sizeX() / 2.0, 0.0, axisAlignedBoundingBoxXZ.minZ + axisAlignedBoundingBoxXZ.sizeZ() / 2.0);
        camera.setLookAt(vectorXYZ);
        double d2 = Math.max(axisAlignedBoundingBoxXZ.sizeX(), axisAlignedBoundingBoxXZ.sizeZ());
        double d3 = 0.0;
        double d4 = -d2 * Math.cos(Math.toRadians(d));
        if (cardinalDirection == CardinalDirection.W || cardinalDirection == CardinalDirection.E) {
            double d5 = d3;
            d3 = d4;
            d4 = d5;
        }
        if (cardinalDirection == CardinalDirection.N || cardinalDirection == CardinalDirection.E) {
            d3 = -d3;
            d4 = -d4;
        }
        camera.setPos(new VectorXYZ(vectorXYZ.x + d3, d2 * Math.sin(Math.toRadians(d)), vectorXYZ.z + d4));
        return camera;
    }

    public static final Projection projectionForTile(MapProjection mapProjection, TileNumber tileNumber, double d, CardinalDirection cardinalDirection) {
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = OrthoTilesUtil.boundsForTile(mapProjection, tileNumber);
        return OrthoTilesUtil.projectionForBounds(axisAlignedBoundingBoxXZ, d, cardinalDirection);
    }

    public static final Projection projectionForTiles(MapProjection mapProjection, List<TileNumber> list, double d, CardinalDirection cardinalDirection) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty tiles list");
        }
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = OrthoTilesUtil.boundsForTiles(mapProjection, list);
        return OrthoTilesUtil.projectionForBounds(axisAlignedBoundingBoxXZ, d, cardinalDirection);
    }

    public static final Projection projectionForBounds(AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ, double d, CardinalDirection cardinalDirection) {
        double d2 = Math.sin(Math.toRadians(d));
        double d3 = axisAlignedBoundingBoxXZ.sizeX();
        double d4 = axisAlignedBoundingBoxXZ.sizeZ();
        if (cardinalDirection == CardinalDirection.W || cardinalDirection == CardinalDirection.E) {
            double d5 = d3;
            d3 = d4;
            d4 = d5;
        }
        return new Projection(true, d3 / (d4 * d2), Double.NaN, d4 * d2, -10000.0, 10000.0);
    }

    private static final AxisAlignedBoundingBoxXZ boundsForTile(MapProjection mapProjection, TileNumber tileNumber) {
        VectorXZ vectorXZ = mapProjection.calcPos(OrthoTilesUtil.tile2lat(tileNumber.y, tileNumber.zoom), OrthoTilesUtil.tile2lon(tileNumber.x, tileNumber.zoom));
        VectorXZ vectorXZ2 = mapProjection.calcPos(OrthoTilesUtil.tile2lat(tileNumber.y + 1, tileNumber.zoom), OrthoTilesUtil.tile2lon(tileNumber.x + 1, tileNumber.zoom));
        return new AxisAlignedBoundingBoxXZ(Arrays.asList(vectorXZ, vectorXZ2));
    }

    private static final AxisAlignedBoundingBoxXZ boundsForTiles(MapProjection mapProjection, List<TileNumber> list) {
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = OrthoTilesUtil.boundsForTile(mapProjection, list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ2 = OrthoTilesUtil.boundsForTile(mapProjection, list.get(i));
            axisAlignedBoundingBoxXZ = AxisAlignedBoundingBoxXZ.union(axisAlignedBoundingBoxXZ, axisAlignedBoundingBoxXZ2);
        }
        return axisAlignedBoundingBoxXZ;
    }

    private static final double tile2lon(int n, int n2) {
        return (double)n / Math.pow(2.0, n2) * 360.0 - 180.0;
    }

    private static final double tile2lat(int n, int n2) {
        double d = Math.PI - Math.PI * 2 * (double)n / Math.pow(2.0, n2);
        return Math.toDegrees(Math.atan(Math.sinh(d)));
    }

    public static enum CardinalDirection {
        N,
        E,
        S,
        W;

    }
}

