/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.common.rendering;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TileNumber {
    public final int zoom;
    public final int x;
    public final int y;
    public static final String PATTERN = "([0-9]{1,2}),([0-9]{1,9}),([0-9]{1,9})";

    public TileNumber(int n, int n2, int n3) {
        this.zoom = n;
        this.x = n2;
        this.y = n3;
        this.validateValues();
    }

    public TileNumber(String string) {
        Matcher matcher = Pattern.compile(PATTERN).matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("argument doesn't match: " + string);
        }
        this.zoom = Integer.parseInt(matcher.group(1));
        this.x = Integer.parseInt(matcher.group(2));
        this.y = Integer.parseInt(matcher.group(3));
        this.validateValues();
    }

    private void validateValues() {
        if (this.zoom <= 0 || this.x <= 0 || this.y <= 0) {
            throw new IllegalArgumentException("not positive: " + this.x + ", " + this.y);
        }
    }

    public String toString() {
        return this.zoom + "," + this.x + "," + this.y;
    }
}

