/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.jogl;

import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.PrimitiveTarget;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.Projection;
import org.osm2world.core.target.jogl.RenderableToJOGL;

public class JOGLTarget
extends PrimitiveTarget<RenderableToJOGL> {
    private final GL gl;
    private final Camera camera;
    private static final TextRenderer textRenderer = new TextRenderer(new Font("SansSerif", 0, 12), true, false);

    public JOGLTarget(GL gL, Camera camera) {
        this.gl = gL;
        this.camera = camera;
    }

    @Override
    public Class<RenderableToJOGL> getRenderableType() {
        return RenderableToJOGL.class;
    }

    @Override
    public void render(RenderableToJOGL renderableToJOGL) {
        renderableToJOGL.renderTo(this.gl, this.camera);
    }

    @Override
    protected void drawPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
        assert (list.size() == vectorXYZArray.length);
        JOGLTarget.setMaterial(this.gl, material);
        this.gl.glBegin(JOGLTarget.getGLConstant(type));
        for (int i = 0; i < list.size(); ++i) {
            this.gl.glNormal3d(vectorXYZArray[i].x, vectorXYZArray[i].y, -vectorXYZArray[i].z);
            this.gl.glVertex3d(list.get((int)i).x, list.get((int)i).y, -list.get((int)i).z);
            ++i;
        }
        this.gl.glEnd();
    }

    private void drawPrimitive(int n, Color color, List<? extends VectorXYZ> list) {
        this.gl.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        this.gl.glBegin(n);
        for (VectorXYZ vectorXYZ : list) {
            this.gl.glVertex3d(vectorXYZ.getX(), vectorXYZ.getY(), -vectorXYZ.getZ());
        }
        this.gl.glEnd();
    }

    public void drawPoints(Color color, VectorXYZ ... vectorXYZArray) {
        this.drawPrimitive(0, color, Arrays.asList(vectorXYZArray));
    }

    public void drawLineStrip(Color color, VectorXYZ ... vectorXYZArray) {
        this.drawLineStrip(color, Arrays.asList(vectorXYZArray));
    }

    public void drawLineStrip(Color color, List<VectorXYZ> list) {
        this.drawPrimitive(3, color, list);
    }

    public void drawLineStrip(Color color, int n, VectorXYZ ... vectorXYZArray) {
        this.gl.glLineWidth((float)n);
        this.drawLineStrip(color, vectorXYZArray);
        this.gl.glLineWidth(1.0f);
    }

    public void drawLineLoop(Color color, List<? extends VectorXYZ> list) {
        this.drawPrimitive(2, color, list);
    }

    public void drawArrow(Color color, float f, VectorXYZ ... vectorXYZArray) {
        this.drawLineStrip(color, vectorXYZArray);
        VectorXYZ vectorXYZ = VectorXYZ.xyz(vectorXYZArray[vectorXYZArray.length - 1]);
        VectorXYZ vectorXYZ2 = VectorXYZ.xyz(vectorXYZArray[vectorXYZArray.length - 2]);
        VectorXYZ vectorXYZ3 = vectorXYZ.subtract(vectorXYZ2).normalize();
        VectorXYZ vectorXYZ4 = vectorXYZ.subtract(vectorXYZ3.mult(f));
        VectorXZ vectorXZ = vectorXYZ3.xz();
        vectorXZ = vectorXZ.lengthSquared() < 0.01 ? VectorXZ.X_UNIT : vectorXZ.normalize();
        VectorXZ vectorXZ2 = vectorXZ.rightNormal();
        this.drawTriangleStrip(color, vectorXYZ, vectorXYZ4.add(vectorXZ.mult(f / 2.0f)), vectorXYZ4.subtract(vectorXZ.mult(f / 2.0f)));
        this.drawTriangleStrip(color, vectorXYZ, vectorXYZ4.add(vectorXZ2.mult(f / 2.0f)), vectorXYZ4.subtract(vectorXZ2.mult(f / 2.0f)));
    }

    public void drawTriangleStrip(Color color, VectorXYZ ... vectorXYZArray) {
        this.drawPrimitive(5, color, Arrays.asList(vectorXYZArray));
    }

    public void drawTriangles(Color color, Collection<TriangleXYZ> collection) {
        this.gl.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        this.gl.glBegin(4);
        for (TriangleXYZ triangleXYZ : collection) {
            this.gl.glVertex3d(triangleXYZ.v1.x, triangleXYZ.v1.y, -triangleXYZ.v1.z);
            this.gl.glVertex3d(triangleXYZ.v2.x, triangleXYZ.v2.y, -triangleXYZ.v2.z);
            this.gl.glVertex3d(triangleXYZ.v3.x, triangleXYZ.v3.y, -triangleXYZ.v3.z);
        }
        this.gl.glEnd();
    }

    public void drawPolygon(Color color, VectorXYZ ... vectorXYZArray) {
        this.drawPrimitive(9, color, Arrays.asList(vectorXYZArray));
    }

    public void drawText(String string, Vector3D vector3D, Color color) {
        textRenderer.setColor(color);
        textRenderer.begin3DRendering();
        textRenderer.draw3D(string, (float)vector3D.getX(), (float)vector3D.getY(), -((float)vector3D.getZ()), 0.05f);
    }

    public void drawText(String string, int n, int n2, int n3, int n4, Color color) {
        textRenderer.beginRendering(n3, n4);
        textRenderer.setColor(color);
        textRenderer.draw(string, n, n2);
        textRenderer.endRendering();
    }

    public static final void setCameraMatrices(GL gL, Camera camera) {
        VectorXYZ vectorXYZ = camera.getPos();
        VectorXYZ vectorXYZ2 = camera.getLookAt();
        new GLU().gluLookAt(vectorXYZ.x, vectorXYZ.y, -vectorXYZ.z, vectorXYZ2.x, vectorXYZ2.y, -vectorXYZ2.z, 0.0, 1.0, 0.0);
    }

    public static final void setProjectionMatrices(GL gL, Projection projection) {
        JOGLTarget.setProjectionMatricesForPart(gL, projection, 0.0, 1.0, 0.0, 1.0);
    }

    public static final void setProjectionMatricesForPart(GL gL, Projection projection, double d, double d2, double d3, double d4) {
        if (!(d == 0.0 && d2 == 1.0 && d3 == 0.0 && d4 == 1.0 || projection.isOrthographic())) {
            throw new IllegalArgumentException("section rendering only supported for orthographic projections");
        }
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        if (projection.isOrthographic()) {
            double d5 = projection.getAspectRatio() * projection.getVolumeHeight();
            gL.glOrtho((-0.5 + d) * d5, (-0.5 + d2) * d5, (-0.5 + d3) * projection.getVolumeHeight(), (-0.5 + d4) * projection.getVolumeHeight(), projection.getNearClippingDistance(), projection.getFarClippingDistance());
        } else {
            new GLU().gluPerspective(projection.getVertAngle(), projection.getAspectRatio(), projection.getNearClippingDistance(), projection.getFarClippingDistance());
        }
        gL.glMatrixMode(5888);
    }

    public static final void setMaterial(GL gL, Material material) {
        if (material.getLighting() == Material.Lighting.SMOOTH) {
            gL.glShadeModel(7425);
        } else {
            gL.glShadeModel(7424);
        }
        JOGLTarget.setFrontMaterialColor(gL, 4608, material.ambientColor());
        JOGLTarget.setFrontMaterialColor(gL, 4609, material.diffuseColor());
    }

    public static final void setFrontMaterialColor(GL gL, int n, Color color) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        color.getRGBColorComponents(fArray);
        gL.glMaterialfv(1028, n, FloatBuffer.wrap(fArray));
    }

    public static final int getGLConstant(Primitive.Type type) {
        switch (type) {
            case TRIANGLE_STRIP: {
                return 5;
            }
            case TRIANGLE_FAN: {
                return 6;
            }
            case TRIANGLES: {
                return 4;
            }
            case CONVEX_POLYGON: {
                return 9;
            }
        }
        throw new Error("programming error: unhandled primitive type");
    }
}

