/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.obj;

import java.awt.Color;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXYZWithNormals;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.osm.data.OSMElement;
import org.osm2world.core.target.common.AbstractTarget;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.target.obj.RenderableToObj;
import org.osm2world.core.world.data.WorldObject;

public class ObjTarget
extends AbstractTarget<RenderableToObj> {
    private final PrintStream objStream;
    private final PrintStream mtlStream;
    private final Map<VectorXYZ, Integer> vertexIndexMap = new HashMap<VectorXYZ, Integer>();
    private final Map<VectorXYZ, Integer> normalsIndexMap = new HashMap<VectorXYZ, Integer>();
    private final Map<Material, String> materialMap = new HashMap<Material, String>();
    private Class<? extends WorldObject> currentWOGroup = null;
    private int anonymousWOCounter = 0;
    private Material currentMaterial = null;
    private int anonymousMaterialCounter = 0;

    public ObjTarget(PrintStream printStream, PrintStream printStream2) {
        this.objStream = printStream;
        this.mtlStream = printStream2;
    }

    @Override
    public Class<RenderableToObj> getRenderableType() {
        return RenderableToObj.class;
    }

    @Override
    public void render(RenderableToObj renderableToObj) {
        renderableToObj.renderTo(this);
    }

    @Override
    public void beginObject(WorldObject worldObject) {
        if (worldObject == null) {
            this.currentWOGroup = null;
            this.objStream.println("g null");
            this.objStream.println("o null");
        } else {
            MapElement mapElement;
            OSMElement oSMElement;
            if (!worldObject.getClass().equals(this.currentWOGroup)) {
                this.currentWOGroup = worldObject.getClass();
                this.objStream.println("g " + this.currentWOGroup.getSimpleName());
            }
            if ((oSMElement = (mapElement = worldObject.getPrimaryMapElement()) instanceof MapNode ? ((MapNode)mapElement).getOsmNode() : (mapElement instanceof MapWaySegment ? ((MapWaySegment)mapElement).getOsmWay() : (mapElement instanceof MapArea ? ((MapArea)mapElement).getOsmObject() : null))) != null && oSMElement.tags.containsKey("name")) {
                this.objStream.println("o " + worldObject.getClass().getSimpleName() + " " + oSMElement.tags.getValue("name"));
            } else if (oSMElement != null && oSMElement.tags.containsKey("ref")) {
                this.objStream.println("o " + worldObject.getClass().getSimpleName() + " " + oSMElement.tags.getValue("ref"));
            } else {
                this.objStream.println("o " + worldObject.getClass().getSimpleName() + this.anonymousWOCounter++);
            }
        }
    }

    @Override
    public void drawTriangles(Material material, Collection<? extends TriangleXYZ> collection) {
        this.useMaterial(material);
        for (TriangleXYZ triangleXYZ : collection) {
            this.writeFace(this.verticesToIndices(triangleXYZ.getVertices()), null);
        }
    }

    @Override
    public void drawTrianglesWithNormals(Material material, Collection<? extends TriangleXYZWithNormals> collection) {
        this.useMaterial(material);
        for (TriangleXYZWithNormals triangleXYZWithNormals : collection) {
            this.writeFace(this.verticesToIndices(triangleXYZWithNormals.getVertices()), this.normalsToIndices(triangleXYZWithNormals.getNormals()));
        }
    }

    @Override
    public void drawPolygon(Material material, VectorXYZ ... vectorXYZArray) {
        this.useMaterial(material);
        this.writeFace(this.verticesToIndices(Arrays.asList(vectorXYZArray)), null);
    }

    private void useMaterial(Material material) {
        if (!material.equals(this.currentMaterial)) {
            String string = this.materialMap.get(material);
            if (string == null) {
                string = Materials.getUniqueName(material);
                if (string == null) {
                    string = "MAT_" + this.anonymousMaterialCounter;
                    ++this.anonymousMaterialCounter;
                }
                this.materialMap.put(material, string);
                this.writeMaterial(material, string);
            }
            this.objStream.println("usemtl " + string);
        }
    }

    private int[] verticesToIndices(List<? extends VectorXYZ> list) {
        return this.vectorsToIndices(this.vertexIndexMap, "v ", list);
    }

    private int[] normalsToIndices(List<? extends VectorXYZ> list) {
        return this.vectorsToIndices(this.normalsIndexMap, "vn ", list);
    }

    private int[] vectorsToIndices(Map<VectorXYZ, Integer> map, String string, List<? extends VectorXYZ> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            VectorXYZ vectorXYZ = list.get(i);
            Integer n = map.get(vectorXYZ);
            if (n == null) {
                n = map.size();
                this.objStream.println(string + " " + vectorXYZ.x + " " + vectorXYZ.y + " " + -vectorXYZ.z);
                map.put(vectorXYZ, n);
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private void writeFace(int[] nArray, int[] nArray2) {
        assert (nArray2 == null || nArray.length == nArray2.length);
        this.objStream.print("f");
        for (int i = 0; i < nArray.length; ++i) {
            this.objStream.print(" " + (nArray[i] + 1));
            if (nArray2 == null) continue;
            this.objStream.print("//" + nArray2[i]);
        }
        this.objStream.println();
    }

    private void writeMaterial(Material material, String string) {
        this.mtlStream.println("newmtl " + string);
        this.writeColorLine("Ka", material.ambientColor());
        this.writeColorLine("Kd", material.diffuseColor());
        this.mtlStream.println();
    }

    private void writeColorLine(String string, Color color) {
        this.mtlStream.println(string + " " + (float)color.getRed() / 255.0f + " " + (float)color.getGreen() / 255.0f + " " + (float)color.getBlue() / 255.0f);
    }
}

