/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.obj;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.TargetUtil;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.Projection;
import org.osm2world.core.target.obj.ObjTarget;
import org.osm2world.core.terrain.data.Terrain;

public final class ObjWriter {
    private ObjWriter() {
    }

    public static final void writeObjFile(File file, MapData mapData, CellularTerrainElevation cellularTerrainElevation, Terrain terrain, MapProjection mapProjection, Camera camera, Projection projection) throws IOException {
        File file2;
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!(file2 = new File(file.getAbsoluteFile() + ".mtl")).exists()) {
            file2.createNewFile();
        }
        PrintStream printStream = new PrintStream(file);
        PrintStream printStream2 = new PrintStream(file2);
        ObjWriter.writeObjHeader(printStream, mapProjection);
        ObjWriter.writeMtlHeader(printStream2);
        printStream.println("mtllib " + file2.getName() + "\n");
        ObjTarget objTarget = new ObjTarget(printStream, printStream2);
        TargetUtil.renderWorldObjects(objTarget, mapData);
        TargetUtil.renderObject(objTarget, terrain);
        printStream.close();
        printStream2.close();
    }

    public static final void writeObjFiles(final File file, MapData mapData, CellularTerrainElevation cellularTerrainElevation, Terrain terrain, final MapProjection mapProjection, Camera camera, Projection projection, int n) throws IOException {
        if (!file.exists()) {
            file.mkdir();
        }
        Preconditions.checkArgument(file.isDirectory());
        final File file2 = new File(file.getPath() + File.separator + "materials.mtl");
        if (!file2.exists()) {
            file2.createNewFile();
        }
        final PrintStream printStream = new PrintStream(file2);
        ObjWriter.writeMtlHeader(printStream);
        Iterator<ObjTarget> iterator = new Iterator<ObjTarget>(){
            private int fileCounter = 0;
            PrintStream objStream = null;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public ObjTarget next() {
                try {
                    File file3;
                    if (this.objStream != null) {
                        this.objStream.close();
                        ++this.fileCounter;
                    }
                    if (!(file3 = new File(file.getPath() + File.separator + "part" + String.format("%04d", this.fileCounter) + ".obj")).exists()) {
                        file3.createNewFile();
                    }
                    this.objStream = new PrintStream(file3);
                    ObjWriter.writeObjHeader(this.objStream, mapProjection);
                    this.objStream.println("mtllib " + file2.getName() + "\n");
                    return new ObjTarget(this.objStream, printStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        TargetUtil.renderWorldObjects(iterator, mapData, n);
        TargetUtil.renderObject((Target)iterator.next(), terrain);
        printStream.close();
    }

    private static final void writeObjHeader(PrintStream printStream, MapProjection mapProjection) {
        printStream.println("# This file was created by OSM2World 0.1.8 - http://osm2world.org\n");
        printStream.println("# Projection information:");
        printStream.println("# Coordinate origin (0,0,0): lat " + mapProjection.calcLat(VectorXZ.NULL_VECTOR) + ", " + "lon " + mapProjection.calcLon(VectorXZ.NULL_VECTOR) + ", " + "ele 0");
        printStream.println("# North direction: " + new VectorXYZ(mapProjection.getNorthUnit().x, 0.0, -mapProjection.getNorthUnit().z));
        printStream.println("# 1 coordinate unit corresponds to roughly 1 m in reality\n");
    }

    private static final void writeMtlHeader(PrintStream printStream) {
        printStream.println("# This file was created by OSM2World 0.1.8 - http://osm2world.org\n");
    }
}

