/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.povray;

import java.awt.Color;
import java.io.PrintStream;
import java.util.Collection;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXYZWithNormals;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.AbstractTarget;
import org.osm2world.core.target.common.material.ConfMaterial;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.target.povray.RenderableToPOVRay;

public class POVRayTarget
extends AbstractTarget<RenderableToPOVRay> {
    private static final String INDENT = "  ";
    private final PrintStream output;

    public POVRayTarget(PrintStream printStream) {
        this.output = printStream;
    }

    @Override
    public Class<RenderableToPOVRay> getRenderableType() {
        return RenderableToPOVRay.class;
    }

    @Override
    public void render(RenderableToPOVRay renderableToPOVRay) {
        renderableToPOVRay.renderTo(this);
    }

    public void append(String string) {
        this.output.print(string);
    }

    public void append(int n) {
        this.output.print(n);
    }

    public void append(double d) {
        this.output.print(d);
    }

    public void appendDefaultParameterValue(String string, String string2) {
        this.append("#ifndef (" + string + ")\n");
        this.append("#declare " + string + " = " + string2);
        this.append("\n#end\n\n");
    }

    public void appendMaterialDefinitions() {
        for (ConfMaterial confMaterial : Materials.getMaterials()) {
            String string = "texture_" + Materials.getUniqueName(confMaterial);
            this.append("#ifndef (" + string + ")\n");
            this.append("#declare " + string + " = ");
            this.appendMaterial(confMaterial);
            this.append("#end\n\n");
        }
    }

    @Override
    public void drawTriangles(Material material, Collection<? extends TriangleXYZ> collection) {
        for (TriangleXYZ triangleXYZ : collection) {
            this.performNaNCheck(triangleXYZ);
        }
        this.append("union {\n");
        for (TriangleXYZ triangleXYZ : collection) {
            this.append(INDENT);
            this.appendTriangle(triangleXYZ.v1, triangleXYZ.v2, triangleXYZ.v3);
        }
        this.appendMaterialOrName(material);
        this.append("}\n");
    }

    @Override
    public void drawTrianglesWithNormals(Material material, Collection<? extends TriangleXYZWithNormals> collection) {
        this.drawTrianglesWithNormals(material, collection, false);
    }

    public void drawTrianglesWithNormals(Material material, Collection<? extends TriangleXYZWithNormals> collection, boolean bl) {
        if (bl) {
            this.append("mesh {\n");
        } else {
            this.append("union {\n");
        }
        for (TriangleXYZWithNormals triangleXYZWithNormals : collection) {
            this.append(INDENT);
            try {
                this.performNaNCheck(triangleXYZWithNormals);
                this.appendTriangle(triangleXYZWithNormals.v1, triangleXYZWithNormals.v2, triangleXYZWithNormals.v3, triangleXYZWithNormals.n1, triangleXYZWithNormals.n2, triangleXYZWithNormals.n3, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("caught in drawTrianglesWithNormals");
            }
        }
        this.appendMaterialOrName(material);
        this.append("}\n");
    }

    @Override
    public void drawPolygon(Material material, VectorXYZ ... vectorXYZArray) {
        for (VectorXYZ vectorXYZ : vectorXYZArray) {
            this.performNaNCheck(vectorXYZ);
        }
        this.append("polygon {\n  ");
        this.append(vectorXYZArray.length);
        this.append(", ");
        for (VectorXYZ vectorXYZ : vectorXYZArray) {
            this.appendVector(vectorXYZ);
        }
        this.appendMaterialOrName(material);
        this.append("}\n");
    }

    @Override
    public void drawColumn(Material material, Integer n, VectorXYZ vectorXYZ, double d, double d2, double d3, boolean bl, boolean bl2) {
        this.performNaNCheck(vectorXYZ);
        if (d <= 0.0) {
            return;
        }
        if (n == null) {
            if (d2 == d3) {
                this.append("cylinder {\n  ");
                this.appendVector(vectorXYZ);
                this.append(", ");
                this.appendVector(vectorXYZ.y(vectorXYZ.y + d));
                this.append(", ");
                this.append(d3);
            } else {
                this.append("cone {\n  ");
                this.appendVector(vectorXYZ);
                this.append(", ");
                this.append(d2);
                this.append(", ");
                this.appendVector(vectorXYZ.y(vectorXYZ.y + d));
                this.append(", ");
                this.append(d3);
            }
            if (!bl && !bl2) {
                this.append(" open");
            }
            this.appendMaterialOrName(material);
            this.append("}\n");
        } else {
            super.drawColumn(material, n, vectorXYZ, d, d2, d3, bl, bl2);
        }
    }

    public void drawColumn(Material material, Integer n, VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, double d, double d2, boolean bl, boolean bl2) {
        this.performNaNCheck(vectorXYZ);
        this.performNaNCheck(vectorXYZ2);
        if (vectorXYZ2.equals(vectorXYZ)) {
            return;
        }
        if (n == null) {
            if (d == d2) {
                this.append("cylinder {\n  ");
                this.appendVector(vectorXYZ);
                this.append(", ");
                this.appendVector(vectorXYZ2);
                this.append(", ");
                this.append(d2);
            } else {
                this.append("cone {\n  ");
                this.appendVector(vectorXYZ);
                this.append(", ");
                this.append(d);
                this.append(", ");
                this.appendVector(vectorXYZ2);
                this.append(", ");
                this.append(d2);
            }
            if (!bl && !bl2) {
                this.append(" open");
            }
        } else {
            throw new UnsupportedOperationException("drawing non-round columns isn't implemented yet");
        }
        this.appendMaterialOrName(material);
        this.append("}\n");
    }

    public void appendTriangle(VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, VectorXYZ vectorXYZ3) {
        this.appendTriangle(vectorXYZ, vectorXYZ2, vectorXYZ3, null, null, null, false);
    }

    public void appendTriangle(VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, VectorXYZ vectorXYZ3, VectorXYZ vectorXYZ4, VectorXYZ vectorXYZ5, VectorXYZ vectorXYZ6, boolean bl) {
        if (vectorXYZ.equals(vectorXYZ2) || vectorXYZ.equals(vectorXYZ3) || vectorXYZ2.equals(vectorXYZ3)) {
            return;
        }
        if (vectorXYZ.x == vectorXYZ2.x && vectorXYZ2.x == vectorXYZ3.x && vectorXYZ.y == vectorXYZ2.y && vectorXYZ2.y == vectorXYZ3.y) {
            return;
        }
        if (vectorXYZ.x == vectorXYZ2.x && vectorXYZ2.x == vectorXYZ3.x && vectorXYZ.z == vectorXYZ2.z && vectorXYZ2.z == vectorXYZ3.z) {
            return;
        }
        if (vectorXYZ.y == vectorXYZ2.y && vectorXYZ2.y == vectorXYZ3.y && vectorXYZ.z == vectorXYZ2.z && vectorXYZ2.z == vectorXYZ3.z) {
            return;
        }
        if (bl) {
            this.append("smooth_");
        }
        this.append("triangle { ");
        this.appendVector(vectorXYZ);
        if (bl) {
            this.append(", ");
            this.appendVector(vectorXYZ4);
        }
        this.append(", ");
        this.appendVector(vectorXYZ2);
        if (bl) {
            this.append(", ");
            this.appendVector(vectorXYZ5);
        }
        this.append(", ");
        this.appendVector(vectorXYZ3);
        if (bl) {
            this.append(", ");
            this.appendVector(vectorXYZ6);
        }
        this.append("}\n");
    }

    public void appendRGBColor(Color color) {
        this.append("color rgb ");
        this.appendVector((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public void appendMaterialOrName(Material material) {
        String string = Materials.getUniqueName(material);
        if (string != null) {
            this.append(" texture { texture_" + string + " }");
        } else {
            this.appendMaterial(material);
        }
    }

    private void appendMaterial(Material material) {
        this.append("  texture {\n");
        this.append("    pigment { ");
        this.appendRGBColor(material.getColor());
        this.append(" }\n    finish {\n");
        this.append("      ambient " + material.getAmbientFactor() + "\n");
        this.append("      diffuse " + material.getDiffuseFactor() + "\n");
        this.append("    }\n");
        this.append("  }\n");
    }

    public void appendVector(float f, float f2, float f3) {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
            throw new IllegalArgumentException("NaN vector " + f + ", " + f2 + ", " + f3);
        }
        this.append("<");
        this.append(f);
        this.append(", ");
        this.append(f2);
        this.append(", ");
        this.append(f3);
        this.append(">");
    }

    public void appendVector(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new IllegalArgumentException("NaN vector " + d + ", " + d2 + ", " + d3);
        }
        this.append("<");
        this.append(d);
        this.append(", ");
        this.append(d2);
        this.append(", ");
        this.append(d3);
        this.append(">");
    }

    public void appendVector(VectorXYZ vectorXYZ) {
        this.appendVector(vectorXYZ.getX(), vectorXYZ.getY(), vectorXYZ.getZ());
    }

    public void appendVector(double d, double d2) {
        this.append("<");
        this.append(d);
        this.append(", ");
        this.append(d2);
        this.append(">");
    }

    public void appendVector(VectorXZ vectorXZ) {
        this.appendVector(vectorXZ.x, vectorXZ.z);
    }

    public void appendPolygon(VectorXYZ ... vectorXYZArray) {
        assert (!vectorXYZArray[0].equals(vectorXYZArray[vectorXYZArray.length - 1])) : "polygon not closed";
        this.append("polygon {\n  ");
        this.append(vectorXYZArray.length);
        this.append(", ");
        for (VectorXYZ vectorXYZ : vectorXYZArray) {
            this.appendVector(vectorXYZ);
        }
        this.append("}\n");
    }

    public void appendPrism(float f, float f2, VectorXZ ... vectorXZArray) {
        this.append("prism {\n  ");
        this.append(f);
        this.append(", ");
        this.append(f2);
        this.append(", ");
        this.append(vectorXZArray.length);
        this.append(",\n  ");
        for (VectorXZ vectorXZ : vectorXZArray) {
            this.appendVector(vectorXZ);
        }
        this.append("\n}");
    }

    private void performNaNCheck(TriangleXYZWithNormals triangleXYZWithNormals) {
        this.performNaNCheck(triangleXYZWithNormals.v1);
        this.performNaNCheck(triangleXYZWithNormals.v2);
        this.performNaNCheck(triangleXYZWithNormals.v3);
        this.performNaNCheck(triangleXYZWithNormals.n1);
        this.performNaNCheck(triangleXYZWithNormals.n2);
        this.performNaNCheck(triangleXYZWithNormals.n3);
    }

    private void performNaNCheck(TriangleXYZ triangleXYZ) {
        this.performNaNCheck(triangleXYZ.v1);
        this.performNaNCheck(triangleXYZ.v2);
        this.performNaNCheck(triangleXYZ.v3);
    }

    private void performNaNCheck(VectorXYZ vectorXYZ) {
        if (Double.isNaN(vectorXYZ.x) || Double.isNaN(vectorXYZ.y) || Double.isNaN(vectorXYZ.z)) {
            throw new IllegalArgumentException("NaN vector " + vectorXYZ.x + ", " + vectorXYZ.y + ", " + vectorXYZ.z);
        }
    }
}

