/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.povray;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.TargetUtil;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.Projection;
import org.osm2world.core.target.povray.POVRayTarget;
import org.osm2world.core.target.povray.RenderableToPOVRay;
import org.osm2world.core.terrain.data.Terrain;
import org.osm2world.core.world.data.WorldObject;

public final class POVRayWriter {
    private POVRayWriter() {
    }

    public static final void writePOVInstructionFile(File file, MapData mapData, CellularTerrainElevation cellularTerrainElevation, Terrain terrain, Camera camera, Projection projection) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintStream printStream = new PrintStream(file);
        POVRayWriter.writePOVInstructionStringToStream(printStream, mapData, cellularTerrainElevation, terrain, camera, projection);
        printStream.close();
    }

    private static final void writePOVInstructionStringToStream(PrintStream printStream, MapData mapData, CellularTerrainElevation cellularTerrainElevation, Terrain terrain, Camera camera, Projection projection) {
        POVRayTarget pOVRayTarget = new POVRayTarget(printStream);
        POVRayWriter.addCommentHeader(pOVRayTarget);
        pOVRayTarget.append("\n#include \"textures.inc\"\n#include \"colors.inc\"\n");
        pOVRayTarget.append("#include \"osm2world_definitions.inc\"\n\n");
        if (camera != null && projection != null) {
            POVRayWriter.addCameraDefinition(pOVRayTarget, camera, projection);
        }
        pOVRayTarget.append("//\n// global scene parameters\n//\n\n");
        pOVRayTarget.append("global_settings { ambient_light rgb 1 }\n");
        pOVRayTarget.append("light_source{ <100000,150000,-100000> color White parallel point_at <0,0,0> fade_power 0 }\n\n");
        pOVRayTarget.appendDefaultParameterValue("season", "summer");
        pOVRayTarget.appendDefaultParameterValue("time", "day");
        pOVRayTarget.append("//\n// material and object definitions\n//\n\n");
        pOVRayTarget.appendDefaultParameterValue("sky_sphere_def", "sky_sphere {\n pigment { Blue_Sky3 }\n} ");
        pOVRayTarget.append("sky_sphere {sky_sphere_def}\n\n");
        pOVRayTarget.appendMaterialDefinitions();
        for (MapElement mapElement : mapData.getMapElements()) {
            for (WorldObject worldObject : mapElement.getRepresentations()) {
                if (!(worldObject instanceof RenderableToPOVRay)) continue;
                ((RenderableToPOVRay)((Object)worldObject)).addDeclarationsTo(pOVRayTarget);
            }
        }
        pOVRayTarget.append("//\n// empty ground around the scene\n//\n\n");
        pOVRayTarget.append("difference {\n");
        pOVRayTarget.append("  plane { y, -0.001 }\n  ");
        VectorXZ[] vectorXZArray = cellularTerrainElevation.getBoundaryPolygon().getXZPolygon().getVertexLoop().toArray(new VectorXZ[0]);
        pOVRayTarget.appendPrism(-100.0f, 1.0f, vectorXZArray);
        pOVRayTarget.append("\n");
        pOVRayTarget.appendMaterialOrName(Materials.TERRAIN_DEFAULT);
        pOVRayTarget.append("\n}\n\n");
        pOVRayTarget.append("\n\n//\n//Map data\n//\n\n");
        TargetUtil.renderWorldObjects(pOVRayTarget, mapData);
        pOVRayTarget.append("\n\n//\n//Terrain\n//\n\n");
        terrain.renderTo(pOVRayTarget);
    }

    private static final void addCommentHeader(POVRayTarget pOVRayTarget) {
        pOVRayTarget.append("/*\n * This file was created by OSM2World 0.1.8 - http://osm2world.org\n * \n * Make sure that a \"osm2world_definitions.inc\" file exists!\n * You can start with the one in the \"resources\" folder from your\n * OSM2World installation or even just create an empty file.\n */\n");
    }

    private static final void addCameraDefinition(POVRayTarget pOVRayTarget, Camera camera, Projection projection) {
        pOVRayTarget.append("camera {");
        if (projection.isOrthographic()) {
            pOVRayTarget.append("\n  orthographic");
        }
        pOVRayTarget.append("\n  location ");
        pOVRayTarget.appendVector(camera.getPos());
        if (projection.isOrthographic()) {
            pOVRayTarget.append("\n  right ");
            double d = projection.getVolumeHeight() * projection.getAspectRatio();
            pOVRayTarget.appendVector(camera.getRight().mult(d).invert());
            pOVRayTarget.append("\n  up ");
            VectorXYZ vectorXYZ = camera.getRight().cross(camera.getViewDirection());
            pOVRayTarget.appendVector(vectorXYZ.normalize().mult(projection.getVolumeHeight()));
            pOVRayTarget.append("\n  look_at ");
            pOVRayTarget.appendVector(camera.getLookAt());
        } else {
            pOVRayTarget.append("\n  look_at  ");
            pOVRayTarget.appendVector(camera.getLookAt());
        }
        pOVRayTarget.append("\n}\n\n");
    }
}

