/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.primitivebuffer;

import javax.media.opengl.GL;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.primitivebuffer.JOGL_VBOPrimitiveBufferRenderer;
import org.osm2world.core.target.primitivebuffer.PrimitiveBuffer;

public class JOGLPrimitiveBufferRenderer {
    private final GL gl;
    private final PrimitiveBuffer primitiveBuffer;
    JOGL_VBOPrimitiveBufferRenderer vboRenderer;

    public JOGLPrimitiveBufferRenderer(GL gL, PrimitiveBuffer primitiveBuffer) {
        this.gl = gL;
        this.primitiveBuffer = primitiveBuffer;
        primitiveBuffer.optimize();
        if (JOGL_VBOPrimitiveBufferRenderer.isSupported(gL)) {
            this.vboRenderer = new JOGL_VBOPrimitiveBufferRenderer(gL, primitiveBuffer);
        }
    }

    public void render() {
        if (this.vboRenderer != null) {
            this.vboRenderer.render();
            return;
        }
        for (Material material : this.primitiveBuffer.getMaterials()) {
            JOGLTarget.setMaterial(this.gl, material);
            for (Primitive primitive : this.primitiveBuffer.getPrimitives(material)) {
                this.gl.glBegin(JOGLTarget.getGLConstant(primitive.type));
                int n = 0;
                for (int n2 : primitive.indices) {
                    VectorXYZ vectorXYZ = this.primitiveBuffer.getVertex(n2);
                    this.gl.glNormal3d(primitive.normals[n].x, primitive.normals[n].y, -primitive.normals[n].z);
                    this.gl.glVertex3d(vectorXYZ.x, vectorXYZ.y, -vectorXYZ.z);
                    ++n;
                }
                this.gl.glEnd();
            }
        }
    }
}

