/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.primitivebuffer;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.List;
import javax.media.opengl.GL;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.primitivebuffer.PrimitiveBuffer;

public class JOGL_VBOPrimitiveBufferRenderer {
    private final GL gl;
    private final PrimitiveBuffer primitiveBuffer;
    private int[] vboName = new int[1];

    public JOGL_VBOPrimitiveBufferRenderer(GL gL, PrimitiveBuffer primitiveBuffer) {
        assert (JOGL_VBOPrimitiveBufferRenderer.isSupported(gL));
        this.gl = gL;
        this.primitiveBuffer = primitiveBuffer;
        this.createVertexBuffer();
    }

    private void createVertexBuffer() {
        List<VectorXYZ> list = this.primitiveBuffer.getVertices();
        DoubleBuffer doubleBuffer = DoubleBuffer.allocate(list.size() * 3);
        for (VectorXYZ vectorXYZ : list) {
            doubleBuffer.put(vectorXYZ.getX());
            doubleBuffer.put(vectorXYZ.getY());
            doubleBuffer.put(-vectorXYZ.getZ());
        }
        this.gl.glGenBuffersARB(1, this.vboName, 0);
        this.gl.glBindBufferARB(34962, this.vboName[0]);
        this.gl.glBufferDataARB(34962, list.size() * 3 * 8, (Buffer)doubleBuffer, 35044);
    }

    public void render() {
        this.gl.glEnableClientState(32884);
        this.gl.glBindBufferARB(34962, this.vboName[0]);
        this.gl.glVertexPointer(3, 5130, 0, 0L);
        for (Material material : this.primitiveBuffer.getMaterials()) {
            this.gl.glColor3f((float)material.getColor().getRed() / 255.0f, (float)material.getColor().getGreen() / 255.0f, (float)material.getColor().getBlue() / 255.0f);
            for (Primitive primitive : this.primitiveBuffer.getPrimitives(material)) {
                int n = JOGLTarget.getGLConstant(primitive.type);
                this.gl.glDrawElements(n, primitive.indices.length, 5124, (Buffer)IntBuffer.wrap(primitive.indices));
            }
        }
        this.gl.glDisableClientState(32884);
    }

    public static boolean isSupported(GL gL) {
        return false;
    }
}

