/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.primitivebuffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.PrimitiveTarget;
import org.osm2world.core.target.common.RenderableToPrimitiveTarget;
import org.osm2world.core.target.common.material.Material;

public class PrimitiveBuffer
extends PrimitiveTarget<RenderableToPrimitiveTarget> {
    private ArrayList<VectorXYZ> vertexCollection = new ArrayList();
    private Map<Material, List<Primitive>> primitiveMap = new HashMap<Material, List<Primitive>>();
    private Map<VectorXYZ, Integer> indexMap = new HashMap<VectorXYZ, Integer>();

    @Override
    public Class<RenderableToPrimitiveTarget> getRenderableType() {
        return RenderableToPrimitiveTarget.class;
    }

    @Override
    public void render(RenderableToPrimitiveTarget renderableToPrimitiveTarget) {
        renderableToPrimitiveTarget.renderTo(this);
    }

    @Override
    protected void drawPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
        int[] nArray = this.generateIndices(list);
        this.addPrimitive(material, new Primitive(type, nArray, vectorXYZArray));
    }

    private int[] generateIndices(List<? extends VectorXYZ> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n;
            VectorXYZ vectorXYZ = VectorXYZ.xyz(list.get(i));
            Integer n2 = this.indexMap.get(vectorXYZ);
            if (n2 != null) {
                nArray[i] = n2;
                continue;
            }
            nArray[i] = n = this.vertexCollection.size();
            this.indexMap.put(vectorXYZ, n);
            this.vertexCollection.add(vectorXYZ);
        }
        return nArray;
    }

    private void addPrimitive(Material material, Primitive primitive) {
        List<Primitive> list = this.primitiveMap.get(material);
        if (list == null) {
            list = new ArrayList<Primitive>();
            this.primitiveMap.put(material, list);
        }
        list.add(primitive);
    }

    public void optimize() {
        this.mergePrimitiveGroups(Primitive.Type.TRIANGLES);
    }

    private void mergePrimitiveGroups(Primitive.Type type) {
    }

    public VectorXYZ getVertex(int n) {
        return this.vertexCollection.get(n);
    }

    public List<VectorXYZ> getVertices() {
        return this.vertexCollection;
    }

    public Set<Material> getMaterials() {
        return this.primitiveMap.keySet();
    }

    public Collection<Primitive> getPrimitives(Material material) {
        return this.primitiveMap.get(material);
    }
}

