/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.target.statistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.PrimitiveTarget;
import org.osm2world.core.target.common.RenderableToPrimitiveTarget;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.world.data.WorldObject;

public class StatisticsTarget
extends PrimitiveTarget<RenderableToPrimitiveTarget> {
    private long[] globalCounts = new long[Stat.values().length];
    private Map<Material, long[]> countsPerMaterial = new HashMap<Material, long[]>();
    private Map<Class<?>, long[]> countsPerClass = new HashMap();
    private WorldObject currentObject = null;

    @Override
    public Class<RenderableToPrimitiveTarget> getRenderableType() {
        return RenderableToPrimitiveTarget.class;
    }

    @Override
    public void render(RenderableToPrimitiveTarget renderableToPrimitiveTarget) {
        renderableToPrimitiveTarget.renderTo(this);
    }

    @Override
    public void beginObject(WorldObject worldObject) {
        this.currentObject = worldObject;
        if (this.currentObject != null) {
            Class<?> clazz = this.currentObject.getClass();
            if (!this.countsPerClass.containsKey(clazz)) {
                this.countsPerClass.put(clazz, new long[Stat.values().length]);
            }
            for (Stat stat : Stat.values()) {
                long l = stat.impl.countObject(worldObject);
                int n = stat.ordinal();
                this.globalCounts[n] = this.globalCounts[n] + l;
                if (this.currentObject == null) continue;
                long[] lArray = this.countsPerClass.get(clazz);
                int n2 = stat.ordinal();
                lArray[n2] = lArray[n2] + l;
            }
        }
        super.beginObject(worldObject);
    }

    @Override
    protected void drawPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
        if (!this.countsPerMaterial.containsKey(material)) {
            this.countsPerMaterial.put(material, new long[Stat.values().length]);
        }
        for (Stat stat : Stat.values()) {
            long l = stat.impl.countPrimitive(type, material, list, vectorXYZArray);
            int n = stat.ordinal();
            this.globalCounts[n] = this.globalCounts[n] + l;
            if (material != null) {
                long[] lArray = this.countsPerMaterial.get(material);
                int n2 = stat.ordinal();
                lArray[n2] = lArray[n2] + l;
            }
            if (this.currentObject == null) continue;
            long[] lArray = this.countsPerClass.get(this.currentObject.getClass());
            int n3 = stat.ordinal();
            lArray[n3] = lArray[n3] + l;
        }
    }

    public void clear() {
        for (int i = 0; i < this.globalCounts.length; ++i) {
            this.globalCounts[i] = 0L;
        }
        this.countsPerMaterial.clear();
        this.countsPerClass.clear();
        this.currentObject = null;
    }

    public long getGlobalCount(Stat stat) {
        return this.globalCounts[stat.ordinal()];
    }

    public Set<Material> getKnownMaterials() {
        return this.countsPerMaterial.keySet();
    }

    public long getCountForMaterial(Material material, Stat stat) {
        return this.countsPerMaterial.get(material)[stat.ordinal()];
    }

    public Set<Class<?>> getKnownRenderableClasses() {
        return this.countsPerClass.keySet();
    }

    public long getCountForClass(Class<?> clazz, Stat stat) {
        return this.countsPerClass.get(clazz)[stat.ordinal()];
    }

    public static enum Stat {
        OBJECT_COUNT(new StatImpl(){

            @Override
            public long countObject(WorldObject worldObject) {
                return 1L;
            }
        }),
        PRIMITIVE_COUNT(new StatImpl(){

            @Override
            public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
                return 1L;
            }
        }),
        TOTAL_TRIANGLE_COUNT(new StatImpl(){

            @Override
            public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
                if (type == Primitive.Type.TRIANGLES) {
                    return list.size() / 3;
                }
                return list.size() - 2;
            }
        }),
        TRIANGLES_COUNT(new StatImpl(){

            @Override
            public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
                return type == Primitive.Type.TRIANGLES ? 1L : 0L;
            }
        }),
        TRIANGLE_STRIP_COUNT(new StatImpl(){

            @Override
            public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
                return type == Primitive.Type.TRIANGLE_STRIP ? 1L : 0L;
            }
        }),
        TRIANGLE_FAN_COUNT(new StatImpl(){

            @Override
            public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
                return type == Primitive.Type.TRIANGLE_FAN ? 1L : 0L;
            }
        }),
        CONVEX_POLYGON_COUNT(new StatImpl(){

            @Override
            public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
                return type == Primitive.Type.CONVEX_POLYGON ? 1L : 0L;
            }
        });

        private final StatImpl impl;

        private Stat(StatImpl statImpl) {
            this.impl = statImpl;
        }
    }

    private static abstract class StatImpl {
        private StatImpl() {
        }

        public long countObject(WorldObject worldObject) {
            return 0L;
        }

        public long countPrimitive(Primitive.Type type, Material material, List<? extends VectorXYZ> list, VectorXYZ[] vectorXYZArray) {
            return 0L;
        }
    }
}

