/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.terrain.creation;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.JTSConversionUtil;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.SimplePolygonXZ;

public final class CAGUtil {
    private CAGUtil() {
    }

    public static final Collection<PolygonWithHolesXZ> subtractPolygons(SimplePolygonXZ simplePolygonXZ, List<? extends SimplePolygonXZ> list) {
        List<Polygon> list2 = Collections.singletonList(JTSConversionUtil.polygonXZToJTSPolygon(simplePolygonXZ));
        for (SimplePolygonXZ object : list) {
            ArrayList<Polygon> arrayList = new ArrayList<Polygon>(1);
            for (Geometry geometry : list2) {
                Geometry geometry2 = geometry.difference(JTSConversionUtil.polygonXZToJTSPolygon(object));
                if (geometry2 instanceof GeometryCollection) {
                    for (int i = 0; i < ((GeometryCollection)geometry2).getNumGeometries(); ++i) {
                        arrayList.add((Polygon)((GeometryCollection)geometry2).getGeometryN(i));
                    }
                    continue;
                }
                arrayList.add((Polygon)geometry2);
            }
            list2 = arrayList;
        }
        ArrayList arrayList = new ArrayList();
        for (Geometry geometry : list2) {
            arrayList.addAll(JTSConversionUtil.polygonsXZFromJTSGeometry(geometry));
        }
        return arrayList;
    }

    public static final Collection<PolygonWithHolesXZ> intersectPolygons(List<? extends SimplePolygonXZ> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Geometry geometry = null;
        for (SimplePolygonXZ simplePolygonXZ : list) {
            Polygon polygon = JTSConversionUtil.polygonXZToJTSPolygon(simplePolygonXZ);
            if (geometry == null) {
                geometry = polygon;
                continue;
            }
            geometry = geometry.intersection(polygon);
        }
        return JTSConversionUtil.polygonsXZFromJTSGeometry(geometry);
    }
}

