/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.terrain.creation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.LineSegmentXYZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;

public class TemporaryElevationStorage {
    private static final double INTERPOL_DIST_TOLERANCE = 0.01;
    private Map<VectorXZ, VectorXYZ> nodeMap = new HashMap<VectorXZ, VectorXYZ>();
    private List<LineSegmentXYZ> lineSegments = new ArrayList<LineSegmentXYZ>();

    public void addVector(VectorXZ vectorXZ, VectorXYZ vectorXYZ) {
        this.nodeMap.put(vectorXZ, vectorXYZ);
    }

    public void addInterpolationLineSegment(LineSegmentXYZ lineSegmentXYZ) {
        this.lineSegments.add(lineSegmentXYZ);
    }

    public void addPolygon(PolygonXZ polygonXZ, PolygonXYZ polygonXYZ) {
        if (polygonXZ.size() != polygonXYZ.size()) {
            throw new IllegalArgumentException("the two polys need to have the same size");
        }
        for (int i = 0; i < polygonXZ.size(); ++i) {
            this.addVector(polygonXZ.getVertices().get(i), polygonXYZ.getVertices().get(i));
        }
        for (LineSegmentXYZ lineSegmentXYZ : polygonXYZ.getSegments()) {
            this.addInterpolationLineSegment(lineSegmentXYZ);
        }
    }

    public VectorXYZ restoreElevationForVector(VectorXZ vectorXZ) {
        VectorXYZ vectorXYZ = this.nodeMap.get(vectorXZ);
        if (vectorXYZ != null) {
            return vectorXYZ;
        }
        for (LineSegmentXYZ lineSegmentXYZ : this.lineSegments) {
            if (!(GeometryUtil.distanceFromLineSegment(vectorXZ, lineSegmentXYZ.getSegmentXZ()) < 0.01)) continue;
            return GeometryUtil.interpolateElevation(vectorXZ, lineSegmentXYZ.p1, lineSegmentXYZ.p2);
        }
        return null;
    }

    public TriangleXYZ restoreElevationForTriangle(TriangleXZ triangleXZ) {
        return new TriangleXYZ(this.restoreElevationForVector(triangleXZ.v1), this.restoreElevationForVector(triangleXZ.v2), this.restoreElevationForVector(triangleXZ.v3));
    }

    public PolygonXYZ restoreElevationForPolygon(SimplePolygonXZ simplePolygonXZ) {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(simplePolygonXZ.size() + 1);
        for (VectorXZ vectorXZ : simplePolygonXZ.getVertices()) {
            arrayList.add(this.restoreElevationForVector(vectorXZ));
        }
        arrayList.add((VectorXYZ)arrayList.get(0));
        return new PolygonXYZ(arrayList);
    }
}

