/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.terrain.creation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.heightmap.data.TerrainElevationCell;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionGrid;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.terrain.creation.CAGUtil;
import org.osm2world.core.terrain.creation.TemporaryElevationStorage;
import org.osm2world.core.terrain.data.EmptyCellTerrainPatch;
import org.osm2world.core.terrain.data.GenericTerrainPatch;
import org.osm2world.core.terrain.data.Terrain;
import org.osm2world.core.terrain.data.TerrainPatch;
import org.osm2world.core.util.FaultTolerantIterationUtil;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.data.WorldObject;

public class TerrainCreator {
    public Terrain createTerrain(MapData mapData, CellularTerrainElevation cellularTerrainElevation) {
        HashMultimap<TerrainElevationCell, TerrainBoundaryWorldObject> hashMultimap = HashMultimap.create();
        HashMultimap<TerrainElevationCell, VectorXYZ> hashMultimap2 = HashMultimap.create();
        HashSet<TerrainElevationCell> hashSet = new HashSet<TerrainElevationCell>();
        IntersectionGrid intersectionGrid = this.prepareSpeedupGrid(mapData, cellularTerrainElevation);
        for (Collection<IntersectionTestObject> collection : intersectionGrid.getCells()) {
            Iterable<TerrainElevationCell> iterable = Iterables.filter(collection, TerrainElevationCell.class);
            Iterable<WorldObject> iterable2 = Iterables.filter(collection, WorldObject.class);
            for (TerrainElevationCell terrainElevationCell : iterable) {
                for (WorldObject worldObject : iterable2) {
                    Object object;
                    if (worldObject instanceof TerrainBoundaryWorldObject) {
                        object = (TerrainBoundaryWorldObject)worldObject;
                        if (hashMultimap.containsEntry(terrainElevationCell, object)) continue;
                        SimplePolygonXZ simplePolygonXZ = terrainElevationCell.getPolygonXZ();
                        PolygonXYZ polygonXYZ = object.getOutlinePolygon();
                        if (polygonXYZ == null || !polygonXYZ.getXZPolygon().isSimple()) continue;
                        SimplePolygonXZ simplePolygonXZ2 = polygonXYZ.getSimpleXZPolygon();
                        if (simplePolygonXZ.contains(simplePolygonXZ2) || simplePolygonXZ.intersects(simplePolygonXZ2)) {
                            hashMultimap.put(terrainElevationCell, (TerrainBoundaryWorldObject)object);
                            continue;
                        }
                        if (!simplePolygonXZ2.contains(simplePolygonXZ)) continue;
                        hashSet.add(terrainElevationCell);
                        continue;
                    }
                    object = worldObject.getPrimaryMapElement().getElevationProfile();
                    hashMultimap2.putAll(terrainElevationCell, ((ElevationProfile)object).getPointsWithEle());
                }
            }
        }
        Collection<TerrainPatch> collection = TerrainCreator.generateTerrainPatches(cellularTerrainElevation.getCells(), hashMultimap, hashMultimap2, hashSet);
        TerrainCreator.finishTerrainPatches(collection);
        return new Terrain(collection);
    }

    private IntersectionGrid prepareSpeedupGrid(MapData mapData, CellularTerrainElevation cellularTerrainElevation) {
        final IntersectionGrid intersectionGrid = new IntersectionGrid(mapData.getBoundary().pad(20.0), 50, 50);
        for (TerrainElevationCell terrainElevationCell : cellularTerrainElevation.getCells()) {
            intersectionGrid.insert(terrainElevationCell);
        }
        FaultTolerantIterationUtil.iterate(mapData.getWorldObjects(IntersectionTestObject.class), new FaultTolerantIterationUtil.Operation<IntersectionTestObject>(){

            @Override
            public void perform(IntersectionTestObject intersectionTestObject) {
                if (((WorldObject)((Object)intersectionTestObject)).getGroundState() == GroundState.ON) {
                    intersectionGrid.insert(intersectionTestObject);
                }
            }
        });
        return intersectionGrid;
    }

    private static Collection<TerrainPatch> generateTerrainPatches(Iterable<? extends TerrainElevationCell> iterable, Multimap<TerrainElevationCell, TerrainBoundaryWorldObject> multimap, Multimap<TerrainElevationCell, VectorXYZ> multimap2, Set<TerrainElevationCell> set) {
        ArrayList<TerrainPatch> arrayList = new ArrayList<TerrainPatch>();
        for (TerrainElevationCell terrainElevationCell : iterable) {
            if (set.contains(terrainElevationCell)) continue;
            Collection<TerrainBoundaryWorldObject> collection = multimap.get(terrainElevationCell);
            Collection<VectorXYZ> collection2 = multimap2.get(terrainElevationCell);
            if (collection.isEmpty() && collection2.isEmpty()) {
                arrayList.add(new EmptyCellTerrainPatch(terrainElevationCell));
                continue;
            }
            TerrainCreator.addPatchesForCell(arrayList, terrainElevationCell, collection, collection2);
        }
        return arrayList;
    }

    private static void addPatchesForCell(Collection<TerrainPatch> collection, TerrainElevationCell terrainElevationCell, Collection<TerrainBoundaryWorldObject> collection2, Collection<VectorXYZ> collection3) {
        PolygonXYZ polygonXYZ = terrainElevationCell.getPolygonXYZ();
        SimplePolygonXZ simplePolygonXZ = terrainElevationCell.getPolygonXZ();
        TemporaryElevationStorage temporaryElevationStorage = new TemporaryElevationStorage();
        ArrayList<SimplePolygonXZ> arrayList = new ArrayList<SimplePolygonXZ>(collection2.size());
        for (TerrainBoundaryWorldObject collection4 : collection2) {
            PolygonXYZ polygonXYZ2 = collection4.getOutlinePolygon();
            SimplePolygonXZ simplePolygonXZ2 = polygonXYZ2.getSimpleXZPolygon();
            arrayList.add(simplePolygonXZ2);
            temporaryElevationStorage.addPolygon(simplePolygonXZ2, polygonXYZ2);
        }
        ArrayList arrayList2 = new ArrayList();
        for (VectorXYZ vectorXYZ : collection3) {
            VectorXZ vectorXZ = vectorXYZ.xz();
            arrayList2.add(vectorXZ);
            temporaryElevationStorage.addVector(vectorXZ, vectorXYZ);
        }
        temporaryElevationStorage.addPolygon(simplePolygonXZ, polygonXYZ);
        try {
            Collection<PolygonWithHolesXZ> topologyException = CAGUtil.subtractPolygons(polygonXYZ.getSimpleXZPolygon(), arrayList);
            for (PolygonWithHolesXZ polygonWithHolesXZ : topologyException) {
                ArrayList<VectorXZ> arrayList3 = new ArrayList<VectorXZ>();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    VectorXZ vectorXZ = (VectorXZ)iterator.next();
                    if (!polygonWithHolesXZ.contains(vectorXZ)) continue;
                    arrayList3.add(vectorXZ);
                }
                collection.add(new GenericTerrainPatch(polygonWithHolesXZ, arrayList3, temporaryElevationStorage));
            }
        }
        catch (InvalidGeometryException invalidGeometryException) {
            invalidGeometryException.printStackTrace();
        }
        catch (TopologyException topologyException) {
            topologyException.printStackTrace();
        }
    }

    private static void finishTerrainPatches(Collection<TerrainPatch> collection) {
        FaultTolerantIterationUtil.iterate(collection, new FaultTolerantIterationUtil.Operation<TerrainPatch>(){

            @Override
            public void perform(TerrainPatch terrainPatch) {
                terrainPatch.build();
            }
        });
    }
}

