/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.terrain.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.TriangulationUtil;
import org.osm2world.core.terrain.creation.TemporaryElevationStorage;
import org.osm2world.core.terrain.data.TerrainPatch;

public class GenericTerrainPatch
extends TerrainPatch {
    private final PolygonWithHolesXZ polygon;
    private final Collection<VectorXZ> points;
    private final TemporaryElevationStorage eleStorage;

    public GenericTerrainPatch(PolygonWithHolesXZ polygonWithHolesXZ, Collection<VectorXZ> collection, TemporaryElevationStorage temporaryElevationStorage) {
        this.polygon = polygonWithHolesXZ;
        this.points = collection;
        this.eleStorage = temporaryElevationStorage;
    }

    public PolygonWithHolesXZ getPolygon() {
        return this.polygon;
    }

    public Collection<VectorXZ> getPoints() {
        return this.points;
    }

    @Override
    public void build() {
        if (this.triangulation != null) {
            throw new IllegalStateException("this patch has already been triangulated");
        }
        this.triangulation = Collections.emptyList();
        List<TriangleXZ> list = TriangulationUtil.triangulate(this.polygon, this.points);
        this.triangulation = new ArrayList(list.size());
        for (TriangleXZ triangleXZ : list) {
            TriangleXZ triangleXZ2 = triangleXZ.makeCounterclockwise();
            this.triangulation.add(this.eleStorage.restoreElevationForTriangle(triangleXZ2));
        }
    }
}

