/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.terrain.data;

import java.util.ArrayList;
import java.util.Collection;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.algorithms.NormalCalculationUtil;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.target.povray.POVRayTarget;
import org.osm2world.core.target.povray.RenderableToPOVRay;
import org.osm2world.core.terrain.data.TerrainPatch;

public class Terrain
implements RenderableToAllTargets,
RenderableToPOVRay {
    final Collection<TerrainPatch> patches;

    public Terrain(Collection<TerrainPatch> collection) {
        this.patches = collection;
    }

    public Collection<TerrainPatch> getPatches() {
        return this.patches;
    }

    public Collection<TriangleXYZ> getTriangulation() {
        ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>();
        for (TerrainPatch terrainPatch : this.patches) {
            arrayList.addAll(terrainPatch.getTriangulation());
        }
        return arrayList;
    }

    @Override
    public void renderTo(Target<?> target) {
        Collection<TriangleXYZ> collection = this.getTriangulation();
        target.drawTrianglesWithNormals(Materials.TERRAIN_DEFAULT, NormalCalculationUtil.calculateTrianglesWithNormals(collection));
    }

    @Override
    public void addDeclarationsTo(POVRayTarget pOVRayTarget) {
    }

    @Override
    public void renderTo(POVRayTarget pOVRayTarget) {
        Collection<TriangleXYZ> collection = this.getTriangulation();
        pOVRayTarget.drawTrianglesWithNormals(Materials.TERRAIN_DEFAULT, NormalCalculationUtil.calculateTrianglesWithNormals(collection), true);
    }
}

