/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.terrain.data;

import java.util.Collection;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Materials;

public abstract class TerrainPatch
implements RenderableToAllTargets {
    protected Collection<TriangleXYZ> triangulation;

    public abstract void build();

    @Override
    public void renderTo(Target<?> target) {
        if (this.triangulation == null) {
            throw new IllegalStateException("build must be called before renderTo");
        }
        target.drawTriangles(Materials.TERRAIN_DEFAULT, this.triangulation);
    }

    public Collection<TriangleXYZ> getTriangulation() {
        if (this.triangulation == null) {
            throw new IllegalStateException("build must be called before getTriangulation");
        }
        return this.triangulation;
    }
}

