/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.creation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.network.JunctionNodeWorldObject;
import org.osm2world.core.world.network.NetworkWaySegmentWorldObject;
import org.osm2world.core.world.network.VisibleConnectorNodeWorldObject;

public class NetworkCalculator {
    private static final float ROAD_PUSHING_STEP = 0.01f;

    private NetworkCalculator() {
    }

    public static void calculateNetworkInformationInGrid(MapData mapData) {
        for (MapNode mapNode : mapData.getMapNodes()) {
            ArrayList<MapWaySegment> arrayList = new ArrayList<MapWaySegment>();
            ArrayList<MapWaySegment> arrayList2 = new ArrayList<MapWaySegment>();
            for (MapWaySegment mapWaySegment : mapNode.getInboundLines()) {
                if (!(mapWaySegment.getPrimaryRepresentation() instanceof NetworkWaySegmentWorldObject)) continue;
                arrayList.add(mapWaySegment);
            }
            for (MapWaySegment mapWaySegment : mapNode.getOutboundLines()) {
                if (!(mapWaySegment.getPrimaryRepresentation() instanceof NetworkWaySegmentWorldObject)) continue;
                arrayList2.add(mapWaySegment);
            }
            if (mapNode.getPrimaryRepresentation() instanceof JunctionNodeWorldObject) {
                NetworkCalculator.calculateJunctionNodeEffects(mapNode, (JunctionNodeWorldObject)mapNode.getPrimaryRepresentation(), arrayList, arrayList2);
                continue;
            }
            if (arrayList.size() + arrayList2.size() == 2) {
                MapWaySegment mapWaySegment;
                Iterator<MapWaySegment> iterator = new ArrayList(2);
                iterator.addAll(arrayList);
                iterator.addAll(arrayList2);
                mapWaySegment = (MapWaySegment)iterator.get(0);
                MapWaySegment mapWaySegment2 = (MapWaySegment)iterator.get(1);
                NetworkCalculator.calculateConnectorNodeEffects(mapNode.getPrimaryRepresentation(), mapWaySegment, mapWaySegment2, arrayList.contains(mapWaySegment), arrayList.contains(mapWaySegment2));
                continue;
            }
            for (MapWaySegment mapWaySegment : arrayList2) {
                NetworkCalculator.setOrthogonalCutVector(mapWaySegment, true);
            }
            for (MapWaySegment mapWaySegment : arrayList) {
                NetworkCalculator.setOrthogonalCutVector(mapWaySegment, false);
            }
        }
    }

    private static void calculateConnectorNodeEffects(NodeWorldObject nodeWorldObject, MapWaySegment mapWaySegment, MapWaySegment mapWaySegment2, boolean bl, boolean bl2) {
        VectorXZ vectorXZ;
        NetworkWaySegmentWorldObject networkWaySegmentWorldObject = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
        NetworkWaySegmentWorldObject networkWaySegmentWorldObject2 = (NetworkWaySegmentWorldObject)((Object)mapWaySegment2.getPrimaryRepresentation());
        VisibleConnectorNodeWorldObject visibleConnectorNodeWorldObject = null;
        if (nodeWorldObject instanceof VisibleConnectorNodeWorldObject) {
            visibleConnectorNodeWorldObject = (VisibleConnectorNodeWorldObject)nodeWorldObject;
        }
        VectorXZ vectorXZ2 = mapWaySegment.getDirection();
        VectorXZ vectorXZ3 = mapWaySegment2.getDirection();
        if (!bl) {
            vectorXZ2 = vectorXZ2.invert();
        }
        if (bl2) {
            vectorXZ3 = vectorXZ3.invert();
        }
        if (vectorXZ2.equals(vectorXZ3)) {
            vectorXZ = vectorXZ3.rightNormal();
        } else {
            vectorXZ = vectorXZ3.subtract(vectorXZ2);
            vectorXZ = vectorXZ.normalize();
        }
        if (vectorXZ2.z * vectorXZ.x - vectorXZ2.x * vectorXZ.z <= 0.0) {
            vectorXZ = vectorXZ.invert();
        }
        if (bl) {
            networkWaySegmentWorldObject.setEndCutVector(vectorXZ);
        } else {
            networkWaySegmentWorldObject.setStartCutVector(vectorXZ.invert());
        }
        if (bl2) {
            networkWaySegmentWorldObject2.setEndCutVector(vectorXZ.invert());
        } else {
            networkWaySegmentWorldObject2.setStartCutVector(vectorXZ);
        }
        double d = 0.0;
        if (visibleConnectorNodeWorldObject != null) {
            d = visibleConnectorNodeWorldObject.getLength();
        }
        if (d > 0.0) {
            VectorXZ vectorXZ4 = vectorXZ.rightNormal();
            vectorXZ4 = vectorXZ4.mult(d / 2.0);
            if (bl) {
                networkWaySegmentWorldObject.setEndOffset(vectorXZ4);
            } else {
                networkWaySegmentWorldObject.setStartOffset(vectorXZ4);
            }
            VectorXZ vectorXZ5 = vectorXZ4.invert();
            if (bl2) {
                networkWaySegmentWorldObject2.setEndOffset(vectorXZ5);
            } else {
                networkWaySegmentWorldObject2.setStartOffset(vectorXZ5);
            }
            if (nodeWorldObject instanceof VisibleConnectorNodeWorldObject) {
                VisibleConnectorNodeWorldObject visibleConnectorNodeWorldObject2 = (VisibleConnectorNodeWorldObject)nodeWorldObject;
                VectorXZ vectorXZ6 = bl ? mapWaySegment.getEndNode().getPos() : mapWaySegment.getStartNode().getPos();
                VectorXZ vectorXZ7 = bl2 ? mapWaySegment2.getEndNode().getPos() : mapWaySegment2.getStartNode().getPos();
                visibleConnectorNodeWorldObject2.setInformation(vectorXZ, vectorXZ6.add(vectorXZ4), vectorXZ7.add(vectorXZ5), networkWaySegmentWorldObject.getWidth(), networkWaySegmentWorldObject2.getWidth());
            }
        }
    }

    private static void calculateJunctionNodeEffects(MapNode mapNode, JunctionNodeWorldObject junctionNodeWorldObject, List<MapWaySegment> list, List<MapWaySegment> list2) {
        Object object;
        boolean bl;
        VectorXZ vectorXZ;
        NetworkWaySegmentWorldObject networkWaySegmentWorldObject;
        ArrayList<MapWaySegment> arrayList = new ArrayList<MapWaySegment>();
        arrayList.addAll(list);
        arrayList.addAll(list2);
        ArrayList<VectorXZ> arrayList2 = new ArrayList<VectorXZ>(arrayList.size());
        ArrayList<VectorXZ> arrayList3 = new ArrayList<VectorXZ>(arrayList.size());
        ArrayList<Float> arrayList4 = new ArrayList<Float>(arrayList.size());
        for (MapWaySegment mapWaySegment : list) {
            networkWaySegmentWorldObject = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
            vectorXZ = mapWaySegment.getRightNormal();
            networkWaySegmentWorldObject.setEndCutVector(vectorXZ);
            arrayList2.add(vectorXZ.invert());
            arrayList3.add(mapWaySegment.getEndNode().getPos());
            arrayList4.add(Float.valueOf(networkWaySegmentWorldObject.getWidth()));
        }
        for (MapWaySegment mapWaySegment : list2) {
            networkWaySegmentWorldObject = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
            vectorXZ = mapWaySegment.getRightNormal();
            networkWaySegmentWorldObject.setStartCutVector(vectorXZ);
            arrayList2.add(vectorXZ);
            arrayList3.add(mapWaySegment.getStartNode().getPos());
            arrayList4.add(Float.valueOf(networkWaySegmentWorldObject.getWidth()));
        }
        do {
            Object object3;
            bl = false;
            block3: for (int i = 0; i < arrayList3.size(); ++i) {
                for (int j = i + 1; j < arrayList3.size(); ++j) {
                    if (VectorXZ.distance(((MapWaySegment)arrayList.get(i)).getDirection(), ((MapWaySegment)arrayList.get(j)).getDirection()) < 0.5 || VectorXZ.distance(((MapWaySegment)arrayList.get(i)).getDirection(), ((MapWaySegment)arrayList.get(j)).getDirection().invert()) < 0.5) continue;
                    double d = Math.abs(((VectorXZ)arrayList3.get(i)).subtract((VectorXZ)arrayList3.get(j)).length());
                    if (d > 200.0) {
                        System.err.println("distance has exceeded 200 at node " + mapNode + "\n (representation: " + junctionNodeWorldObject + ")");
                        break block3;
                    }
                    if (!(d <= (double)((Float)arrayList4.get(i)).floatValue() * 0.5 + (double)((Float)arrayList4.get(j)).floatValue() * 0.5)) continue;
                    bl = true;
                    break block3;
                }
            }
            if (!bl) continue;
            arrayList3.clear();
            for (MapWaySegment mapWaySegment : list) {
                NetworkWaySegmentWorldObject networkWaySegmentWorldObject2 = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
                object = mapWaySegment.getDirection();
                object3 = ((VectorXZ)object).mult(-0.01f);
                VectorXZ vectorXZ2 = networkWaySegmentWorldObject2.getEndOffset().add((VectorXZ)object3);
                networkWaySegmentWorldObject2.setEndOffset(vectorXZ2);
                arrayList3.add(mapWaySegment.getEndNode().getPos().add(vectorXZ2));
            }
            for (MapWaySegment mapWaySegment : list2) {
                NetworkWaySegmentWorldObject networkWaySegmentWorldObject3 = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
                object = mapWaySegment.getDirection();
                object3 = ((VectorXZ)object).mult(0.01f);
                VectorXZ vectorXZ3 = networkWaySegmentWorldObject3.getStartOffset().add((VectorXZ)object3);
                networkWaySegmentWorldObject3.setStartOffset(vectorXZ3);
                arrayList3.add(mapWaySegment.getStartNode().getPos().add(vectorXZ3));
            }
        } while (bl);
        List<MapSegment> list3 = mapNode.getConnectedSegments();
        ArrayList<VectorXZ> arrayList5 = new ArrayList<VectorXZ>(list3.size());
        ArrayList<VectorXZ> arrayList6 = new ArrayList<VectorXZ>(list3.size());
        object = new ArrayList(list3.size());
        for (MapSegment mapSegment : list3) {
            if (arrayList.contains(mapSegment)) {
                int n = arrayList.indexOf(mapSegment);
                arrayList5.add((VectorXZ)arrayList3.get(n));
                arrayList6.add((VectorXZ)arrayList2.get(n));
                ((ArrayList)object).add(arrayList4.get(n));
                continue;
            }
            arrayList5.add(null);
            arrayList6.add(null);
            ((ArrayList)object).add(null);
        }
        junctionNodeWorldObject.setInformation(arrayList5, arrayList6, (List<Float>)object);
    }

    private static void setOrthogonalCutVector(MapWaySegment mapWaySegment, boolean bl) {
        VectorXZ vectorXZ = mapWaySegment.getRightNormal();
        NetworkWaySegmentWorldObject networkWaySegmentWorldObject = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
        if (bl) {
            networkWaySegmentWorldObject.setStartCutVector(vectorXZ);
        } else {
            networkWaySegmentWorldObject.setEndCutVector(vectorXZ);
        }
    }
}

