/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.creation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.world.creation.NetworkCalculator;
import org.osm2world.core.world.creation.WorldModule;

public class WorldCreator {
    private Collection<WorldModule> modules;

    public WorldCreator(Configuration configuration, WorldModule ... worldModuleArray) {
        this(configuration, Arrays.asList(worldModuleArray));
    }

    public WorldCreator(Configuration configuration, List<WorldModule> list) {
        this.modules = list;
        for (WorldModule worldModule : list) {
            worldModule.setConfiguration(configuration);
        }
    }

    public void addRepresentationsTo(MapData mapData) {
        for (WorldModule worldModule : this.modules) {
            worldModule.applyTo(mapData);
        }
        NetworkCalculator.calculateNetworkInformationInGrid(mapData);
    }
}

