/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_elevation.data.AreaElevationProfile;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.TriangulationUtil;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.world.data.AreaWorldObject;
import org.osm2world.core.world.data.WorldObjectWithOutline;

public abstract class AbstractAreaWorldObject
implements WorldObjectWithOutline,
AreaWorldObject,
IntersectionTestObject {
    protected final MapArea area;

    protected AbstractAreaWorldObject(MapArea mapArea) {
        this.area = mapArea;
    }

    @Override
    public PolygonXYZ getOutlinePolygon() {
        SimplePolygonXZ simplePolygonXZ = this.area.getPolygon().getOuter();
        List<VectorXZ> list = simplePolygonXZ.makeCounterclockwise().getVertexLoop();
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(list.size() + 1);
        for (int i = 0; i < list.size(); ++i) {
            VectorXZ vectorXZ = list.get(i);
            arrayList.add(vectorXZ.xyz(this.area.getElevationProfile().getEleAt(vectorXZ)));
        }
        arrayList.add((VectorXYZ)arrayList.get(0));
        return new PolygonXYZ(arrayList);
    }

    @Override
    public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
        return new AxisAlignedBoundingBoxXZ(this.area.getOuterPolygon().getVertices());
    }

    @Override
    public MapElement getPrimaryMapElement() {
        return this.area;
    }

    protected Collection<TriangleXYZ> getTriangulation() {
        AreaElevationProfile areaElevationProfile = this.area.getElevationProfile();
        List<TriangleXZ> list = TriangulationUtil.triangulate(this.area.getPolygon());
        ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size());
        for (TriangleXZ triangleXZ : list) {
            VectorXYZ vectorXYZ = areaElevationProfile.getWithEle(triangleXZ.v1);
            VectorXYZ vectorXYZ2 = areaElevationProfile.getWithEle(triangleXZ.v2);
            VectorXYZ vectorXYZ3 = areaElevationProfile.getWithEle(triangleXZ.v3);
            if (triangleXZ.isClockwise()) {
                arrayList.add(new TriangleXYZ(vectorXYZ3, vectorXYZ2, vectorXYZ));
                continue;
            }
            arrayList.add(new TriangleXYZ(vectorXYZ, vectorXYZ2, vectorXYZ3));
        }
        return arrayList;
    }
}

