/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.NoOutlineNodeWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.modules.common.AbstractModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;
import org.osm2world.core.world.network.AbstractNetworkWaySegmentWorldObject;

public class BarrierModule
extends AbstractModule {
    @Override
    protected void applyToWaySegment(MapWaySegment mapWaySegment) {
        TagGroup tagGroup = mapWaySegment.getTags();
        if (!tagGroup.containsKey("barrier")) {
            return;
        }
        if (Wall.fits(tagGroup)) {
            mapWaySegment.addRepresentation(new Wall(mapWaySegment));
        } else if (CityWall.fits(tagGroup)) {
            mapWaySegment.addRepresentation(new CityWall(mapWaySegment));
        } else if (Hedge.fits(tagGroup)) {
            mapWaySegment.addRepresentation(new Hedge(mapWaySegment));
        } else if (Fence.fits(tagGroup)) {
            mapWaySegment.addRepresentation(new Fence(mapWaySegment, tagGroup));
        }
    }

    @Override
    protected void applyToNode(MapNode mapNode) {
        TagGroup tagGroup = mapNode.getTags();
        if (!tagGroup.containsKey("barrier")) {
            return;
        }
        if (Bollard.fits(tagGroup)) {
            mapNode.addRepresentation(new Bollard(mapNode, tagGroup));
        }
    }

    private static class Bollard
    extends NoOutlineNodeWorldObject
    implements RenderableToAllTargets {
        private static final float DEFAULT_HEIGHT = 1.0f;
        private final float height;

        public static boolean fits(TagGroup tagGroup) {
            return "bollard".equals(tagGroup.getValue("barrier"));
        }

        public Bollard(MapNode mapNode, TagGroup tagGroup) {
            super(mapNode);
            this.height = WorldModuleParseUtil.parseHeight(tagGroup, 1.0f);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return this.height;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public void renderTo(Target<?> target) {
            VectorXYZ vectorXYZ = this.node.getElevationProfile().getPointWithEle();
            target.drawColumn(Materials.BOLLARD_DEFAULT, null, vectorXYZ, this.height, 0.15f, 0.15f, false, true);
        }
    }

    private static class Fence
    extends LinearBarrier {
        private static final Map<String, Material> MATERIAL_MAP = new HashMap<String, Material>();
        private final Material material;

        public static boolean fits(TagGroup tagGroup) {
            return "fence".equals(tagGroup.getValue("barrier"));
        }

        public Fence(MapWaySegment mapWaySegment, TagGroup tagGroup) {
            super(mapWaySegment, 0.5f, 0.1f);
            Material material = MATERIAL_MAP.get(tagGroup.getValue("fence_type"));
            this.material = material != null ? material : Materials.FENCE_DEFAULT;
        }

        @Override
        public void renderTo(Target<?> target) {
            VectorXYZ[] vectorXYZArray = WorldModuleGeometryUtil.createVectorsForVerticalTriangleStrip((List<? extends VectorXYZ>)this.line.getElevationProfile().getPointsWithEle(), 0.2f * this.height, 0.5f * this.height);
            VectorXYZ[] vectorXYZArray2 = WorldModuleGeometryUtil.createVectorsForVerticalTriangleStrip((List<? extends VectorXYZ>)this.line.getElevationProfile().getPointsWithEle(), 0.5f * this.height, 0.2f * this.height);
            target.drawTriangleStrip(this.material, vectorXYZArray);
            target.drawTriangleStrip(this.material, vectorXYZArray2);
            VectorXYZ[] vectorXYZArray3 = WorldModuleGeometryUtil.createVectorsForVerticalTriangleStrip((List<? extends VectorXYZ>)this.line.getElevationProfile().getPointsWithEle(), 0.65f * this.height, 0.95f * this.height);
            VectorXYZ[] vectorXYZArray4 = WorldModuleGeometryUtil.createVectorsForVerticalTriangleStrip((List<? extends VectorXYZ>)this.line.getElevationProfile().getPointsWithEle(), 0.95f * this.height, 0.65f * this.height);
            target.drawTriangleStrip(this.material, vectorXYZArray3);
            target.drawTriangleStrip(this.material, vectorXYZArray4);
            List<VectorXZ> list = GeometryUtil.equallyDistributePointsAlong(1.0, false, this.line.getStartNode().getPos(), this.line.getEndNode().getPos());
            for (VectorXZ vectorXZ : list) {
                VectorXYZ vectorXYZ = vectorXZ.xyz(this.line.getElevationProfile().getEleAt(vectorXZ));
                target.drawColumn(this.material, null, vectorXYZ, this.height, this.width, this.width, false, true);
            }
        }

        static {
            MATERIAL_MAP.put("split_rail", Materials.SPLIT_RAIL_FENCE);
        }
    }

    private static class Hedge
    extends ColoredWall {
        public static boolean fits(TagGroup tagGroup) {
            return "hedge".equals(tagGroup.getValue("barrier"));
        }

        public Hedge(MapWaySegment mapWaySegment) {
            super(Materials.HEDGE, mapWaySegment, 1.0f, 0.5f);
        }
    }

    private static class CityWall
    extends ColoredWall {
        public static boolean fits(TagGroup tagGroup) {
            return "city_wall".equals(tagGroup.getValue("barrier"));
        }

        public CityWall(MapWaySegment mapWaySegment) {
            super(Materials.WALL_DEFAULT, mapWaySegment, 10.0f, 2.0f);
        }
    }

    private static class Wall
    extends ColoredWall {
        public static boolean fits(TagGroup tagGroup) {
            return "wall".equals(tagGroup.getValue("barrier"));
        }

        public Wall(MapWaySegment mapWaySegment) {
            super(Materials.WALL_DEFAULT, mapWaySegment, 1.0f, 0.25f);
        }
    }

    private static abstract class ColoredWall
    extends LinearBarrier {
        private final Material material;
        private final float height;
        private final float width;

        public ColoredWall(Material material, MapWaySegment mapWaySegment, float f, float f2) {
            super(mapWaySegment, 1.0f, 0.5f);
            this.material = material;
            this.height = f;
            this.width = f2;
        }

        @Override
        public void renderTo(Target<?> target) {
            VectorXYZ[] vectorXYZArray3;
            VectorXYZ[] vectorXYZArray2 = new VectorXYZ[]{new VectorXYZ(-this.width / 2.0f, 0.0, 0.0), new VectorXYZ(-this.width / 2.0f, this.height, 0.0), new VectorXYZ(this.width / 2.0f, this.height, 0.0), new VectorXYZ(this.width / 2.0f, 0.0, 0.0)};
            Collection collection = this.line.getElevationProfile().getPointsWithEle();
            List<VectorXYZ[]> list = WorldModuleGeometryUtil.createShapeExtrusionAlong(vectorXYZArray2, (List<VectorXYZ>)collection, Collections.nCopies(collection.size(), VectorXYZ.Y_UNIT));
            for (VectorXYZ[] vectorXYZArray3 : list) {
                target.drawTriangleStrip(this.material, vectorXYZArray3);
            }
            VectorXYZ[] vectorXYZArray4 = WorldModuleGeometryUtil.transformShape(vectorXYZArray2, (VectorXYZ)collection.get(0), this.line.getDirection().xyz(0.0), VectorXYZ.Y_UNIT);
            vectorXYZArray3 = WorldModuleGeometryUtil.transformShape(vectorXYZArray2, (VectorXYZ)collection.get(collection.size() - 1), this.line.getDirection().invert().xyz(0.0), VectorXYZ.Y_UNIT);
            target.drawPolygon(this.material, vectorXYZArray4);
            target.drawPolygon(this.material, vectorXYZArray3);
        }
    }

    private static abstract class LinearBarrier
    extends AbstractNetworkWaySegmentWorldObject
    implements WaySegmentWorldObject,
    RenderableToAllTargets {
        protected final float height;
        protected final float width;

        public LinearBarrier(MapWaySegment mapWaySegment, float f, float f2) {
            super(mapWaySegment);
            this.height = WorldModuleParseUtil.parseHeight(mapWaySegment.getOsmWay().tags, f);
            this.width = WorldModuleParseUtil.parseWidth(mapWaySegment.getOsmWay().tags, f2);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return this.height;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public VectorXZ getStartPosition() {
            return this.line.getStartNode().getPos();
        }

        @Override
        public VectorXZ getEndPosition() {
            return this.line.getEndNode().getPos();
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public float getWidth() {
            return this.width;
        }
    }
}

