/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapIntersectionWW;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.data.WorldObject;
import org.osm2world.core.world.modules.WaterModule;
import org.osm2world.core.world.modules.common.AbstractModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.network.AbstractNetworkWaySegmentWorldObject;

public class BridgeModule
extends AbstractModule {
    public static final double BRIDGE_UNDERSIDE_HEIGHT = (double)0.2f;

    public static final boolean isBridge(TagGroup tagGroup) {
        return tagGroup.containsKey("bridge") && !"no".equals(tagGroup.getValue("bridge"));
    }

    public static final boolean isBridge(MapWaySegment mapWaySegment) {
        return BridgeModule.isBridge(mapWaySegment.getTags());
    }

    @Override
    protected void applyToWaySegment(MapWaySegment mapWaySegment) {
        WaySegmentWorldObject waySegmentWorldObject = mapWaySegment.getPrimaryRepresentation();
        if (waySegmentWorldObject instanceof AbstractNetworkWaySegmentWorldObject && BridgeModule.isBridge(mapWaySegment)) {
            mapWaySegment.addRepresentation(new Bridge(mapWaySegment, (AbstractNetworkWaySegmentWorldObject)waySegmentWorldObject));
        }
    }

    private static class Bridge
    implements WaySegmentWorldObject,
    RenderableToAllTargets {
        private final MapWaySegment segment;
        private final AbstractNetworkWaySegmentWorldObject primaryRep;

        public Bridge(MapWaySegment mapWaySegment, AbstractNetworkWaySegmentWorldObject abstractNetworkWaySegmentWorldObject) {
            this.segment = mapWaySegment;
            this.primaryRep = abstractNetworkWaySegmentWorldObject;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.segment;
        }

        @Override
        public VectorXZ getEndPosition() {
            return this.primaryRep.getEndPosition();
        }

        @Override
        public VectorXZ getStartPosition() {
            return this.primaryRep.getStartPosition();
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.2f;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ABOVE;
        }

        @Override
        public void renderTo(Target<?> target) {
            this.drawBridgeUnderside(target);
            this.drawBridgePillars(target);
        }

        private void drawBridgeUnderside(Target<?> target) {
            List<VectorXYZ> list = this.primaryRep.getOutline(false);
            List<VectorXYZ> list2 = this.primaryRep.getOutline(true);
            List<VectorXYZ> list3 = GeometryUtil.sequenceAbove(list, -0.2f);
            List<VectorXYZ> list4 = GeometryUtil.sequenceAbove(list2, -0.2f);
            VectorXYZ[] vectorXYZArray = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list3, list);
            VectorXYZ[] vectorXYZArray2 = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list4, list3);
            VectorXYZ[] vectorXYZArray3 = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list2, list4);
            target.drawTriangleStrip((Material)Materials.BRIDGE_DEFAULT, vectorXYZArray);
            target.drawTriangleStrip((Material)Materials.BRIDGE_DEFAULT, vectorXYZArray2);
            target.drawTriangleStrip((Material)Materials.BRIDGE_DEFAULT, vectorXYZArray3);
        }

        private void drawBridgePillars(Target<?> target) {
            List<VectorXZ> list = GeometryUtil.equallyDistributePointsAlong(2.0, false, this.primaryRep.getStartPosition(), this.primaryRep.getEndPosition());
            for (VectorXZ vectorXZ : list) {
                ArrayList<WorldObject> arrayList = new ArrayList<WorldObject>();
                for (MapIntersectionWW mapIntersectionWW : this.segment.getIntersectionsWW()) {
                    for (WaySegmentWorldObject waySegmentWorldObject : mapIntersectionWW.getOther(this.segment).getRepresentations()) {
                        if (waySegmentWorldObject.getGroundState() != GroundState.ON || waySegmentWorldObject instanceof WaterModule.Water) continue;
                        arrayList.add(waySegmentWorldObject);
                    }
                }
                if (WorldModuleGeometryUtil.piercesWorldObject(vectorXZ, arrayList)) continue;
                this.drawBridgePillarAt(target, vectorXZ);
            }
        }

        private void drawBridgePillarAt(Target<?> target, VectorXZ vectorXZ) {
            double d = this.segment.getElevationProfile().getEleAt(vectorXZ);
            target.drawColumn(Materials.BRIDGE_PILLAR_DEFAULT, null, vectorXZ.xyz(d - (double)0.1f - 100.0), 100.0, 0.2, 0.2, false, false);
        }
    }
}

