/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.util.ValueStringParser;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_data.data.overlaps.MapOverlapWA;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonWithHolesXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.JTSTriangulationUtil;
import org.osm2world.core.math.algorithms.TriangulationUtil;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.ConfMaterial;
import org.osm2world.core.target.common.material.ImmutableMaterial;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.terrain.creation.CAGUtil;
import org.osm2world.core.util.MinMaxUtil;
import org.osm2world.core.world.data.AreaWorldObject;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.data.WorldObjectWithOutline;
import org.osm2world.core.world.modules.common.ConfigurableWorldModule;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;

public class BuildingModule
extends ConfigurableWorldModule {
    @Override
    public void applyTo(MapData mapData) {
        for (MapArea mapArea : mapData.getMapAreas()) {
            String string;
            if (!mapArea.getRepresentations().isEmpty() || (string = mapArea.getTags().getValue("building")) == null || string.equals("no")) continue;
            Building building = new Building(mapArea);
            mapArea.addRepresentation(building);
        }
    }

    private static class BuildingEntrance
    implements NodeWorldObject,
    RenderableToAllTargets {
        private final BuildingPart buildingPart;
        private final MapNode node;

        public BuildingEntrance(BuildingPart buildingPart, MapNode mapNode) {
            this.buildingPart = buildingPart;
            this.node = mapNode;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public void renderTo(Target<?> target) {
            Vector3D vector3D;
            List<VectorXZ> list;
            VectorXZ vectorXZ = VectorXZ.Z_UNIT;
            for (SimplePolygonXZ simplePolygonXZ : this.buildingPart.polygon.getPolygons()) {
                list = simplePolygonXZ.getVertexLoop();
                int n = list.indexOf(this.node.getPos());
                if (n == -1) continue;
                vector3D = list.get((list.size() + n - 1) % list.size());
                VectorXZ vectorXZ2 = (VectorXZ)list.get((list.size() + n + 1) % list.size());
                vectorXZ = vectorXZ2.subtract((VectorXZ)vector3D).rightNormal();
                if (!simplePolygonXZ.isClockwise()) break;
                vectorXZ = vectorXZ.invert();
                break;
            }
            float f = WorldModuleParseUtil.parseHeight(this.node.getTags(), 2.0f);
            float f2 = WorldModuleParseUtil.parseWidth(this.node.getTags(), 1.0f);
            list = vectorXZ.rightNormal().mult(f2).xyz(0.0);
            VectorXYZ vectorXYZ = VectorXYZ.Y_UNIT.mult(f);
            vector3D = this.node.getElevationProfile().getPointWithEle();
            target.drawBox(Materials.ENTRANCE_DEFAULT, ((VectorXYZ)vector3D).subtract(((VectorXYZ)((Object)list)).mult(0.5)), (VectorXYZ)((Object)list), vectorXYZ, vectorXZ.xyz(0.0).mult(0.1));
        }
    }

    public static class BuildingPart
    implements RenderableToAllTargets {
        private final Building building;
        private final MapArea area;
        private final PolygonWithHolesXZ polygon;
        private double heightWithoutRoof;
        private Material materialWall;
        private Material materialRoof;
        private Roof roof;
        private static final float DEFAULT_RIDGE_HEIGHT = 5.0f;

        public BuildingPart(Building building, MapArea mapArea, PolygonWithHolesXZ polygonWithHolesXZ) {
            this.building = building;
            this.area = mapArea;
            this.polygon = polygonWithHolesXZ;
            this.setAttributes();
            for (MapNode mapNode : mapArea.getBoundaryNodes()) {
                if (!mapNode.getTags().contains("building", "entrance") && !mapNode.getTags().containsKey("entrance") || !mapNode.getRepresentations().isEmpty()) continue;
                mapNode.addRepresentation(new BuildingEntrance(this, mapNode));
            }
        }

        public PolygonWithHolesXZ getPolygon() {
            return this.polygon;
        }

        public Roof getRoof() {
            return this.roof;
        }

        public double getClearingAbove(VectorXZ vectorXZ) {
            return this.heightWithoutRoof + this.roof.getRoofHeight();
        }

        @Override
        public void renderTo(Target<?> target) {
            this.renderWalls(target, this.roof);
            this.roof.renderTo(target);
        }

        private void renderFloor(Target<?> target, double d) {
            List<TriangleXZ> list = TriangulationUtil.triangulate(this.polygon);
            ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size());
            for (TriangleXZ triangleXZ : list) {
                arrayList.add(triangleXZ.makeClockwise().xyz(d));
            }
            target.drawTriangles(this.materialWall, arrayList);
        }

        private void renderWalls(Target<?> target, Roof roof) {
            boolean bl;
            double d = this.calculateFloorEle(roof);
            boolean bl2 = bl = d > this.building.getArea().getElevationProfile().getMinEle();
            if (this.area.getOverlaps().isEmpty()) {
                this.renderWalls(target, roof.getPolygon(), false, d, roof);
            } else {
                ArrayList<TerrainBoundaryWorldObject> arrayList = new ArrayList<TerrainBoundaryWorldObject>();
                for (MapOverlap<?, ?> object22 : this.area.getOverlaps()) {
                    MapElement mapElement = object22.getOther(this.area);
                    if (!(mapElement.getPrimaryRepresentation() instanceof TerrainBoundaryWorldObject) || mapElement.getPrimaryRepresentation().getGroundState() != GroundState.ON) continue;
                    arrayList.add((TerrainBoundaryWorldObject)mapElement.getPrimaryRepresentation());
                }
                ArrayList arrayList2 = new ArrayList();
                for (TerrainBoundaryWorldObject terrainBoundaryWorldObject : arrayList) {
                    arrayList2.add(terrainBoundaryWorldObject.getOutlinePolygon().getSimpleXZPolygon());
                }
                arrayList2.addAll(roof.getPolygon().getHoles());
                Collection<PolygonWithHolesXZ> collection = CAGUtil.subtractPolygons(roof.getPolygon().getOuter(), arrayList2);
                for (PolygonWithHolesXZ polygonWithHolesXZ : collection) {
                    this.renderWalls(target, polygonWithHolesXZ, false, d, roof);
                    if (!bl) continue;
                    this.renderFloor(target, d);
                }
                for (TerrainBoundaryWorldObject terrainBoundaryWorldObject : arrayList) {
                    Collection<PolygonWithHolesXZ> collection2;
                    Collection<PolygonWithHolesXZ> collection3 = CAGUtil.intersectPolygons(Arrays.asList(this.polygon.getOuter(), terrainBoundaryWorldObject.getOutlinePolygon().getSimpleXZPolygon()));
                    if (this.polygon.getHoles().isEmpty()) {
                        collection2 = collection3;
                    } else {
                        collection2 = new ArrayList<PolygonWithHolesXZ>();
                        for (PolygonWithHolesXZ polygonWithHolesXZ : collection3) {
                            ArrayList<SimplePolygonXZ> arrayList3 = new ArrayList<SimplePolygonXZ>();
                            arrayList3.addAll(this.polygon.getHoles());
                            arrayList3.addAll(polygonWithHolesXZ.getHoles());
                            collection2.addAll(CAGUtil.subtractPolygons(polygonWithHolesXZ.getOuter(), arrayList3));
                        }
                    }
                    for (PolygonWithHolesXZ polygonWithHolesXZ : collection2) {
                        double d2 = terrainBoundaryWorldObject.getClearingAbove(terrainBoundaryWorldObject.getOutlinePolygon().getSimpleXZPolygon().getCenter());
                        double d3 = this.building.getArea().getElevationProfile().getMinEle() + d2;
                        if (d3 < d) {
                            d3 = d;
                        }
                        this.renderWalls(target, polygonWithHolesXZ, false, d3, roof);
                        this.renderFloor(target, d3);
                    }
                }
            }
        }

        private double calculateFloorEle(Roof roof) {
            double d = this.building.getArea().getElevationProfile().getMinEle();
            if (this.area.getTags().containsKey("min_height")) {
                Float f = ValueStringParser.parseMeasure(this.area.getTags().getValue("min_height"));
                if (f != null) {
                    d += (double)f.floatValue();
                }
            } else if (this.area.getTags().containsKey("building:min_level") && this.area.getTags().containsKey("building:levels")) {
                Float f = ValueStringParser.parseOsmDecimal(this.area.getTags().getValue("building:min_level"), true);
                Float f2 = ValueStringParser.parseOsmDecimal(this.area.getTags().getValue("building:levels"), false);
                if (f != null && f2 != null) {
                    double d2 = this.heightWithoutRoof + roof.getRoofHeight();
                    d += d2 / (double)f2.floatValue() * (double)f.floatValue();
                }
            }
            return d;
        }

        private void renderWalls(Target<?> target, PolygonWithHolesXZ polygonWithHolesXZ, boolean bl, double d, Roof roof) {
            this.drawWallOnPolygon(target, d, roof, polygonWithHolesXZ.getOuter().makeCounterclockwise());
            for (SimplePolygonXZ simplePolygonXZ : polygonWithHolesXZ.getHoles()) {
                this.drawWallOnPolygon(target, d, roof, simplePolygonXZ.makeClockwise());
            }
        }

        private void drawWallOnPolygon(Target<?> target, double d, Roof roof, SimplePolygonXZ simplePolygonXZ) {
            List<VectorXZ> list = simplePolygonXZ.getVertexLoop();
            VectorXYZ[] vectorXYZArray = new VectorXYZ[list.size() * 2];
            for (int i = 0; i < list.size(); ++i) {
                VectorXZ vectorXZ = list.get(i);
                vectorXYZArray[i * 2] = vectorXZ.xyz(roof.getRoofEleAt(vectorXZ));
                double d2 = vectorXYZArray[i * 2].y;
                vectorXYZArray[i * 2 + 1] = new VectorXYZ(vectorXZ.x, Math.min(d, d2), vectorXZ.z);
            }
            target.drawTriangleStrip(this.materialWall, vectorXYZArray);
        }

        private void setAttributes() {
            Object object;
            String string = this.area.getTags().getValue("building");
            double d = 7.5;
            double d2 = 2.5;
            Material material = Materials.BUILDING_DEFAULT;
            ConfMaterial confMaterial = Materials.ROOF_DEFAULT;
            String string2 = "flat";
            if ("greenhouse".equals(string)) {
                d = 2.5;
                confMaterial = material = new ImmutableMaterial(Material.Lighting.FLAT, new Color(0.9f, 0.9f, 0.9f));
            }
            if (BuildingPart.hasComplexRoof(this.area)) {
                this.roof = new ComplexRoof();
            } else {
                object = this.area.getTags().getValue("roof:shape");
                if (object == null) {
                    object = string2;
                }
                this.roof = "pyramidal".equals(object) ? new PyramidalRoof() : ("onion".equals(object) ? new OnionRoof() : ("gabled".equals(object) ? new GabledRoof() : ("hipped".equals(object) ? new HippedRoof() : ("half-hipped".equals(object) ? new HalfHippedRoof() : ("gambrel".equals(object) ? new GambrelRoof() : ("mansard".equals(object) ? new MansardRoof() : new FlatRoof()))))));
            }
            object = null;
            if (this.area.getTags().containsKey("building:levels")) {
                object = ValueStringParser.parseOsmDecimal(this.area.getTags().getValue("building:levels"), false);
            }
            double d3 = object == null ? d : (double)((Float)object).floatValue() * d2;
            double d4 = WorldModuleParseUtil.parseHeight(this.area.getTags(), (float)(d3 += this.roof.getRoofHeight()));
            this.heightWithoutRoof = d4 - this.roof.getRoofHeight();
            this.materialWall = material;
            this.materialRoof = confMaterial;
        }

        public static boolean hasComplexRoof(MapArea mapArea) {
            for (MapOverlap<?, ?> mapOverlap : mapArea.getOverlaps()) {
                TagGroup tagGroup;
                if (!(mapOverlap instanceof MapOverlapWA) || !(tagGroup = mapOverlap.e1.getTags()).contains("roof:ridge", "yes") && !tagGroup.contains("roof:edge", "yes")) continue;
                return true;
            }
            return false;
        }

        private class ComplexRoof
        extends HeightfieldRoof {
            private double roofHeight;
            private final Map<VectorXZ, Double> roofHeightMap;
            private final Collection<LineSegmentXZ> ridgeAndEdgeSegments;

            public ComplexRoof() {
                this.roofHeight = 0.0;
                this.roofHeightMap = new HashMap<VectorXZ, Double>();
                this.ridgeAndEdgeSegments = new ArrayList<LineSegmentXZ>();
                for (MapOverlap<?, ?> object : BuildingPart.this.area.getOverlaps()) {
                    if (!(object instanceof MapOverlapWA)) continue;
                    MapWaySegment mapWaySegment = (MapWaySegment)((MapOverlapWA)object).e1;
                    if (!BuildingPart.this.polygon.contains(mapWaySegment.getCenter())) continue;
                    boolean bl = mapWaySegment.getTags().contains("roof:ridge", "yes");
                    boolean bl2 = mapWaySegment.getTags().contains("roof:edge", "yes");
                    if (!bl && !bl2) continue;
                    this.ridgeAndEdgeSegments.add(mapWaySegment.getLineSegment());
                    for (MapNode mapNode : mapWaySegment.getStartEndNodes()) {
                        Float f = null;
                        if (mapNode.getTags().containsKey("roof:height")) {
                            f = ValueStringParser.parseMeasure(mapNode.getTags().getValue("roof:height"));
                        } else if (mapWaySegment.getTags().containsKey("roof:height")) {
                            f = ValueStringParser.parseMeasure(mapWaySegment.getTags().getValue("roof:height"));
                        } else if (mapNode.getTags().contains("roof:apex", "yes")) {
                            f = Float.valueOf(5.0f);
                        } else if (bl) {
                            f = Float.valueOf(5.0f);
                        }
                        if (f == null) continue;
                        this.roofHeightMap.put(mapNode.getPos(), Double.valueOf(f.floatValue()));
                        this.roofHeight = Math.max(this.roofHeight, (double)f.floatValue());
                    }
                }
                for (VectorXZ vectorXZ : BuildingPart.this.polygon.getOuter().getVertices()) {
                    if (this.roofHeightMap.containsKey(vectorXZ)) continue;
                    this.roofHeightMap.put(vectorXZ, 0.0);
                }
                for (SimplePolygonXZ simplePolygonXZ : BuildingPart.this.polygon.getHoles()) {
                    for (VectorXZ vectorXZ : simplePolygonXZ.getVertices()) {
                        if (this.roofHeightMap.containsKey(vectorXZ)) continue;
                        this.roofHeightMap.put(vectorXZ, 0.0);
                    }
                }
                for (LineSegmentXZ lineSegmentXZ : this.ridgeAndEdgeSegments) {
                    if (!this.roofHeightMap.containsKey(lineSegmentXZ.p1)) {
                        this.roofHeightMap.put(lineSegmentXZ.p1, 0.0);
                    }
                    if (this.roofHeightMap.containsKey(lineSegmentXZ.p2)) continue;
                    this.roofHeightMap.put(lineSegmentXZ.p2, 0.0);
                }
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                return BuildingPart.this.polygon;
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return this.ridgeAndEdgeSegments;
            }

            @Override
            public double getRoofHeight() {
                return this.roofHeight;
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                if (this.roofHeightMap.containsKey(vectorXZ)) {
                    return BuildingPart.this.building.getArea().getElevationProfile().getMinEle() + BuildingPart.this.heightWithoutRoof + this.roofHeightMap.get(vectorXZ);
                }
                return null;
            }

            @Override
            public double getMaxRoofEle() {
                return BuildingPart.this.building.getArea().getElevationProfile().getMinEle() + BuildingPart.this.heightWithoutRoof + this.roofHeight;
            }
        }

        private class MansardRoof
        extends RoofWithRidge {
            private final LineSegmentXZ mansardEdge1;
            private final LineSegmentXZ mansardEdge2;

            public MansardRoof() {
                super(0.3333333333333333);
                this.mansardEdge1 = new LineSegmentXZ(GeometryUtil.interpolateBetween(this.cap1.p1, this.ridge.p1, 0.3333333333333333), GeometryUtil.interpolateBetween(this.cap2.p2, this.ridge.p2, 0.3333333333333333));
                this.mansardEdge2 = new LineSegmentXZ(GeometryUtil.interpolateBetween(this.cap1.p2, this.ridge.p1, 0.3333333333333333), GeometryUtil.interpolateBetween(this.cap2.p1, this.ridge.p2, 0.3333333333333333));
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                return BuildingPart.this.polygon;
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return Arrays.asList(this.ridge, this.mansardEdge1, this.mansardEdge2, new LineSegmentXZ(this.ridge.p1, this.mansardEdge1.p1), new LineSegmentXZ(this.ridge.p1, this.mansardEdge2.p1), new LineSegmentXZ(this.ridge.p2, this.mansardEdge1.p2), new LineSegmentXZ(this.ridge.p2, this.mansardEdge2.p2), new LineSegmentXZ(this.cap1.p1, this.mansardEdge1.p1), new LineSegmentXZ(this.cap2.p2, this.mansardEdge1.p2), new LineSegmentXZ(this.cap1.p2, this.mansardEdge2.p1), new LineSegmentXZ(this.cap2.p1, this.mansardEdge2.p2), new LineSegmentXZ(this.mansardEdge1.p1, this.mansardEdge2.p1), new LineSegmentXZ(this.mansardEdge1.p2, this.mansardEdge2.p2));
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                if (this.ridge.p1.equals(vectorXZ) || this.ridge.p2.equals(vectorXZ)) {
                    return this.getMaxRoofEle();
                }
                if (this.getPolygon().getOuter().getVertexLoop().contains(vectorXZ)) {
                    return this.getMaxRoofEle() - this.roofHeight;
                }
                if (this.mansardEdge1.p1.equals(vectorXZ) || this.mansardEdge1.p2.equals(vectorXZ) || this.mansardEdge2.p1.equals(vectorXZ) || this.mansardEdge2.p2.equals(vectorXZ)) {
                    return this.getMaxRoofEle() - 0.3333333333333333 * this.roofHeight;
                }
                return null;
            }
        }

        private class GambrelRoof
        extends RoofWithRidge {
            private final LineSegmentXZ cap1part;
            private final LineSegmentXZ cap2part;

            public GambrelRoof() {
                super(0.0);
                this.cap1part = new LineSegmentXZ(GeometryUtil.interpolateBetween(this.cap1.p1, this.cap1.p2, 0.16666666666666666), GeometryUtil.interpolateBetween(this.cap1.p1, this.cap1.p2, 0.8333333333333334));
                this.cap2part = new LineSegmentXZ(GeometryUtil.interpolateBetween(this.cap2.p1, this.cap2.p2, 0.16666666666666666), GeometryUtil.interpolateBetween(this.cap2.p1, this.cap2.p2, 0.8333333333333334));
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                PolygonXZ polygonXZ = BuildingPart.this.polygon.getOuter();
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.ridge.p1, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.ridge.p2, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap1part.p1, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap1part.p2, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap2part.p1, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap2part.p2, 0.2);
                return new PolygonWithHolesXZ(polygonXZ.asSimplePolygon(), BuildingPart.this.polygon.getHoles());
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return Arrays.asList(this.ridge, new LineSegmentXZ(this.cap1part.p1, this.cap2part.p2), new LineSegmentXZ(this.cap1part.p2, this.cap2part.p1));
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                double d = GeometryUtil.distanceFromLineSegment(vectorXZ, this.ridge);
                double d2 = d / this.maxDistanceToRidge;
                if (d2 < 0.6666666666666666) {
                    return this.getMaxRoofEle() - 0.5 * this.roofHeight * d2;
                }
                return this.getMaxRoofEle() - 0.3333333333333333 * this.roofHeight - 2.0 * this.roofHeight * (d2 - 0.6666666666666666);
            }
        }

        private class HalfHippedRoof
        extends RoofWithRidge {
            private final LineSegmentXZ cap1part;
            private final LineSegmentXZ cap2part;

            public HalfHippedRoof() {
                super(0.16666666666666666);
                this.cap1part = new LineSegmentXZ(GeometryUtil.interpolateBetween(this.cap1.p1, this.cap1.p2, 0.5 - this.ridgeOffset / this.cap1.getLength()), GeometryUtil.interpolateBetween(this.cap1.p1, this.cap1.p2, 0.5 + this.ridgeOffset / this.cap1.getLength()));
                this.cap2part = new LineSegmentXZ(GeometryUtil.interpolateBetween(this.cap2.p1, this.cap2.p2, 0.5 - this.ridgeOffset / this.cap1.getLength()), GeometryUtil.interpolateBetween(this.cap2.p1, this.cap2.p2, 0.5 + this.ridgeOffset / this.cap1.getLength()));
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                PolygonXZ polygonXZ = BuildingPart.this.polygon.getOuter();
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap1part.p1, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap1part.p2, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap2part.p1, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.cap2part.p2, 0.2);
                return new PolygonWithHolesXZ(polygonXZ.asSimplePolygon(), BuildingPart.this.polygon.getHoles());
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return Arrays.asList(this.ridge, new LineSegmentXZ(this.ridge.p1, this.cap1part.p1), new LineSegmentXZ(this.ridge.p1, this.cap1part.p2), new LineSegmentXZ(this.ridge.p2, this.cap2part.p1), new LineSegmentXZ(this.ridge.p2, this.cap2part.p2));
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                if (this.ridge.p1.equals(vectorXZ) || this.ridge.p2.equals(vectorXZ)) {
                    return this.getMaxRoofEle();
                }
                if (this.getPolygon().getOuter().getVertexLoop().contains(vectorXZ)) {
                    if (GeometryUtil.distanceFromLineSegment(vectorXZ, this.cap1part) < 0.05) {
                        return this.getMaxRoofEle() - this.roofHeight * this.ridgeOffset / (this.cap1.getLength() / 2.0);
                    }
                    if (GeometryUtil.distanceFromLineSegment(vectorXZ, this.cap2part) < 0.05) {
                        return this.getMaxRoofEle() - this.roofHeight * this.ridgeOffset / (this.cap2.getLength() / 2.0);
                    }
                    return this.getMaxRoofEle() - this.roofHeight;
                }
                return null;
            }
        }

        private class HippedRoof
        extends RoofWithRidge {
            public HippedRoof() {
                super(0.3333333333333333);
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                return BuildingPart.this.polygon;
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return Arrays.asList(this.ridge, new LineSegmentXZ(this.ridge.p1, this.cap1.p1), new LineSegmentXZ(this.ridge.p1, this.cap1.p2), new LineSegmentXZ(this.ridge.p2, this.cap2.p1), new LineSegmentXZ(this.ridge.p2, this.cap2.p2));
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                if (this.ridge.p1.equals(vectorXZ) || this.ridge.p2.equals(vectorXZ)) {
                    return this.getMaxRoofEle();
                }
                if (this.getPolygon().getOuter().getVertexLoop().contains(vectorXZ)) {
                    return this.getMaxRoofEle() - this.roofHeight;
                }
                return null;
            }
        }

        private class GabledRoof
        extends RoofWithRidge {
            public GabledRoof() {
                super(0.0);
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                PolygonXZ polygonXZ = BuildingPart.this.polygon.getOuter();
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.ridge.p1, 0.2);
                polygonXZ = GeometryUtil.insertIntoPolygon(polygonXZ, this.ridge.p2, 0.2);
                return new PolygonWithHolesXZ(polygonXZ.asSimplePolygon(), BuildingPart.this.polygon.getHoles());
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return Collections.singleton(this.ridge);
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                double d = GeometryUtil.distanceFromLineSegment(vectorXZ, this.ridge);
                double d2 = d / this.maxDistanceToRidge;
                return this.getMaxRoofEle() - this.roofHeight * d2;
            }
        }

        private abstract class RoofWithRidge
        extends HeightfieldRoof {
            protected final double ridgeOffset;
            protected final LineSegmentXZ ridge;
            protected final LineSegmentXZ cap1;
            protected final LineSegmentXZ cap2;
            protected final double maxDistanceToRidge;

            public RoofWithRidge(double d) {
                Object object;
                SimplePolygonXZ simplePolygonXZ = BuildingPart.this.polygon.getOuter();
                SimplePolygonXZ simplePolygonXZ2 = simplePolygonXZ.getSimplifiedPolygon();
                VectorXZ vectorXZ = null;
                if (BuildingPart.this.area.getTags().containsKey("roof:ridge:direction") && (object = ValueStringParser.parseAngle(BuildingPart.this.area.getTags().getValue("roof:ridge:direction"))) != null) {
                    vectorXZ = VectorXZ.fromAngle(Math.toRadians(((Float)object).floatValue()));
                }
                if (vectorXZ == null) {
                    object = MinMaxUtil.max(simplePolygonXZ2.getSegments(), new Function<LineSegmentXZ, Double>(){

                        @Override
                        public Double apply(LineSegmentXZ lineSegmentXZ) {
                            return lineSegmentXZ.getLength();
                        }
                    });
                    vectorXZ = ((LineSegmentXZ)object).p2.subtract(((LineSegmentXZ)object).p1).normalize();
                }
                object = simplePolygonXZ.getCentroid();
                Collection<LineSegmentXZ> collection = simplePolygonXZ2.intersectionSegments(new LineSegmentXZ(((VectorXZ)object).add(vectorXZ.mult(-1000.0)), ((VectorXZ)object).add(vectorXZ.mult(1000.0))));
                Iterator<LineSegmentXZ> iterator = collection.iterator();
                this.cap1 = iterator.next();
                this.cap2 = iterator.next();
                VectorXZ vectorXZ2 = this.cap1.getCenter();
                VectorXZ vectorXZ3 = this.cap2.getCenter();
                this.ridgeOffset = Math.min(this.cap1.getLength() * d, 0.4 * vectorXZ2.distanceTo(vectorXZ3));
                this.ridge = d == 0.0 ? new LineSegmentXZ(vectorXZ2, vectorXZ3) : new LineSegmentXZ(vectorXZ2.add(((VectorXZ)object).subtract(vectorXZ2).normalize().mult(this.ridgeOffset)), vectorXZ3.add(((VectorXZ)object).subtract(vectorXZ3).normalize().mult(this.ridgeOffset)));
                double d2 = 0.0;
                for (VectorXZ vectorXZ4 : simplePolygonXZ.getVertices()) {
                    d2 = Math.max(d2, GeometryUtil.distanceFromLineSegment(vectorXZ4, this.ridge));
                }
                this.maxDistanceToRidge = d2;
            }
        }

        private class PyramidalRoof
        extends HeightfieldRoof {
            private final VectorXZ apex;
            private final List<LineSegmentXZ> innerSegments;

            public PyramidalRoof() {
                SimplePolygonXZ simplePolygonXZ = BuildingPart.this.polygon.getOuter();
                this.apex = simplePolygonXZ.getCentroid();
                this.innerSegments = new ArrayList<LineSegmentXZ>();
                for (VectorXZ vectorXZ : simplePolygonXZ.getVertices()) {
                    this.innerSegments.add(new LineSegmentXZ(vectorXZ, this.apex));
                }
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                return BuildingPart.this.polygon;
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.singletonList(this.apex);
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return this.innerSegments;
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                if (this.apex.equals(vectorXZ)) {
                    return this.getMaxRoofEle();
                }
                if (BuildingPart.this.polygon.getOuter().getVertices().contains(vectorXZ)) {
                    return this.getMaxRoofEle() - this.roofHeight;
                }
                return null;
            }
        }

        private class FlatRoof
        extends HeightfieldRoof {
            private FlatRoof() {
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                return BuildingPart.this.polygon;
            }

            @Override
            public Collection<VectorXZ> getInnerPoints() {
                return Collections.emptyList();
            }

            @Override
            public Collection<LineSegmentXZ> getInnerSegments() {
                return Collections.emptyList();
            }

            @Override
            public double getRoofHeight() {
                return 0.0;
            }

            @Override
            public Double getRoofEleAt_noInterpolation(VectorXZ vectorXZ) {
                return this.getMaxRoofEle();
            }

            @Override
            public double getMaxRoofEle() {
                return BuildingPart.this.building.getArea().getElevationProfile().getMinEle() + BuildingPart.this.heightWithoutRoof;
            }
        }

        public abstract class HeightfieldRoof
        extends TaggedRoof {
            public abstract Collection<LineSegmentXZ> getInnerSegments();

            public abstract Collection<VectorXZ> getInnerPoints();

            protected abstract Double getRoofEleAt_noInterpolation(VectorXZ var1);

            @Override
            public double getRoofEleAt(VectorXZ vectorXZ) {
                Double d = this.getRoofEleAt_noInterpolation(vectorXZ);
                if (d != null) {
                    return d;
                }
                ArrayList<LineSegmentXZ> arrayList = new ArrayList<LineSegmentXZ>();
                arrayList.addAll(this.getInnerSegments());
                arrayList.addAll(this.getPolygon().getOuter().getSegments());
                for (SimplePolygonXZ simplePolygonXZ : this.getPolygon().getHoles()) {
                    arrayList.addAll(simplePolygonXZ.getSegments());
                }
                Object object = null;
                double d2 = Double.MAX_VALUE;
                for (LineSegmentXZ lineSegmentXZ : arrayList) {
                    double d3 = GeometryUtil.distanceFromLineSegment(vectorXZ, lineSegmentXZ);
                    if (!(d3 < d2)) continue;
                    object = lineSegmentXZ;
                    d2 = d3;
                }
                return GeometryUtil.interpolateValue(vectorXZ, ((LineSegmentXZ)object).p1, this.getRoofEleAt_noInterpolation(((LineSegmentXZ)object).p1), ((LineSegmentXZ)object).p2, this.getRoofEleAt_noInterpolation(((LineSegmentXZ)object).p2));
            }

            @Override
            public void renderTo(Target<?> target) {
                List<TriangleXZ> list = JTSTriangulationUtil.triangulate(this.getPolygon().getOuter(), this.getPolygon().getHoles(), this.getInnerSegments(), this.getInnerPoints());
                ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size());
                for (TriangleXZ triangleXZ : list) {
                    TriangleXZ triangleXZ2 = triangleXZ.makeCounterclockwise();
                    arrayList.add(new TriangleXYZ(this.withRoofEle(triangleXZ2.v1), this.withRoofEle(triangleXZ2.v2), this.withRoofEle(triangleXZ2.v3)));
                }
                target.drawTriangles(BuildingPart.this.materialRoof, arrayList);
            }

            private VectorXYZ withRoofEle(VectorXZ vectorXZ) {
                return vectorXZ.xyz(this.getRoofEleAt(vectorXZ));
            }
        }

        private class OnionRoof
        extends TaggedRoof {
            private OnionRoof() {
            }

            @Override
            public PolygonWithHolesXZ getPolygon() {
                return BuildingPart.this.polygon;
            }

            @Override
            public double getRoofEleAt(VectorXZ vectorXZ) {
                return this.getMaxRoofEle() - this.getRoofHeight();
            }

            @Override
            public void renderTo(Target<?> target) {
                double d = this.getMaxRoofEle() - this.getRoofHeight();
                this.renderSpindle(target, BuildingPart.this.materialRoof, BuildingPart.this.polygon.getOuter(), Arrays.asList(d, d + 0.15 * this.roofHeight, d + 0.52 * this.roofHeight, d + 0.72 * this.roofHeight, d + 0.82 * this.roofHeight, d + 1.0 * this.roofHeight), Arrays.asList(1.0, 0.8, 1.0, 0.7, 0.15, 0.0));
            }

            private void renderSpindle(Target<?> target, Material material, SimplePolygonXZ simplePolygonXZ, List<Double> list, List<Double> list2) {
                int n;
                Preconditions.checkArgument(list.size() == list2.size(), "heights and scaleFactors must have same size");
                int n2 = list.size();
                VectorXZ vectorXZ = simplePolygonXZ.getCenter();
                List[] listArray = new List[n2];
                for (n = 0; n < n2; ++n) {
                    double d = list.get(n);
                    double d2 = list2.get(n);
                    if (d2 == 0.0) {
                        listArray[n] = Collections.singletonList(vectorXZ.xyz(d));
                        continue;
                    }
                    listArray[n] = new ArrayList();
                    for (VectorXZ vectorXZ2 : simplePolygonXZ.getVertexLoop()) {
                        listArray[n].add(GeometryUtil.interpolateBetween(vectorXZ, vectorXZ2, d2).xyz(d));
                    }
                }
                n = 0;
                while (n + 1 < n2) {
                    ArrayList arrayList;
                    if (listArray[n].size() > 1 && listArray[n + 1].size() > 1) {
                        arrayList = new ArrayList();
                        for (int i = 0; i < listArray[n].size(); ++i) {
                            arrayList.add(listArray[n].get(i));
                            arrayList.add(listArray[n + 1].get(i));
                        }
                        target.drawTriangleStrip(material, arrayList);
                    } else if (listArray[n].size() == 1 && listArray[n + 1].size() > 1) {
                        arrayList = new ArrayList();
                        arrayList.add(listArray[n].get(0));
                        arrayList.addAll(listArray[n + 1]);
                        target.drawTriangleFan(material, arrayList);
                    } else if (listArray[n].size() > 1 && listArray[n + 1].size() == 1) {
                        arrayList = new ArrayList();
                        arrayList.addAll(listArray[n]);
                        arrayList.add(listArray[n + 1].get(0));
                        Collections.reverse(arrayList);
                        target.drawTriangleFan(material, arrayList);
                    }
                    ++n;
                }
            }
        }

        private abstract class TaggedRoof
        implements Roof {
            protected final double roofHeight;

            TaggedRoof() {
                Float f = null;
                if (BuildingPart.this.area.getTags().containsKey("roof:height")) {
                    String string = BuildingPart.this.area.getTags().getValue("roof:height");
                    f = ValueStringParser.parseMeasure(string);
                }
                this.roofHeight = f != null ? (double)f.floatValue() : 5.0;
            }

            @Override
            public double getRoofHeight() {
                return this.roofHeight;
            }

            @Override
            public double getMaxRoofEle() {
                return BuildingPart.this.building.getArea().getElevationProfile().getMinEle() + BuildingPart.this.heightWithoutRoof + this.roofHeight;
            }
        }

        public static interface Roof
        extends RenderableToAllTargets {
            public PolygonWithHolesXZ getPolygon();

            public double getRoofEleAt(VectorXZ var1);

            public double getRoofHeight();

            public double getMaxRoofEle();
        }
    }

    public static class Building
    implements AreaWorldObject,
    WorldObjectWithOutline,
    RenderableToAllTargets {
        private final MapArea area;
        private final List<BuildingPart> parts = new ArrayList<BuildingPart>();

        public Building(MapArea mapArea) {
            this.area = mapArea;
            for (MapOverlap<?, ?> object3 : mapArea.getOverlaps()) {
                MapElement mapElement = object3.getOther(mapArea);
                if (!(mapElement instanceof MapArea) || !mapElement.getTags().containsKey("building:part")) continue;
                Object object = (MapArea)mapElement;
                if (!mapArea.getOuterPolygon().contains(((MapArea)object).getOuterPolygon().getCenter())) continue;
                this.parts.add(new BuildingPart(this, (MapArea)object, ((MapArea)object).getPolygon()));
            }
            if (this.parts.isEmpty()) {
                this.parts.add(new BuildingPart(this, mapArea, mapArea.getPolygon()));
            } else {
                ArrayList arrayList = new ArrayList();
                for (BuildingPart buildingPart : this.parts) {
                    arrayList.add(buildingPart.getPolygon().getOuter());
                }
                arrayList.addAll(mapArea.getPolygon().getHoles());
                Collection<PolygonWithHolesXZ> collection = CAGUtil.subtractPolygons(mapArea.getPolygon().getOuter(), arrayList);
                for (Object object : collection) {
                    this.parts.add(new BuildingPart(this, mapArea, (PolygonWithHolesXZ)object));
                }
            }
        }

        public MapArea getArea() {
            return this.area;
        }

        public List<BuildingPart> getParts() {
            return this.parts;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.area;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            double d = 0.0;
            for (BuildingPart buildingPart : this.parts) {
                double d2 = buildingPart.getClearingAbove(vectorXZ);
                d = Math.max(d2, d);
            }
            return d;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public PolygonXYZ getOutlinePolygon() {
            return this.area.getPolygon().getOuter().xyz(this.area.getElevationProfile().getMinEle());
        }

        @Override
        public void renderTo(Target<?> target) {
            for (BuildingPart buildingPart : this.parts) {
                buildingPart.renderTo(target);
            }
        }
    }
}

