/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.world.data.AbstractAreaWorldObject;
import org.osm2world.core.world.data.NoOutlineNodeWorldObject;
import org.osm2world.core.world.data.NoOutlineWaySegmentWorldObject;
import org.osm2world.core.world.modules.common.AbstractModule;

public class InvisibleModule
extends AbstractModule {
    @Override
    protected void applyToNode(MapNode mapNode) {
        if (mapNode.getTags().containsKey("ele") && mapNode.getRepresentations().isEmpty()) {
            boolean bl = false;
            for (MapSegment mapSegment : mapNode.getConnectedSegments()) {
                MapElement mapElement = mapSegment instanceof MapWaySegment ? (MapWaySegment)mapSegment : ((MapAreaSegment)mapSegment).getArea();
                if (mapElement.getPrimaryRepresentation() == null || mapElement.getPrimaryRepresentation().getGroundState() != GroundState.ON) continue;
                bl = true;
                break;
            }
            if (mapNode.getConnectedSegments().isEmpty() || bl) {
                mapNode.addRepresentation(new InvisibleEleNode(mapNode));
            }
        }
    }

    @Override
    protected void applyToWaySegment(MapWaySegment mapWaySegment) {
        if (mapWaySegment.getTags().containsKey("ele") && mapWaySegment.getRepresentations().isEmpty()) {
            mapWaySegment.addRepresentation(new InvisibleEleWaySegment(mapWaySegment));
        }
    }

    @Override
    protected void applyToArea(MapArea mapArea) {
        if (mapArea.getTags().containsKey("ele") && mapArea.getRepresentations().isEmpty()) {
            mapArea.addRepresentation(new InvisibleEleArea(mapArea));
        }
    }

    private static class InvisibleEleArea
    extends AbstractAreaWorldObject {
        protected InvisibleEleArea(MapArea mapArea) {
            super(mapArea);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }
    }

    private static class InvisibleEleWaySegment
    extends NoOutlineWaySegmentWorldObject {
        public InvisibleEleWaySegment(MapWaySegment mapWaySegment) {
            super(mapWaySegment);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }
    }

    private static class InvisibleEleNode
    extends NoOutlineNodeWorldObject {
        public InvisibleEleNode(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }
    }
}

