/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.AbstractAreaWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.modules.common.AbstractModule;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;

public class ParkingModule
extends AbstractModule {
    @Override
    protected void applyToArea(MapArea mapArea) {
        String string;
        if (mapArea.getTags().contains("amenity", "parking") && ("surface".equals(string = mapArea.getTags().getValue("parking")) || string == null)) {
            mapArea.addRepresentation(new SurfaceParking(mapArea));
        }
    }

    private static class SurfaceParking
    extends AbstractAreaWorldObject
    implements TerrainBoundaryWorldObject,
    RenderableToAllTargets {
        public SurfaceParking(MapArea mapArea) {
            super(mapArea);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return WorldModuleParseUtil.parseClearing(this.area.getTags(), 3.0f);
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        public void renderTo(Target target) {
            String string = this.area.getTags().getValue("surface");
            target.drawTriangles(Materials.getSurfaceMaterial(string, Materials.ASPHALT), this.getTriangulation());
        }
    }
}

