/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.util.Predicates;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.modules.BridgeModule;
import org.osm2world.core.world.modules.TunnelModule;
import org.osm2world.core.world.modules.common.ConfigurableWorldModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.network.AbstractNetworkWaySegmentWorldObject;
import org.osm2world.core.world.network.JunctionNodeWorldObject;

public class RailwayModule
extends ConfigurableWorldModule {
    @Override
    public void applyTo(MapData mapData) {
        for (MapWaySegment mapElement : mapData.getMapWaySegments()) {
            TagGroup tagGroup = mapElement.getOsmWay().tags;
            if (!"rail".equals(tagGroup.getValue("railway")) && !"light_rail".equals(tagGroup.getValue("railway")) && !"tram".equals(tagGroup.getValue("railway")) && !"disused".equals(tagGroup.getValue("railway"))) continue;
            mapElement.addRepresentation(new Rail(mapElement, tagGroup));
        }
        for (MapNode mapNode : mapData.getMapNodes()) {
            int n = 0;
            for (MapWaySegment mapWaySegment : mapNode.getConnectedWaySegments()) {
                if (!Iterables.any(mapWaySegment.getRepresentations(), Predicates.hasType(Rail.class))) continue;
                ++n;
            }
            if (n <= 2) continue;
        }
    }

    public static class RailJunction
    extends JunctionNodeWorldObject
    implements NodeWorldObject,
    RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        public RailJunction(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            GroundState groundState = null;
            for (MapWaySegment mapWaySegment : this.node.getConnectedWaySegments()) {
                if (mapWaySegment.getPrimaryRepresentation() == null) continue;
                GroundState groundState2 = mapWaySegment.getPrimaryRepresentation().getGroundState();
                if (groundState == null) {
                    groundState = groundState2;
                    continue;
                }
                if (groundState == groundState2) continue;
                groundState = GroundState.ON;
                break;
            }
            return groundState;
        }

        @Override
        public void renderTo(Target<?> target) {
            if (this.getJunctionArea() == null) {
                return;
            }
            List<VectorXYZ> list = this.getJunctionArea().getVertexLoop();
            VectorXYZ[] vectorXYZArray = list.toArray(new VectorXYZ[list.size()]);
            target.drawPolygon(Materials.RAIL_BALLAST_DEFAULT, vectorXYZArray);
            for (int i = 0; i < this.cutCenters.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                }
            }
        }
    }

    private static class Rail
    extends AbstractNetworkWaySegmentWorldObject
    implements WaySegmentWorldObject,
    RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        private static final float GROUND_WIDTH = 2.25f;
        private static final float RAIL_DIST = 1.5f;
        private static final float SLEEPER_WIDTH = 2.0f;
        private static final float SLEEPER_LENGTH = 0.75f;
        private static final float SLEEPER_HEIGHT = 0.125f;
        private static final VectorXYZ SLEEPER_UP = VectorXYZ.Y_UNIT.mult(0.125);
        private static final VectorXYZ[] RAIL_SHAPE = new VectorXYZ[]{new VectorXYZ(-0.45f, 0.0, 0.0), new VectorXYZ(-0.1f, 0.1f, 0.0), new VectorXYZ(-0.1f, 0.5, 0.0), new VectorXYZ(-0.25, 0.55f, 0.0), new VectorXYZ(-0.25, 0.75, 0.0), new VectorXYZ(0.25, 0.75, 0.0), new VectorXYZ(0.25, 0.55f, 0.0), new VectorXYZ(0.1f, 0.5, 0.0), new VectorXYZ(0.1f, 0.1f, 0.0), new VectorXYZ(0.45f, 0.0, 0.0)};
        private final TagGroup tags;

        public Rail(MapWaySegment mapWaySegment, TagGroup tagGroup) {
            super(mapWaySegment);
            this.tags = tagGroup;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 5.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            if (BridgeModule.isBridge(this.tags)) {
                return GroundState.ABOVE;
            }
            if (TunnelModule.isTunnel(this.tags)) {
                return GroundState.BELOW;
            }
            return GroundState.ON;
        }

        @Override
        public void renderTo(Target<?> target) {
            Object object;
            Object object2;
            Object object3;
            VectorXYZ[] vectorXYZArray = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(this.getOutline(false), this.getOutline(true));
            target.drawTriangleStrip((Material)Materials.RAIL_BALLAST_DEFAULT, vectorXYZArray);
            List[] listArray = new List[]{WorldModuleGeometryUtil.createLineBetween(this.getOutline(false), this.getOutline(true), 0.16666667f), WorldModuleGeometryUtil.createLineBetween(this.getOutline(false), this.getOutline(true), 0.8333333f)};
            for (List object42 : listArray) {
                object3 = WorldModuleGeometryUtil.createShapeExtrusionAlong(RAIL_SHAPE, object42, Collections.nCopies(object42.size(), VectorXYZ.Y_UNIT));
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    target.drawTriangleStrip((Material)Materials.RAIL_DEFAULT, (VectorXYZ[])object);
                }
            }
            List<VectorXZ> list = GeometryUtil.equallyDistributePointsAlong(3.0, false, this.getStartWithOffset(), this.getEndWithOffset());
            VectorXYZ vectorXYZ = this.line.getRightNormal().mult(2.0).xyz(0.0);
            VectorXYZ vectorXYZ2 = this.line.getDirection().mult(0.75).xyz(0.0);
            VectorXYZ vectorXYZ3 = vectorXYZ.mult(-0.5).add(vectorXYZ2.mult(-0.5));
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (VectorXZ)object3.next();
                object = ((VectorXZ)object2).xyz(this.line.getElevationProfile().getEleAt((VectorXZ)object2));
                VectorXYZ vectorXYZ4 = ((VectorXYZ)object).add(vectorXYZ3);
                target.drawBox(Materials.RAIL_SLEEPER_DEFAULT, vectorXYZ4, vectorXYZ, SLEEPER_UP, vectorXYZ2);
            }
        }

        @Override
        public float getWidth() {
            return 2.25f;
        }

        static {
            for (int i = 0; i < RAIL_SHAPE.length; ++i) {
                Rail.RAIL_SHAPE[i] = RAIL_SHAPE[i].mult(0.25);
                Rail.RAIL_SHAPE[i] = RAIL_SHAPE[i].y(Rail.RAIL_SHAPE[i].y + 0.125);
            }
        }
    }
}

