/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.modules.BridgeModule;
import org.osm2world.core.world.modules.TunnelModule;
import org.osm2world.core.world.modules.common.ConfigurableWorldModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;
import org.osm2world.core.world.network.AbstractNetworkWaySegmentWorldObject;
import org.osm2world.core.world.network.JunctionNodeWorldObject;
import org.osm2world.core.world.network.NetworkAreaWorldObject;
import org.osm2world.core.world.network.VisibleConnectorNodeWorldObject;

public class RoadModule
extends ConfigurableWorldModule {
    @Override
    public void applyTo(MapData mapData) {
        Iterable<VectorXZ> iterable;
        for (MapWaySegment mapElement : mapData.getMapWaySegments()) {
            if (!RoadModule.isRoad(mapElement.getTags())) continue;
            mapElement.addRepresentation(new Road(mapElement, mapElement.getTags()));
        }
        for (MapArea mapArea : mapData.getMapAreas()) {
            if (!RoadModule.isRoad(mapArea.getTags())) continue;
            iterable = new ArrayList();
            for (MapNode mapNode : mapArea.getBoundaryNodes()) {
                iterable.add((VectorXZ)mapNode.getPos());
            }
            iterable.remove(iterable.size() - 1);
            mapArea.addRepresentation(new RoadArea(mapArea));
        }
        for (MapNode mapNode : mapData.getMapNodes()) {
            iterable = mapNode.getOsmNode().tags;
            ArrayList arrayList = new ArrayList();
            ArrayList<MapWaySegment> arrayList2 = new ArrayList<MapWaySegment>();
            for (MapWaySegment mapWaySegment : mapNode.getInboundLines()) {
                if (!(mapWaySegment.getPrimaryRepresentation() instanceof Road)) continue;
                arrayList.add(mapWaySegment);
            }
            for (MapWaySegment mapWaySegment : mapNode.getOutboundLines()) {
                if (!(mapWaySegment.getPrimaryRepresentation() instanceof Road)) continue;
                arrayList2.add(mapWaySegment);
            }
            if (arrayList.size() <= 0 && arrayList2.size() <= 0) continue;
            if (arrayList.size() + arrayList2.size() > 2) {
                mapNode.addRepresentation(new RoadJunction(mapNode));
                continue;
            }
            if (arrayList.size() + arrayList2.size() != 2 || !"crossing".equals(iterable.getValue("highway"))) continue;
            mapNode.addRepresentation(new RoadCrossingAtConnector(mapNode));
        }
    }

    private static boolean isRoad(TagGroup tagGroup) {
        return tagGroup.containsKey("highway") || tagGroup.contains("railway", "platform") || tagGroup.contains("leisure", "track");
    }

    private static boolean isSteps(TagGroup tagGroup) {
        return tagGroup.contains(new Tag("highway", "steps"));
    }

    public static class RoadArea
    extends NetworkAreaWorldObject
    implements RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        private static final float DEFAULT_CLEARING = 5.0f;

        public RoadArea(MapArea mapArea) {
            super(mapArea);
        }

        @Override
        public void renderTo(Target<?> target) {
            String string = this.area.getTags().getValue("surface");
            target.drawTriangles(Materials.getSurfaceMaterial(string, Materials.ASPHALT), this.getTriangulation());
        }

        @Override
        public GroundState getGroundState() {
            if (BridgeModule.isBridge(this.area.getTags())) {
                return GroundState.ABOVE;
            }
            if (TunnelModule.isTunnel(this.area.getTags())) {
                return GroundState.BELOW;
            }
            return GroundState.ON;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return WorldModuleParseUtil.parseClearing(this.area.getTags(), 5.0f);
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }
    }

    public static class Road
    extends AbstractNetworkWaySegmentWorldObject
    implements WaySegmentWorldObject,
    RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        protected static final float DEFAULT_LANE_WIDTH = 3.5f;
        protected static final float DEFAULT_ROAD_CLEARING = 5.0f;
        protected static final float DEFAULT_PATH_CLEARING = 2.0f;
        protected static final VectorXYZ[] HANDRAIL_SHAPE = new VectorXYZ[]{new VectorXYZ(-0.02f, -0.05f, 0.0), new VectorXYZ(-0.02f, 0.0, 0.0), new VectorXYZ(0.02f, 0.0, 0.0), new VectorXYZ(0.02f, -0.05f, 0.0)};
        public final float width;
        private final TagGroup tags;
        public final VectorXZ startCoord;
        public final VectorXZ endCoord;
        private final boolean steps;

        public Road(MapWaySegment mapWaySegment, TagGroup tagGroup) {
            super(mapWaySegment);
            this.tags = tagGroup;
            this.startCoord = mapWaySegment.getStartNode().getPos();
            this.endCoord = mapWaySegment.getEndNode().getPos();
            float f = Road.getDefaultWidth(tagGroup);
            if (tagGroup.containsKey("lanes")) {
                try {
                    f = (float)Integer.parseInt(tagGroup.getValue("lanes")) * 3.5f;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.width = WorldModuleParseUtil.parseWidth(tagGroup, f);
            this.steps = RoadModule.isSteps(tagGroup);
        }

        private static float getDefaultWidth(TagGroup tagGroup) {
            String string = tagGroup.getValue("highway");
            if (Road.isPath(tagGroup)) {
                return 1.0f;
            }
            if ("service".equals(string) || "track".equals(string)) {
                if (tagGroup.contains("service", "parking_aisle")) {
                    return 2.8f;
                }
                return 3.5f;
            }
            if ("primary".equals(string) || "secondary".equals(string)) {
                return 7.0f;
            }
            if ("motorway".equals(string)) {
                return 8.75f;
            }
            if (tagGroup.containsKey("oneway") && !tagGroup.getValue("oneway").equals("no")) {
                return 3.5f;
            }
            return 4.0f;
        }

        private static boolean isPath(TagGroup tagGroup) {
            String string = tagGroup.getValue("highway");
            return "path".equals(string) || "footway".equals(string) || "cycleway".equals(string) || "bridleway".equals(string) || "steps".equals(string);
        }

        @Override
        public float getWidth() {
            return this.width;
        }

        /*
         * WARNING - void declaration
         */
        private void renderStepsUsing(Target<?> target) {
            Object object;
            Vector3D vector3D22;
            WaySegmentElevationProfile waySegmentElevationProfile = this.line.getElevationProfile();
            VectorXZ vectorXZ = this.getStartPosition();
            VectorXZ vectorXZ2 = this.getEndPosition();
            List<VectorXYZ> list = this.getOutline(false);
            List<VectorXYZ> list2 = this.getOutline(true);
            double d = VectorXZ.distance(this.line.getStartNode().getPos(), this.line.getEndNode().getPos());
            VectorXYZ[] vectorXYZArray = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list, list2);
            target.drawTriangleStrip((Material)Materials.ASPHALT, vectorXYZArray);
            float f = 0.3f;
            if (this.tags.containsKey("step_count")) {
                try {
                    int n = Integer.parseInt(this.tags.getValue("step_count"));
                    f = (float)d / (float)n;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            List<VectorXZ> list3 = GeometryUtil.equallyDistributePointsAlong(f, true, vectorXZ, vectorXZ2);
            ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
            for (Vector3D vector3D22 : list3) {
                VectorXYZ vectorXYZ = vector3D22.xyz(waySegmentElevationProfile.getEleAt((VectorXZ)vector3D22));
                arrayList.add(vectorXYZ);
            }
            VectorXYZ vectorXYZ = this.line.getRightNormal().mult(this.width).xyz(0.0);
            vector3D22 = vectorXYZ.mult(-0.5);
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                void object2;
                VectorXYZ vectorXYZ2 = (VectorXYZ)arrayList.get(i);
                VectorXYZ vectorXYZ3 = (VectorXYZ)arrayList.get(i + 1);
                if (vectorXYZ2.y > vectorXYZ3.y) {
                    VectorXYZ vectorXYZ4 = vectorXYZ2.y(vectorXYZ3.y);
                } else {
                    VectorXYZ vectorXYZ5 = vectorXYZ2;
                }
                object = new VectorXYZ(0.0, Math.abs(vectorXYZ2.y - vectorXYZ3.y), 0.0);
                target.drawBox(Materials.STEPS_DEFAULT, object2.add((VectorXYZ)vector3D22), vectorXYZ, (VectorXYZ)object, vectorXYZ3.subtract(vectorXYZ2).y(0.0));
            }
            ArrayList<List<VectorXYZ>> arrayList2 = new ArrayList<List<VectorXYZ>>();
            if (this.line.getTags().contains("handrail:left", "yes")) {
                arrayList2.add(list);
            }
            if (this.line.getTags().contains("handrail:right", "yes")) {
                arrayList2.add(list2);
            }
            int n = 0;
            if (this.line.getTags().contains("handrail:center", "yes")) {
                n = 1;
            } else if (this.line.getTags().containsKey("handrail:center")) {
                try {
                    n = Integer.parseInt(this.line.getTags().getValue("handrail:center"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (int i = 0; i < n; ++i) {
                arrayList2.add(WorldModuleGeometryUtil.createLineBetween(list, list2, ((float)i + 1.0f) / (float)(n + 1)));
            }
            for (List list4 : arrayList2) {
                Object object22;
                object = new ArrayList();
                for (Object object22 : list4) {
                    object.add(((VectorXYZ)object22).y(((VectorXYZ)object22).y + 1.0));
                }
                List<VectorXYZ[]> list5 = WorldModuleGeometryUtil.createShapeExtrusionAlong(HANDRAIL_SHAPE, (List<VectorXYZ>)object, Collections.nCopies(object.size(), VectorXYZ.Y_UNIT));
                object22 = list5.iterator();
                while (object22.hasNext()) {
                    VectorXYZ[] vectorXYZArray2 = (VectorXYZ[])object22.next();
                    target.drawTriangleStrip((Material)Materials.HANDRAIL_DEFAULT, vectorXYZArray2);
                }
                target.drawColumn(Materials.HANDRAIL_DEFAULT, 4, (VectorXYZ)list4.get(0), 1.0, 0.03, 0.03, false, true);
                target.drawColumn(Materials.HANDRAIL_DEFAULT, 4, (VectorXYZ)list4.get(list4.size() - 1), 1.0, 0.03, 0.03, false, true);
            }
        }

        @Override
        public void renderTo(Target<?> target) {
            if (!this.steps) {
                VectorXYZ[] vectorXYZArray = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(this.getOutline(false), this.getOutline(true));
                String string = this.tags.getValue("surface");
                target.drawTriangleStrip(Materials.getSurfaceMaterial(string, Materials.ASPHALT), vectorXYZArray);
            } else {
                this.renderStepsUsing(target);
            }
        }

        @Override
        public GroundState getGroundState() {
            if (BridgeModule.isBridge(this.tags)) {
                return GroundState.ABOVE;
            }
            if (TunnelModule.isTunnel(this.tags)) {
                return GroundState.BELOW;
            }
            return GroundState.ON;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return WorldModuleParseUtil.parseClearing(this.tags, Road.isPath(this.tags) ? 2.0f : 5.0f);
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }
    }

    public static class RoadCrossingAtConnector
    extends VisibleConnectorNodeWorldObject
    implements NodeWorldObject,
    RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        private static final float CROSSING_WIDTH = 3.0f;

        public RoadCrossingAtConnector(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public float getLength() {
            return 3.0f;
        }

        @Override
        public void renderTo(Target<?> target) {
            NodeElevationProfile nodeElevationProfile = this.node.getElevationProfile();
            VectorXYZ vectorXYZ = nodeElevationProfile.getWithEle(this.startPos);
            VectorXYZ vectorXYZ2 = nodeElevationProfile.getWithEle(this.endPos);
            VectorXYZ vectorXYZ3 = nodeElevationProfile.getWithEle(GeometryUtil.interpolateBetween(this.startPos, this.endPos, (double)0.1f));
            VectorXYZ vectorXYZ4 = nodeElevationProfile.getWithEle(GeometryUtil.interpolateBetween(this.startPos, this.endPos, (double)0.2f));
            VectorXYZ vectorXYZ5 = nodeElevationProfile.getWithEle(GeometryUtil.interpolateBetween(this.startPos, this.endPos, (double)0.8f));
            VectorXYZ vectorXYZ6 = nodeElevationProfile.getWithEle(GeometryUtil.interpolateBetween(this.startPos, this.endPos, (double)0.9f));
            double d = (double)this.startWidth * 0.5;
            double d2 = (double)this.endWidth * 0.5;
            double d3 = GeometryUtil.interpolateValue(vectorXYZ3.xz(), this.startPos, d, this.endPos, d2);
            double d4 = GeometryUtil.interpolateValue(vectorXYZ4.xz(), this.startPos, d, this.endPos, d2);
            double d5 = GeometryUtil.interpolateValue(vectorXYZ5.xz(), this.startPos, d, this.endPos, d2);
            double d6 = GeometryUtil.interpolateValue(vectorXYZ6.xz(), this.startPos, d, this.endPos, d2);
            target.drawTriangleStrip((Material)Materials.ASPHALT, vectorXYZ.subtract(this.cutVector.mult(d)), vectorXYZ.add(this.cutVector.mult(d)), vectorXYZ3.subtract(this.cutVector.mult(d3)), vectorXYZ3.add(this.cutVector.mult(d3)));
            target.drawTriangleStrip((Material)Materials.ASPHALT, vectorXYZ4.subtract(this.cutVector.mult(d4)), vectorXYZ4.add(this.cutVector.mult(d4)), vectorXYZ5.subtract(this.cutVector.mult(d5)), vectorXYZ5.add(this.cutVector.mult(d5)));
            target.drawTriangleStrip((Material)Materials.ASPHALT, vectorXYZ6.subtract(this.cutVector.mult(d6)), vectorXYZ6.add(this.cutVector.mult(d6)), vectorXYZ2.subtract(this.cutVector.mult(d2)), vectorXYZ2.add(this.cutVector.mult(d2)));
            target.drawTriangleStrip((Material)Materials.ROAD_MARKING, vectorXYZ3.subtract(this.cutVector.mult(d3)), vectorXYZ3.add(this.cutVector.mult(d3)), vectorXYZ4.subtract(this.cutVector.mult(d4)), vectorXYZ4.add(this.cutVector.mult(d4)));
            target.drawTriangleStrip((Material)Materials.ROAD_MARKING, vectorXYZ5.subtract(this.cutVector.mult(d5)), vectorXYZ5.add(this.cutVector.mult(d5)), vectorXYZ6.subtract(this.cutVector.mult(d6)), vectorXYZ6.add(this.cutVector.mult(d6)));
        }

        @Override
        public GroundState getGroundState() {
            GroundState groundState = null;
            for (MapWaySegment mapWaySegment : this.node.getConnectedWaySegments()) {
                if (mapWaySegment.getPrimaryRepresentation() == null) continue;
                GroundState groundState2 = mapWaySegment.getPrimaryRepresentation().getGroundState();
                if (groundState == null) {
                    groundState = groundState2;
                    continue;
                }
                if (groundState == groundState2) continue;
                groundState = GroundState.ON;
                break;
            }
            return groundState;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }
    }

    public static class RoadJunction
    extends JunctionNodeWorldObject
    implements NodeWorldObject,
    RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        public RoadJunction(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public void renderTo(Target<?> target) {
            target.drawTriangles(Materials.ASPHALT, super.getTriangulation());
        }

        @Override
        public GroundState getGroundState() {
            GroundState groundState = null;
            for (MapWaySegment mapWaySegment : this.node.getConnectedWaySegments()) {
                if (mapWaySegment.getPrimaryRepresentation() == null) continue;
                GroundState groundState2 = mapWaySegment.getPrimaryRepresentation().getGroundState();
                if (groundState == null) {
                    groundState = groundState2;
                    continue;
                }
                if (groundState == groundState2) continue;
                groundState = GroundState.ON;
                break;
            }
            return groundState;
        }
    }
}

