/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.graphview.core.util.ValueStringParser;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.NoOutlineNodeWorldObject;
import org.osm2world.core.world.modules.common.AbstractModule;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;

public class StreetFurnitureModule
extends AbstractModule {
    @Override
    protected void applyToNode(MapNode mapNode) {
        if (mapNode.getTags().contains("man_made", "flagpole")) {
            mapNode.addRepresentation(new Flagpole(mapNode));
        }
        if (mapNode.getTags().contains("advertising", "column")) {
            mapNode.addRepresentation(new AdvertisingColumn(mapNode));
        }
        if (mapNode.getTags().contains("advertising", "billboard")) {
            mapNode.addRepresentation(new Billboard(mapNode));
        }
        if (mapNode.getTags().contains("amenity", "bench")) {
            mapNode.addRepresentation(new Bench(mapNode));
        }
    }

    private static final class Bench
    extends NoOutlineNodeWorldObject
    implements RenderableToAllTargets {
        public Bench(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public void renderTo(Target<?> target) {
            double d = this.node.getElevationProfile().getEle();
            float f = WorldModuleParseUtil.parseWidth(this.node.getTags(), 1.5f);
            Material material = null;
            if (material == null) {
                material = Materials.getSurfaceMaterial(this.node.getTags().getValue("material"));
            }
            if (material == null) {
                material = Materials.getSurfaceMaterial(this.node.getTags().getValue("surface"), Materials.WOOD);
            }
            Float f2 = Float.valueOf(180.0f);
            if (this.node.getTags().containsKey("direction")) {
                f2 = ValueStringParser.parseAngle(this.node.getTags().getValue("direction"));
            }
            VectorXZ vectorXZ = VectorXZ.fromAngle(Math.toRadians(f2.floatValue()));
            VectorXZ vectorXZ2 = vectorXZ.rightNormal();
            ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(4);
            arrayList.add(vectorXZ.mult(0.25).add(vectorXZ2.mult(f / 2.0f)));
            arrayList.add(vectorXZ.mult(0.25).add(vectorXZ2.mult(-f / 2.0f)));
            arrayList.add(vectorXZ.mult(-0.25).add(vectorXZ2.mult(f / 2.0f)));
            arrayList.add(vectorXZ.mult(-0.25).add(vectorXZ2.mult(-f / 2.0f)));
            target.drawBox(material, this.node.getPos().xyz(d + 0.5), vectorXZ, 0.05, f, 0.5);
            if (!this.node.getTags().contains("backrest", "no")) {
                target.drawBox(material, this.node.getPos().add(vectorXZ.mult(-0.23)).xyz(d + 0.5), vectorXZ, 0.5, f, 0.04);
            }
            for (VectorXZ vectorXZ3 : arrayList) {
                VectorXZ vectorXZ4 = this.node.getPos().add(vectorXZ3.mult(0.8));
                target.drawBox(material, this.node.getElevationProfile().getWithEle(vectorXZ4), vectorXZ, 0.5, 0.08, 0.08);
            }
        }
    }

    private static final class Billboard
    extends NoOutlineNodeWorldObject
    implements RenderableToAllTargets {
        public Billboard(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public void renderTo(Target<?> target) {
            VectorXZ[] vectorXZArray;
            double d = this.node.getElevationProfile().getEle();
            float f = WorldModuleParseUtil.parseWidth(this.node.getTags(), 4.0f);
            float f2 = WorldModuleParseUtil.parseHeight(this.node.getTags(), 3.5f);
            float f3 = f2 / 5.0f;
            Float f4 = Float.valueOf(180.0f);
            if (this.node.getTags().containsKey("direction")) {
                f4 = ValueStringParser.parseAngle(this.node.getTags().getValue("direction"));
            }
            VectorXZ vectorXZ = VectorXZ.fromAngle(Math.toRadians(f4.floatValue()));
            VectorXZ vectorXZ2 = vectorXZ.rightNormal();
            VectorXYZ[] vectorXYZArray = new VectorXYZ[]{this.node.getPos().add(vectorXZ2.mult(-f / 2.0f)).xyz(d + (double)f3), this.node.getPos().add(vectorXZ2.mult(-f / 2.0f)).xyz(d + (double)f2), this.node.getPos().add(vectorXZ2.mult(f / 2.0f)).xyz(d + (double)f3), this.node.getPos().add(vectorXZ2.mult(f / 2.0f)).xyz(d + (double)f2)};
            target.drawTriangleStrip((Material)Materials.ADVERTISING_POSTER, vectorXYZArray);
            VectorXYZ vectorXYZ = vectorXYZArray[2];
            vectorXYZArray[2] = vectorXYZArray[0];
            vectorXYZArray[0] = vectorXYZ;
            vectorXYZ = vectorXYZArray[3];
            vectorXYZArray[3] = vectorXYZArray[1];
            vectorXYZArray[1] = vectorXYZ;
            target.drawTriangleStrip((Material)Materials.CONCRETE, vectorXYZArray);
            for (VectorXZ vectorXZ3 : vectorXZArray = new VectorXZ[]{this.node.getPos().add(vectorXZ2.mult(-f / 4.0f)), this.node.getPos().add(vectorXZ2.mult(f / 4.0f))}) {
                target.drawBox(Materials.CONCRETE, this.node.getElevationProfile().getWithEle(vectorXZ3), vectorXZ, f3, 0.2, 0.1);
            }
        }
    }

    private static final class AdvertisingColumn
    extends NoOutlineNodeWorldObject
    implements RenderableToAllTargets {
        public AdvertisingColumn(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public void renderTo(Target<?> target) {
            double d = this.node.getElevationProfile().getEle();
            float f = WorldModuleParseUtil.parseHeight(this.node.getTags(), 3.0f);
            target.drawColumn(Materials.CONCRETE, null, this.node.getPos().xyz(d), 0.15 * (double)f, 0.5, 0.5, false, false);
            target.drawColumn(Materials.ADVERTISING_POSTER, null, this.node.getPos().xyz(d), 0.98 * (double)f, 0.48, 0.48, false, false);
            target.drawColumn(Materials.CONCRETE, null, this.node.getPos().xyz(d + 0.95 * (double)f), 0.05 * (double)f, 0.5, 0.5, false, true);
        }
    }

    private static final class Flagpole
    extends NoOutlineNodeWorldObject
    implements RenderableToAllTargets {
        public Flagpole(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public void renderTo(Target<?> target) {
            target.drawColumn(Materials.STEEL, null, this.node.getElevationProfile().getWithEle(this.node.getPos()), WorldModuleParseUtil.parseHeight(this.node.getTags(), 10.0f), 0.15, 0.15, false, true);
        }
    }
}

