/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.AbstractAreaWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.modules.BridgeModule;
import org.osm2world.core.world.modules.TunnelModule;
import org.osm2world.core.world.modules.common.AbstractModule;

public class SurfaceAreaModule
extends AbstractModule {
    private static final Map<Tag, String> defaultSurfaceMap = new HashMap<Tag, String>();

    @Override
    protected void applyToArea(MapArea mapArea) {
        if (!mapArea.getRepresentations().isEmpty()) {
            return;
        }
        TagGroup tagGroup = mapArea.getTags();
        if (tagGroup.containsKey("surface")) {
            mapArea.addRepresentation(new SurfaceArea(mapArea, tagGroup.getValue("surface")));
        } else {
            for (Tag tag : defaultSurfaceMap.keySet()) {
                if (!tagGroup.contains(tag)) continue;
                mapArea.addRepresentation(new SurfaceArea(mapArea, defaultSurfaceMap.get(tag)));
            }
        }
    }

    static {
        defaultSurfaceMap.put(new Tag("leisure", "pitch"), "ground");
    }

    private class SurfaceArea
    extends AbstractAreaWorldObject
    implements RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        private final String surface;

        public SurfaceArea(MapArea mapArea, String string) {
            super(mapArea);
            this.surface = string;
        }

        public void renderTo(Target target) {
            Material material = Materials.getSurfaceMaterial(this.surface);
            if (material != null) {
                target.drawTriangles(material, this.getTriangulation());
            }
        }

        @Override
        public GroundState getGroundState() {
            if (BridgeModule.isBridge(this.area.getTags())) {
                return GroundState.ABOVE;
            }
            if (TunnelModule.isTunnel(this.area.getTags())) {
                return GroundState.BELOW;
            }
            return GroundState.ON;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }
    }
}

