/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import com.sun.opengl.util.texture.Texture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.target.povray.POVRayTarget;
import org.osm2world.core.target.povray.RenderableToPOVRay;
import org.osm2world.core.world.data.AreaWorldObject;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.data.WorldObject;
import org.osm2world.core.world.modules.common.AbstractModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;

public class TreeModule
extends AbstractModule {
    protected static Texture treeTexture;

    @Override
    protected void applyToNode(MapNode mapNode) {
        String string = mapNode.getTags().getValue("natural");
        if ("tree".equals(string)) {
            mapNode.addRepresentation(new Tree(mapNode, mapNode.getPos()));
        }
    }

    @Override
    protected void applyToWaySegment(MapWaySegment mapWaySegment) {
        if (mapWaySegment.getTags().contains(new Tag("natural", "tree_row"))) {
            mapWaySegment.addRepresentation(new TreeRow(mapWaySegment));
        }
    }

    @Override
    protected void applyToArea(MapArea mapArea) {
        if (mapArea.getTags().contains("natural", "wood") || mapArea.getTags().contains("landuse", "forest") || mapArea.getTags().containsKey("wood")) {
            mapArea.addRepresentation(new Forest(mapArea));
        }
    }

    private class Forest
    implements AreaWorldObject,
    RenderableToPOVRay,
    RenderableToAllTargets {
        private final MapArea area;
        private Collection<Tree> trees = null;

        public Forest(MapArea mapArea) {
            this.area = mapArea;
        }

        private void createTrees(double d) {
            ArrayList<WorldObject> arrayList = new ArrayList<WorldObject>();
            for (MapOverlap<?, ?> object2 : this.area.getOverlaps()) {
                for (WorldObject worldObject : object2.getOther(this.area).getRepresentations()) {
                    if (worldObject.getGroundState() != GroundState.ON) continue;
                    arrayList.add(worldObject);
                }
            }
            List<VectorXZ> list = GeometryUtil.randomlyDistributePointsOn(this.area.getPolygon(), d, 0.3f);
            this.trees = new ArrayList<Tree>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                VectorXZ vectorXZ = (VectorXZ)iterator.next();
                if (WorldModuleGeometryUtil.piercesWorldObject(vectorXZ, arrayList)) continue;
                this.trees.add(new Tree(this.area, vectorXZ));
            }
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.area;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 2.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public void renderTo(POVRayTarget pOVRayTarget) {
            if (this.trees == null) {
                this.createTrees(TreeModule.this.config.getDouble("treesPerSquareMeter", 0.01f));
            }
            for (Tree tree : this.trees) {
                tree.renderTo(pOVRayTarget);
            }
        }

        @Override
        public void addDeclarationsTo(POVRayTarget pOVRayTarget) {
        }

        @Override
        public void renderTo(Target<?> target) {
            if (this.trees == null) {
                this.createTrees(TreeModule.this.config.getDouble("treesPerSquareMeter", 0.001f));
            }
            for (Tree tree : this.trees) {
                tree.renderTo(target);
            }
        }
    }

    private static class TreeRow
    implements WaySegmentWorldObject,
    RenderableToAllTargets,
    RenderableToPOVRay {
        private final List<Tree> trees;
        private final MapWaySegment line;

        public TreeRow(MapWaySegment mapWaySegment) {
            this.line = mapWaySegment;
            List<VectorXZ> list = GeometryUtil.equallyDistributePointsAlong(4.0, false, mapWaySegment.getStartNode().getPos(), mapWaySegment.getEndNode().getPos());
            this.trees = new ArrayList<Tree>(list.size());
            for (VectorXZ vectorXZ : list) {
                this.trees.add(new Tree(mapWaySegment, vectorXZ));
            }
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.line;
        }

        @Override
        public VectorXZ getEndPosition() {
            return this.line.getEndNode().getPos();
        }

        @Override
        public VectorXZ getStartPosition() {
            return this.line.getStartNode().getPos();
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 5.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public void renderTo(Target<?> target) {
            for (Tree tree : this.trees) {
                tree.renderTo(target);
            }
        }

        @Override
        public void addDeclarationsTo(POVRayTarget pOVRayTarget) {
        }

        @Override
        public void renderTo(POVRayTarget pOVRayTarget) {
            for (Tree tree : this.trees) {
                tree.renderTo(pOVRayTarget);
            }
        }
    }

    private static class Tree
    implements NodeWorldObject,
    IntersectionTestObject,
    RenderableToAllTargets,
    RenderableToPOVRay {
        private static final float DEFAULT_HEIGHT = 10.0f;
        private static final float RADIUS_PER_HEIGHT = 0.2f;
        private final MapElement element;
        private final VectorXZ pos;
        private final float height;
        private static POVRayTarget previousDeclarationTarget = null;

        public Tree(MapElement mapElement, VectorXZ vectorXZ) {
            this.element = mapElement;
            this.pos = vectorXZ;
            float f = 1.0f;
            if (mapElement.getTags().contains("natural", "wood") || mapElement.getTags().contains("landuse", "forest")) {
                f = (float)((double)f + (-0.25 + 0.5 * Math.random()));
            }
            this.height = f * WorldModuleParseUtil.parseHeight(mapElement.getTags(), 10.0f);
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.element;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return this.height;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
            return new AxisAlignedBoundingBoxXZ(Collections.singleton(this.pos));
        }

        @Override
        public void renderTo(Target<?> target) {
            VectorXYZ vectorXYZ = this.element.getElevationProfile().getWithEle(this.pos);
            Tree.renderTree(target, vectorXYZ, this.isConiferous(), this.height);
        }

        @Override
        public void addDeclarationsTo(POVRayTarget pOVRayTarget) {
            if (pOVRayTarget != previousDeclarationTarget) {
                previousDeclarationTarget = pOVRayTarget;
                pOVRayTarget.append("#ifndef (broad_leaved_tree)\n");
                pOVRayTarget.append("#declare broad_leaved_tree = object { union {\n");
                Tree.renderTree(pOVRayTarget, VectorXYZ.NULL_VECTOR, false, 1.0);
                pOVRayTarget.append("} }\n#end\n\n");
                pOVRayTarget.append("#ifndef (coniferous_tree)\n");
                pOVRayTarget.append("#declare coniferous_tree = object { union {\n");
                Tree.renderTree(pOVRayTarget, VectorXYZ.NULL_VECTOR, true, 1.0);
                pOVRayTarget.append("} }\n#end\n\n");
            }
        }

        @Override
        public void renderTo(POVRayTarget pOVRayTarget) {
            float f = (float)Math.random() * 360.0f;
            if (this.isConiferous()) {
                pOVRayTarget.append("object { coniferous_tree rotate ");
            } else {
                pOVRayTarget.append("object { broad_leaved_tree rotate ");
            }
            pOVRayTarget.append(Float.toString(f));
            pOVRayTarget.append("*y scale ");
            pOVRayTarget.append(this.height);
            pOVRayTarget.append(" translate ");
            pOVRayTarget.appendVector(this.pos.x, 0.0, this.pos.z);
            pOVRayTarget.append(" }\n");
        }

        private static void renderTree(Target<?> target, VectorXYZ vectorXYZ, boolean bl, double d) {
            double d2 = bl ? 0.3 : 0.5;
            double d3 = d * (double)0.2f;
            target.drawColumn(Materials.TREE_TRUNK, null, vectorXYZ, d * d2, d3 / 4.0, d3 / 5.0, false, true);
            target.drawColumn(Materials.TREE_CROWN, null, vectorXYZ.y(vectorXYZ.y + d * d2), d * (1.0 - d2), d3, bl ? 0.0 : d3, true, true);
        }

        private boolean isConiferous() {
            String string = this.element.getTags().getValue("wood");
            if (string == null) {
                string = this.element.getTags().getValue("type");
            }
            if ("broad_leaved".equals(string) || "deciduous".equals(string)) {
                return false;
            }
            if ("coniferous".equals(string)) {
                return true;
            }
            return (long)this.pos.getX() % 2L == 0L;
        }
    }
}

