/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.osm2world.core.map_data.data.MapAreaSegment;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.data.WorldObject;
import org.osm2world.core.world.modules.common.AbstractModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.network.AbstractNetworkWaySegmentWorldObject;
import org.osm2world.core.world.network.JunctionNodeWorldObject;
import org.osm2world.core.world.network.VisibleConnectorNodeWorldObject;

public class TunnelModule
extends AbstractModule {
    public static final boolean isTunnel(TagGroup tagGroup) {
        return tagGroup.containsKey("tunnel") && !"no".equals(tagGroup.getValue("tunnel"));
    }

    public static final boolean isTunnel(MapSegment mapSegment) {
        if (mapSegment instanceof MapWaySegment) {
            return TunnelModule.isTunnel(((MapWaySegment)mapSegment).getTags());
        }
        return TunnelModule.isTunnel(((MapAreaSegment)mapSegment).getArea().getTags());
    }

    @Override
    protected void applyToWaySegment(MapWaySegment mapWaySegment) {
        WaySegmentWorldObject waySegmentWorldObject = mapWaySegment.getPrimaryRepresentation();
        if (waySegmentWorldObject instanceof AbstractNetworkWaySegmentWorldObject && TunnelModule.isTunnel(mapWaySegment)) {
            mapWaySegment.addRepresentation(new Tunnel(mapWaySegment, (AbstractNetworkWaySegmentWorldObject)waySegmentWorldObject));
        }
    }

    @Override
    protected void applyToNode(MapNode mapNode) {
        if (mapNode.getConnectedWaySegments().size() == 2) {
            MapWaySegment mapWaySegment = mapNode.getConnectedWaySegments().get(0);
            MapWaySegment mapWaySegment2 = mapNode.getConnectedWaySegments().get(1);
            if (TunnelModule.isTunnel(mapWaySegment) && !TunnelModule.isTunnel(mapWaySegment2) && mapWaySegment.getPrimaryRepresentation() instanceof AbstractNetworkWaySegmentWorldObject) {
                mapNode.addRepresentation(new TunnelEntrance(mapNode, mapWaySegment));
            } else if (TunnelModule.isTunnel(mapWaySegment2) && !TunnelModule.isTunnel(mapWaySegment) && mapWaySegment2.getPrimaryRepresentation() instanceof AbstractNetworkWaySegmentWorldObject) {
                mapNode.addRepresentation(new TunnelEntrance(mapNode, mapWaySegment2));
            }
        }
        boolean bl = true;
        for (MapWaySegment mapWaySegment : mapNode.getConnectedWaySegments()) {
            if (TunnelModule.isTunnel(mapWaySegment)) continue;
            bl = false;
            break;
        }
        if (bl && !(mapNode.getPrimaryRepresentation() instanceof VisibleConnectorNodeWorldObject) && mapNode.getPrimaryRepresentation() instanceof JunctionNodeWorldObject) {
            mapNode.addRepresentation(new TunnelJunction(mapNode, (JunctionNodeWorldObject)mapNode.getPrimaryRepresentation()));
        }
    }

    public static class TunnelJunction
    implements NodeWorldObject,
    RenderableToAllTargets {
        private final MapNode node;
        private final JunctionNodeWorldObject primaryRep;

        public TunnelJunction(MapNode mapNode, JunctionNodeWorldObject junctionNodeWorldObject) {
            this.node = mapNode;
            this.primaryRep = junctionNodeWorldObject;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return this.primaryRep.getClearingAbove(vectorXZ) + 1.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.BELOW;
        }

        @Override
        public void renderTo(Target<?> target) {
            ArrayList arrayList = new ArrayList();
            int n = this.node.getConnectedSegments().size();
            for (int i = 0; i < n; ++i) {
                List<VectorXYZ> list = this.primaryRep.getOutline((i + 1) % n, i);
                ArrayList<VectorXYZ> arrayList2 = new ArrayList<VectorXYZ>(list.size());
                for (VectorXYZ vectorXYZ : list) {
                    double d;
                    MapSegment mapSegment;
                    if (list.indexOf(vectorXYZ) == 0) {
                        mapSegment = this.node.getConnectedSegments().get((i + 1) % n);
                        d = TunnelJunction.clearingAboveMapSegment(vectorXYZ, mapSegment);
                    } else {
                        mapSegment = this.node.getConnectedSegments().get(i);
                        d = TunnelJunction.clearingAboveMapSegment(vectorXYZ, mapSegment);
                    }
                    arrayList2.add(vectorXYZ.y(vectorXYZ.y + d));
                }
                target.drawTriangleStrip((Material)Materials.TUNNEL_DEFAULT, WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list, arrayList2));
                arrayList.addAll(arrayList2);
            }
            target.drawPolygon(Materials.TUNNEL_DEFAULT, arrayList.toArray(new VectorXYZ[0]));
        }

        private static double clearingAboveMapSegment(VectorXYZ vectorXYZ, MapSegment mapSegment) {
            WorldObject worldObject = mapSegment instanceof MapWaySegment ? ((MapWaySegment)mapSegment).getPrimaryRepresentation() : ((MapAreaSegment)mapSegment).getArea().getPrimaryRepresentation();
            if (worldObject != null) {
                return worldObject.getClearingAbove(vectorXYZ.xz());
            }
            return 0.0;
        }
    }

    public static class TunnelEntrance
    implements NodeWorldObject,
    TerrainBoundaryWorldObject {
        private final MapNode node;
        private final MapWaySegment tunnelSegment;

        public TunnelEntrance(MapNode mapNode, MapWaySegment mapWaySegment) {
            this.node = mapNode;
            this.tunnelSegment = mapWaySegment;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.node;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
            return new AxisAlignedBoundingBoxXZ(this.getOutlinePolygon().getVertices());
        }

        @Override
        public PolygonXYZ getOutlinePolygon() {
            AbstractNetworkWaySegmentWorldObject abstractNetworkWaySegmentWorldObject = (AbstractNetworkWaySegmentWorldObject)this.tunnelSegment.getPrimaryRepresentation();
            VectorXZ vectorXZ = abstractNetworkWaySegmentWorldObject.getCutVectorAt(this.node).mult(abstractNetworkWaySegmentWorldObject.getWidth() * 0.5f);
            VectorXZ vectorXZ2 = this.tunnelSegment.getDirection();
            if (this.tunnelSegment.getEndNode() == this.node) {
                vectorXZ2 = vectorXZ2.invert();
            }
            VectorXYZ vectorXYZ = vectorXZ2.mult(0.1).xyz(abstractNetworkWaySegmentWorldObject.getClearingAbove(this.node.getPos()));
            ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(5);
            VectorXYZ vectorXYZ2 = this.node.getPos().add(vectorXZ).xyz(this.node.getElevationProfile().getMinEle());
            VectorXYZ vectorXYZ3 = this.node.getPos().subtract(vectorXZ).xyz(this.node.getElevationProfile().getMinEle());
            arrayList.add(vectorXYZ2);
            arrayList.add(vectorXYZ3);
            arrayList.add(vectorXYZ3.add(vectorXYZ));
            arrayList.add(vectorXYZ2.add(vectorXYZ));
            arrayList.add(vectorXYZ2);
            return new PolygonXYZ(arrayList);
        }
    }

    public static class Tunnel
    implements WaySegmentWorldObject,
    RenderableToAllTargets {
        private final MapWaySegment segment;
        private final AbstractNetworkWaySegmentWorldObject primaryRep;

        public Tunnel(MapWaySegment mapWaySegment, AbstractNetworkWaySegmentWorldObject abstractNetworkWaySegmentWorldObject) {
            this.segment = mapWaySegment;
            this.primaryRep = abstractNetworkWaySegmentWorldObject;
        }

        @Override
        public MapElement getPrimaryMapElement() {
            return this.segment;
        }

        @Override
        public VectorXZ getEndPosition() {
            return this.primaryRep.getEndPosition();
        }

        @Override
        public VectorXZ getStartPosition() {
            return this.primaryRep.getStartPosition();
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return this.primaryRep.getClearingAbove(vectorXZ) + 1.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ABOVE;
        }

        @Override
        public void renderTo(Target<?> target) {
            VectorXYZ[] vectorXYZArray;
            List<VectorXYZ> list = this.primaryRep.getOutline(false);
            List<VectorXYZ> list2 = this.primaryRep.getOutline(true);
            ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(list.size());
            ArrayList<VectorXYZ> arrayList2 = new ArrayList<VectorXYZ>(list2.size());
            for (int i = 0; i < list.size(); ++i) {
                vectorXYZArray = VectorXYZ.Y_UNIT.mult(this.primaryRep.getClearingAbove(list.get(i).xz()));
                arrayList.add(list.get(i).add((VectorXYZ)vectorXYZArray));
                arrayList2.add(list2.get(i).add((VectorXYZ)vectorXYZArray));
            }
            VectorXYZ[] vectorXYZArray2 = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list2, arrayList2);
            vectorXYZArray = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(arrayList2, arrayList);
            VectorXYZ[] vectorXYZArray3 = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(arrayList, list);
            target.drawTriangleStrip((Material)Materials.TUNNEL_DEFAULT, vectorXYZArray2);
            target.drawTriangleStrip((Material)Materials.TUNNEL_DEFAULT, vectorXYZArray);
            target.drawTriangleStrip((Material)Materials.TUNNEL_DEFAULT, vectorXYZArray3);
        }
    }
}

