/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.RenderableToAllTargets;
import org.osm2world.core.target.Target;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.util.Predicates;
import org.osm2world.core.world.data.AbstractAreaWorldObject;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.modules.BridgeModule;
import org.osm2world.core.world.modules.TunnelModule;
import org.osm2world.core.world.modules.common.ConfigurableWorldModule;
import org.osm2world.core.world.modules.common.WorldModuleGeometryUtil;
import org.osm2world.core.world.modules.common.WorldModuleParseUtil;
import org.osm2world.core.world.network.AbstractNetworkWaySegmentWorldObject;
import org.osm2world.core.world.network.JunctionNodeWorldObject;
import org.osm2world.core.world.network.NetworkAreaWorldObject;

public class WaterModule
extends ConfigurableWorldModule {
    private static final Tag WATER_TAG = new Tag("natural", "water");
    private static final Tag RIVERBANK_TAG = new Tag("waterway", "riverbank");
    private static final Map<String, Float> WATERWAY_WIDTHS = new HashMap<String, Float>();

    @Override
    public void applyTo(MapData mapData) {
        for (MapWaySegment mapElement : mapData.getMapWaySegments()) {
            for (String string : WATERWAY_WIDTHS.keySet()) {
                if (!mapElement.getTags().contains("waterway", string)) continue;
                mapElement.addRepresentation(new Waterway(mapElement));
            }
        }
        for (MapNode mapNode : mapData.getMapNodes()) {
            int n = 0;
            for (MapWaySegment mapWaySegment : mapNode.getConnectedWaySegments()) {
                if (!Iterables.any(mapWaySegment.getRepresentations(), Predicates.hasType(Waterway.class))) continue;
                ++n;
            }
            if (n <= 2) continue;
            mapNode.addRepresentation(new RiverJunction(mapNode));
        }
        for (MapArea mapArea : mapData.getMapAreas()) {
            if (mapArea.getTags().contains(WATER_TAG) || mapArea.getTags().contains(RIVERBANK_TAG)) {
                mapArea.addRepresentation(new Water(mapArea));
            }
            if (!mapArea.getTags().contains("amenity", "fountain")) continue;
            mapArea.addRepresentation(new AreaFountain(mapArea));
        }
    }

    static {
        WATERWAY_WIDTHS.put("river", Float.valueOf(3.0f));
        WATERWAY_WIDTHS.put("stream", Float.valueOf(0.5f));
        WATERWAY_WIDTHS.put("canal", Float.valueOf(2.0f));
        WATERWAY_WIDTHS.put("ditch", Float.valueOf(1.0f));
        WATERWAY_WIDTHS.put("drain", Float.valueOf(1.0f));
    }

    private static class AreaFountain
    extends AbstractAreaWorldObject
    implements RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        public AreaFountain(MapArea mapArea) {
            super(mapArea);
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public void renderTo(Target<?> target) {
            target.drawTriangles(Materials.WATER, this.getTriangulation());
            double d = 0.1;
            double d2 = 0.5;
            VectorXYZ[] vectorXYZArray = new VectorXYZ[]{new VectorXYZ(-d / 2.0, 0.0, 0.0), new VectorXYZ(-d / 2.0, d2, 0.0), new VectorXYZ(d / 2.0, d2, 0.0), new VectorXYZ(d / 2.0, 0.0, 0.0)};
            List<VectorXYZ> list = this.area.getElevationProfile().getWithEle(this.area.getOuterPolygon().getVertexLoop());
            List<VectorXYZ[]> list2 = WorldModuleGeometryUtil.createShapeExtrusionAlong(vectorXYZArray, list, Collections.nCopies(list.size(), VectorXYZ.Y_UNIT));
            for (VectorXYZ[] vectorXYZArray2 : list2) {
                target.drawTriangleStrip((Material)Materials.ASPHALT, vectorXYZArray2);
            }
        }
    }

    public static class Water
    extends NetworkAreaWorldObject
    implements RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        public Water(MapArea mapArea) {
            super(mapArea);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.5;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public void renderTo(Target<?> target) {
            target.drawTriangles(Materials.WATER, this.getTriangulation());
        }
    }

    public static class RiverJunction
    extends JunctionNodeWorldObject
    implements NodeWorldObject,
    TerrainBoundaryWorldObject,
    RenderableToAllTargets {
        public RiverJunction(MapNode mapNode) {
            super(mapNode);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.5;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            return GroundState.ON;
        }

        @Override
        public void renderTo(Target<?> target) {
            List<VectorXYZ> list = this.getOutlinePolygon().getVertices();
            VectorXYZ[] vectorXYZArray = list.toArray(new VectorXYZ[list.size()]);
            target.drawPolygon(Materials.WATER, vectorXYZArray);
        }
    }

    public static class Waterway
    extends AbstractNetworkWaySegmentWorldObject
    implements RenderableToAllTargets,
    TerrainBoundaryWorldObject {
        public Waterway(MapWaySegment mapWaySegment) {
            super(mapWaySegment);
        }

        @Override
        public double getClearingAbove(VectorXZ vectorXZ) {
            return 0.5;
        }

        @Override
        public double getClearingBelow(VectorXZ vectorXZ) {
            return 0.0;
        }

        @Override
        public GroundState getGroundState() {
            if (BridgeModule.isBridge(this.line.getTags())) {
                return GroundState.ABOVE;
            }
            if (TunnelModule.isTunnel(this.line.getTags())) {
                return GroundState.BELOW;
            }
            return GroundState.ON;
        }

        @Override
        public float getWidth() {
            return WorldModuleParseUtil.parseWidth(this.line.getTags(), ((Float)WATERWAY_WIDTHS.get(this.line.getTags().getValue("waterway"))).floatValue());
        }

        @Override
        public PolygonXYZ getOutlinePolygon() {
            if (this.isContainedWithinRiverbank()) {
                return null;
            }
            return super.getOutlinePolygon();
        }

        @Override
        public void renderTo(Target<?> target) {
            if (!this.isContainedWithinRiverbank()) {
                List<VectorXYZ> list = this.getOutline(false);
                List<VectorXYZ> list2 = this.getOutline(true);
                List<VectorXYZ> list3 = WorldModuleGeometryUtil.createLineBetween(list, list2, 0.05f);
                List<VectorXYZ> list4 = WorldModuleGeometryUtil.createLineBetween(list, list2, 0.95f);
                Waterway.modifyLineHeight(list3, -0.2f);
                Waterway.modifyLineHeight(list4, -0.2f);
                List<VectorXYZ> list5 = WorldModuleGeometryUtil.createLineBetween(list, list2, 0.35f);
                List<VectorXYZ> list6 = WorldModuleGeometryUtil.createLineBetween(list, list2, 0.65f);
                Waterway.modifyLineHeight(list5, -1.0f);
                Waterway.modifyLineHeight(list6, -1.0f);
                target.drawTriangleStrip((Material)Materials.TERRAIN_DEFAULT, WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list, list3));
                target.drawTriangleStrip((Material)Materials.TERRAIN_DEFAULT, WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list3, list5));
                target.drawTriangleStrip((Material)Materials.TERRAIN_DEFAULT, WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list5, list6));
                target.drawTriangleStrip((Material)Materials.TERRAIN_DEFAULT, WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list6, list4));
                target.drawTriangleStrip((Material)Materials.TERRAIN_DEFAULT, WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list4, list2));
                VectorXYZ[] vectorXYZArray = WorldModuleGeometryUtil.createVectorsForTriangleStripBetween(list3, list4);
                target.drawTriangleStrip((Material)Materials.WATER, vectorXYZArray);
            }
        }

        private boolean isContainedWithinRiverbank() {
            boolean bl = false;
            for (MapOverlap<?, ?> mapOverlap : this.line.getOverlaps()) {
                MapArea mapArea;
                if (!(mapOverlap.getOther(this.line) instanceof MapArea) || !((mapArea = (MapArea)mapOverlap.getOther(this.line)).getPrimaryRepresentation() instanceof Water) || !mapArea.getPolygon().contains(this.line.getLineSegment())) continue;
                bl = true;
                break;
            }
            return bl;
        }

        private static void modifyLineHeight(List<VectorXYZ> list, float f) {
            for (int i = 0; i < list.size(); ++i) {
                VectorXYZ vectorXYZ = list.get(i);
                list.set(i, vectorXYZ.y(vectorXYZ.y + (double)f));
            }
        }
    }
}

