/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.modules.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.world.data.WorldObject;
import org.osm2world.core.world.data.WorldObjectWithOutline;

public final class WorldModuleGeometryUtil {
    private WorldModuleGeometryUtil() {
    }

    public static final VectorXYZ[] createVectorsForVerticalTriangleStrip(List<? extends VectorXYZ> list, float f, float f2) {
        VectorXYZ[] vectorXYZArray = new VectorXYZ[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            VectorXYZ vectorXYZ = list.get(i);
            vectorXYZArray[i * 2] = new VectorXYZ(vectorXYZ.getX(), vectorXYZ.getY() + (double)f, vectorXYZ.getZ());
            vectorXYZArray[i * 2 + 1] = new VectorXYZ(vectorXYZ.getX(), vectorXYZ.getY() + (double)f2, vectorXYZ.getZ());
        }
        return vectorXYZArray;
    }

    public static final VectorXYZ[] createVectorsForTriangleStripBetween(List<? extends VectorXYZ> list, List<? extends VectorXYZ> list2) {
        assert (list.size() == list2.size());
        VectorXYZ[] vectorXYZArray = new VectorXYZ[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            vectorXYZArray[i * 2] = list.get(i);
            vectorXYZArray[i * 2 + 1] = list2.get(i);
        }
        return vectorXYZArray;
    }

    public static final List<VectorXYZ> createLineBetween(List<VectorXYZ> list, List<VectorXYZ> list2, float f) {
        assert (list.size() == list2.size());
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(GeometryUtil.interpolateBetween(list.get(i), list2.get(i), (double)f));
        }
        return arrayList;
    }

    public static final List<VectorXYZ[]> createShapeExtrusionAlong(VectorXYZ[] vectorXYZArray, List<VectorXYZ> list, List<VectorXYZ> list2) {
        Object object;
        int n;
        if (list.size() < 2) {
            throw new IllegalArgumentException("extrusion path needs at least 2 nodes");
        }
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("extrusionPath and upVectors must have same size");
        }
        VectorXYZ[][] vectorXYZArray2 = new VectorXYZ[list.size()][vectorXYZArray.length];
        vectorXYZArray2[0] = WorldModuleGeometryUtil.transformShape(vectorXYZArray, list.get(0), list.get(1).subtract(list.get(0)).normalize(), list2.get(0));
        for (n = 1; n < list.size() - 1; ++n) {
            object = list.get(n + 1).subtract(list.get(n - 1));
            object = ((VectorXYZ)object).normalize();
            vectorXYZArray2[n] = WorldModuleGeometryUtil.transformShape(vectorXYZArray, list.get(n), (VectorXYZ)object, list2.get(n));
        }
        n = list.size() - 1;
        vectorXYZArray2[n] = WorldModuleGeometryUtil.transformShape(vectorXYZArray, list.get(n), list.get(n).subtract(list.get(n - 1)).normalize(), list2.get(n));
        object = new ArrayList(vectorXYZArray.length - 1);
        int n2 = 0;
        while (n2 + 1 < vectorXYZArray.length) {
            VectorXYZ[] vectorXYZArray3 = new VectorXYZ[2 * vectorXYZArray2.length];
            for (int i = 0; i < vectorXYZArray2.length; ++i) {
                vectorXYZArray3[i * 2 + 1] = vectorXYZArray2[i][n2];
                vectorXYZArray3[i * 2 + 0] = vectorXYZArray2[i][n2 + 1];
            }
            object.add(vectorXYZArray3);
            ++n2;
        }
        return object;
    }

    public static final VectorXYZ[] transformShape(VectorXYZ[] vectorXYZArray, VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, VectorXYZ vectorXYZ3) {
        VectorXYZ[] vectorXYZArray2 = new VectorXYZ[vectorXYZArray.length];
        VectorXYZ vectorXYZ4 = vectorXYZ2.cross(vectorXYZ3);
        double[][] dArrayArray = new double[][]{{vectorXYZ4.x, vectorXYZ4.y, vectorXYZ4.z}, {vectorXYZ3.x, vectorXYZ3.y, vectorXYZ3.z}, {vectorXYZ2.x, vectorXYZ2.y, vectorXYZ2.z}};
        for (int i = 0; i < vectorXYZArray.length; ++i) {
            VectorXYZ vectorXYZ5 = vectorXYZArray[i];
            vectorXYZ5 = new VectorXYZ(dArrayArray[0][0] * vectorXYZ5.x + dArrayArray[1][0] * vectorXYZ5.y + dArrayArray[2][0] * vectorXYZ5.z, dArrayArray[0][1] * vectorXYZ5.x + dArrayArray[1][1] * vectorXYZ5.y + dArrayArray[2][1] * vectorXYZ5.z, dArrayArray[0][2] * vectorXYZ5.x + dArrayArray[1][2] * vectorXYZ5.y + dArrayArray[2][2] * vectorXYZ5.z);
            vectorXYZArray2[i] = vectorXYZ5 = vectorXYZ5.add(vectorXYZ);
        }
        return vectorXYZArray2;
    }

    public static final boolean piercesWorldObject(VectorXZ vectorXZ, Collection<WorldObject> collection) {
        for (WorldObject worldObject : collection) {
            PolygonXYZ polygonXYZ;
            if (worldObject.getGroundState() != GroundState.ON || !(worldObject instanceof WorldObjectWithOutline) || (polygonXYZ = ((WorldObjectWithOutline)worldObject).getOutlinePolygon()) == null || !polygonXYZ.getXZPolygon().isSimple() || !polygonXYZ.getSimpleXZPolygon().contains(vectorXZ)) continue;
            return true;
        }
        return false;
    }
}

